/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.AbstractCriteria;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.query.PaginationUtils;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.event.Event;
import org.apache.skywalking.oap.server.core.query.type.event.EventQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.event.EventType;
import org.apache.skywalking.oap.server.core.query.type.event.Events;
import org.apache.skywalking.oap.server.core.query.type.event.Source;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBEventQueryDAO
extends AbstractBanyanDBDAO
implements IEventQueryDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"uuid", (Object)"service", (Object)"service_instance", (Object)"endpoint", (Object)"name", (Object)"message", (Object[])new String[]{"type", "start_time", "end_time", "parameters", "layer"});

    public BanyanDBEventQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public Events queryEvents(EventQueryCondition condition) throws Exception {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata("events", DownSampling.Minute);
        Duration time = condition.getTime();
        TimestampRange tsRange = null;
        if (time != null) {
            long startTB = time.getStartTimeBucketInSec();
            long endTB = time.getEndTimeBucketInSec();
            if (startTB > 0L && endTB > 0L) {
                tsRange = new TimestampRange(TimeBucket.getTimestamp((long)startTB), TimeBucket.getTimestamp((long)endTB));
            }
        }
        MeasureQueryResponse resp = this.query(schema, TAGS, Collections.emptySet(), tsRange, this.buildQuery(Collections.singletonList(condition)));
        Events events = new Events();
        if (resp.size() == 0) {
            return events;
        }
        for (DataPoint dataPoint : resp.getDataPoints()) {
            events.getEvents().add(this.buildEventView(dataPoint));
        }
        return events;
    }

    public Events queryEvents(List<EventQueryCondition> conditionList) throws Exception {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata("events", DownSampling.Minute);
        Duration time = conditionList.get(0).getTime();
        TimestampRange tsRange = null;
        if (time != null) {
            long startTB = time.getStartTimeBucketInSec();
            long endTB = time.getEndTimeBucketInSec();
            if (startTB > 0L && endTB > 0L) {
                tsRange = new TimestampRange(TimeBucket.getTimestamp((long)startTB), TimeBucket.getTimestamp((long)endTB));
            }
        }
        MeasureQueryResponse resp = this.query(schema, TAGS, Collections.emptySet(), tsRange, this.buildQuery(conditionList));
        Events events = new Events();
        if (resp.size() == 0) {
            return events;
        }
        for (DataPoint dataPoint : resp.getDataPoints()) {
            events.getEvents().add(this.buildEventView(dataPoint));
        }
        return events;
    }

    public AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> buildQuery(final List<EventQueryCondition> conditionList) {
        EventQueryCondition condition = conditionList.get(0);
        final Order queryOrder = Objects.isNull(condition.getOrder()) ? Order.DES : condition.getOrder();
        final PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(condition.getPaging());
        return new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                ArrayList<AbstractCriteria> eventsQueryConditions = new ArrayList<AbstractCriteria>(conditionList.size());
                query.limit(page.getLimit());
                query.offset(page.getFrom());
                if (queryOrder == Order.ASC) {
                    query.setOrderBy(new AbstractQuery.OrderBy("start_time", AbstractQuery.Sort.ASC));
                } else {
                    query.setOrderBy(new AbstractQuery.OrderBy("start_time", AbstractQuery.Sort.DESC));
                }
                for (EventQueryCondition condition : conditionList) {
                    Source source;
                    ArrayList<Object> queryConditions = new ArrayList<Object>();
                    if (!Strings.isNullOrEmpty((String)condition.getUuid())) {
                        queryConditions.add(this.eq("uuid", condition.getUuid()));
                    }
                    if ((source = condition.getSource()) != null) {
                        if (!Strings.isNullOrEmpty((String)source.getService())) {
                            queryConditions.add(this.eq("service", source.getService()));
                        }
                        if (!Strings.isNullOrEmpty((String)source.getServiceInstance())) {
                            queryConditions.add(this.eq("service_instance", source.getServiceInstance()));
                        }
                        if (!Strings.isNullOrEmpty((String)source.getEndpoint())) {
                            queryConditions.add(this.eq("endpoint", source.getEndpoint()));
                        }
                    }
                    if (!Strings.isNullOrEmpty((String)condition.getName())) {
                        queryConditions.add(this.eq("name", condition.getName()));
                    }
                    if (condition.getType() != null) {
                        queryConditions.add(this.eq("type", condition.getType().name()));
                    }
                    if (!Strings.isNullOrEmpty((String)condition.getLayer())) {
                        queryConditions.add(this.eq("layer", Layer.valueOf((String)condition.getLayer()).value()));
                    }
                    eventsQueryConditions.add(this.and(queryConditions));
                }
                if (eventsQueryConditions.size() == 1) {
                    query.criteria((AbstractCriteria)eventsQueryConditions.get(0));
                } else if (eventsQueryConditions.size() > 1) {
                    query.criteria(this.or(eventsQueryConditions));
                }
            }
        };
    }

    protected Event buildEventView(DataPoint dataPoint) {
        Event event = new Event();
        event.setUuid((String)dataPoint.getTagValue("uuid"));
        String service = this.getValueOrDefault(dataPoint, "service", "");
        String serviceInstance = this.getValueOrDefault(dataPoint, "service_instance", "");
        String endpoint = this.getValueOrDefault(dataPoint, "endpoint", "");
        event.setSource(new Source(service, serviceInstance, endpoint));
        event.setName((String)dataPoint.getTagValue("name"));
        event.setType(EventType.parse((String)((String)dataPoint.getTagValue("type"))));
        event.setMessage((String)dataPoint.getTagValue("message"));
        event.setParameters((String)dataPoint.getTagValue("parameters"));
        event.setStartTime(((Long)dataPoint.getTagValue("start_time")).longValue());
        event.setEndTime(((Long)dataPoint.getTagValue("end_time")).longValue());
        event.setLayer(Layer.valueOf((int)((Number)dataPoint.getTagValue("layer")).intValue()).name());
        return event;
    }

    private <T> T getValueOrDefault(DataPoint dataPoint, String tagName, T defaultValue) {
        Object v = dataPoint.getTagValue(tagName);
        return (T)(v == null ? defaultValue : v);
    }
}

