/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.module;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;

public class TerminalFriendlyTable {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private final String description;
    private final List<Row> rows = new ArrayList<Row>(20);
    private int maxLengthOfCol1 = 0;
    private int maxLengthOfCol2 = 0;

    public void addRow(Row row) {
        boolean replaced = false;
        for (int i = 0; i < this.rows.size(); ++i) {
            Row e = this.rows.get(i);
            if (!e.col1.equals(row.col1)) continue;
            e.col2 = row.col2;
            replaced = true;
            row = e;
            break;
        }
        if (!replaced) {
            this.rows.add(row);
        }
        if (row.col1.length() > this.maxLengthOfCol1) {
            this.maxLengthOfCol1 = row.col1.length();
        }
        if (row.col2 != null && row.col2.length() > this.maxLengthOfCol2) {
            this.maxLengthOfCol2 = row.col2.length();
        }
    }

    public String toString() {
        this.rows.sort(Comparator.comparing(a -> a.col1));
        StringBuilder output = new StringBuilder(this.description).append(LINE_SEPARATOR).append(LINE_SEPARATOR);
        String format = "%-" + (this.maxLengthOfCol1 + 3) + "s |   %-" + this.maxLengthOfCol2 + "s";
        this.rows.forEach(row -> output.append(String.format(format, row.getCol1(), row.getCol2())).append(LINE_SEPARATOR));
        return output.toString();
    }

    @Generated
    public TerminalFriendlyTable(String description) {
        this.description = description;
    }

    public static final class Row {
        private final String col1;
        private String col2;

        public Row(String col1, String col2) {
            if (col1 == null) {
                throw new IllegalArgumentException("Column 1 can't be null.");
            }
            this.col1 = col1;
            this.col2 = col2;
        }

        @Generated
        public String getCol1() {
            return this.col1;
        }

        @Generated
        public String getCol2() {
            return this.col2;
        }
    }
}

