/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.SessionCacheCallback;
import org.apache.skywalking.oap.server.library.client.request.InsertRequest;
import org.apache.skywalking.oap.server.library.client.request.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLExecutor
implements InsertRequest,
UpdateRequest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SQLExecutor.class);
    private final String sql;
    private final List<Object> param;
    private final SessionCacheCallback callback;
    private List<SQLExecutor> additionalSQLs;

    public void invoke(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(this.sql);
        this.setParameters(preparedStatement);
        if (log.isDebugEnabled()) {
            log.debug("Executing sql in batch: {}, parameters: {}", (Object)this.sql, this.param);
        }
        preparedStatement.execute();
        if (this.additionalSQLs != null) {
            for (SQLExecutor sqlExecutor : this.additionalSQLs) {
                sqlExecutor.invoke(connection);
            }
        }
    }

    public void setParameters(PreparedStatement preparedStatement) throws SQLException {
        for (int i = 0; i < this.param.size(); ++i) {
            preparedStatement.setObject(i + 1, this.param.get(i));
        }
    }

    public String toString() {
        return this.sql;
    }

    public void appendAdditionalSQLs(List<SQLExecutor> sqlExecutors) {
        if (this.additionalSQLs == null) {
            this.additionalSQLs = new ArrayList<SQLExecutor>();
        }
        this.additionalSQLs.addAll(sqlExecutors);
    }

    public void onInsertCompleted() {
        if (this.callback != null) {
            this.callback.onInsertCompleted();
        }
    }

    public void onUpdateFailure() {
        if (this.callback != null) {
            this.callback.onUpdateFailure();
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLExecutor)) {
            return false;
        }
        SQLExecutor other = (SQLExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sql = this.sql;
        String other$sql = other.sql;
        return !(this$sql == null ? other$sql != null : !this$sql.equals(other$sql));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SQLExecutor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sql = this.sql;
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        return result;
    }

    @Generated
    public SQLExecutor(String sql, List<Object> param, SessionCacheCallback callback) {
        this.sql = sql;
        this.param = param;
        this.callback = callback;
    }

    @Generated
    public List<Object> getParam() {
        return this.param;
    }

    @Generated
    public List<SQLExecutor> getAdditionalSQLs() {
        return this.additionalSQLs;
    }
}

