/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.otel.otlp;

import io.grpc.BindableService;
import io.grpc.stub.StreamObserver;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceResponse;
import io.opentelemetry.proto.collector.metrics.v1.MetricsServiceGrpc;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.receiver.otel.Handler;
import org.apache.skywalking.oap.server.receiver.otel.otlp.OpenTelemetryMetricRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryMetricHandler
extends MetricsServiceGrpc.MetricsServiceImplBase
implements Handler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenTelemetryMetricHandler.class);
    private final ModuleManager manager;
    private final OpenTelemetryMetricRequestProcessor metricRequestProcessor;

    @Override
    public String type() {
        return "otlp-metrics";
    }

    @Override
    public void active() throws ModuleStartException {
        GRPCHandlerRegister grpcHandlerRegister = (GRPCHandlerRegister)this.manager.find("receiver-sharing-server").provider().getService(GRPCHandlerRegister.class);
        grpcHandlerRegister.addHandler((BindableService)this);
    }

    public void export(ExportMetricsServiceRequest requests, StreamObserver<ExportMetricsServiceResponse> responseObserver) {
        this.metricRequestProcessor.processMetricsRequest(requests);
        responseObserver.onNext((Object)ExportMetricsServiceResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }

    @Generated
    public OpenTelemetryMetricHandler(ModuleManager manager, OpenTelemetryMetricRequestProcessor metricRequestProcessor) {
        this.manager = manager;
        this.metricRequestProcessor = metricRequestProcessor;
    }
}

