/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.viz.extension.photoFilter;

import org.apache.sedona.viz.core.PhotoFilter;

public class GaussianBlur
extends PhotoFilter {
    double stdev = 0.5;

    public GaussianBlur(int blurRadius) {
        super(blurRadius);
        int y;
        int x;
        double originalConvolutionMatrixSum = 0.0;
        for (x = -this.filterRadius; x <= this.filterRadius; ++x) {
            for (y = -this.filterRadius; y <= this.filterRadius; ++y) {
                this.convolutionMatrix[x + this.filterRadius][y + this.filterRadius] = Math.exp((double)(-(x * x + y * y)) / (2.0 * this.stdev * this.stdev)) / (2.0 * this.stdev * this.stdev * Math.PI);
                originalConvolutionMatrixSum += this.convolutionMatrix[x + this.filterRadius][y + this.filterRadius].doubleValue();
            }
        }
        for (x = -this.filterRadius; x <= this.filterRadius; ++x) {
            for (y = -this.filterRadius; y <= this.filterRadius; ++y) {
                this.convolutionMatrix[x + this.filterRadius][y + this.filterRadius] = this.convolutionMatrix[x + this.filterRadius][y + this.filterRadius] / originalConvolutionMatrixSum;
            }
        }
    }
}

