/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape.impl;

import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.BaseShape;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class CircleImpl
extends BaseShape<SpatialContext>
implements Circle {
    protected final Point point;
    protected double radiusDEG;
    protected Rectangle enclosingBox;

    public CircleImpl(Point p, double radiusDEG, SpatialContext ctx) {
        super(ctx);
        this.point = p;
        this.radiusDEG = this.point.isEmpty() ? Double.NaN : radiusDEG;
        this.enclosingBox = this.point.isEmpty() ? ctx.makeRectangle(Double.NaN, Double.NaN, Double.NaN, Double.NaN) : ctx.getDistCalc().calcBoxByDistFromPt(this.point, this.radiusDEG, ctx, null);
    }

    @Override
    public void reset(double x, double y, double radiusDEG) {
        assert (!this.isEmpty());
        this.point.reset(x, y);
        this.radiusDEG = radiusDEG;
        this.enclosingBox = this.ctx.getDistCalc().calcBoxByDistFromPt(this.point, this.radiusDEG, this.ctx, this.enclosingBox);
    }

    @Override
    public boolean isEmpty() {
        return this.point.isEmpty();
    }

    @Override
    public Point getCenter() {
        return this.point;
    }

    @Override
    public double getRadius() {
        return this.radiusDEG;
    }

    @Override
    public double getArea(SpatialContext ctx) {
        if (ctx == null) {
            return Math.PI * this.radiusDEG * this.radiusDEG;
        }
        return ctx.getDistCalc().area(this);
    }

    @Override
    public Circle getBuffered(double distance, SpatialContext ctx) {
        return ctx.makeCircle(this.point, distance + this.radiusDEG);
    }

    public boolean contains(double x, double y) {
        return this.ctx.getDistCalc().within(this.point, x, y, this.radiusDEG);
    }

    @Override
    public boolean hasArea() {
        return this.radiusDEG > 0.0;
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.enclosingBox;
    }

    @Override
    public SpatialRelation relate(Shape other) {
        if (this.isEmpty() || other.isEmpty()) {
            return SpatialRelation.DISJOINT;
        }
        if (other instanceof Point) {
            return this.relate((Point)other);
        }
        if (other instanceof Rectangle) {
            return this.relate((Rectangle)other);
        }
        if (other instanceof Circle) {
            return this.relate((Circle)other);
        }
        return other.relate(this).transpose();
    }

    public SpatialRelation relate(Point point) {
        return this.contains(point.getX(), point.getY()) ? SpatialRelation.CONTAINS : SpatialRelation.DISJOINT;
    }

    public SpatialRelation relate(Rectangle r) {
        SpatialRelation bboxSect = this.enclosingBox.relate(r);
        if (bboxSect == SpatialRelation.DISJOINT || bboxSect == SpatialRelation.WITHIN) {
            return bboxSect;
        }
        if (bboxSect == SpatialRelation.CONTAINS && this.enclosingBox.equals(r)) {
            return SpatialRelation.WITHIN;
        }
        return this.relateRectanglePhase2(r, bboxSect);
    }

    protected SpatialRelation relateRectanglePhase2(Rectangle r, SpatialRelation bboxSect) {
        double farthestY;
        double closestY;
        double farthestX;
        double closestX;
        double xAxis = this.getXAxis();
        if (xAxis < r.getMinX()) {
            closestX = r.getMinX();
            farthestX = r.getMaxX();
        } else if (xAxis > r.getMaxX()) {
            closestX = r.getMaxX();
            farthestX = r.getMinX();
        } else {
            closestX = xAxis;
            farthestX = r.getMaxX() - xAxis > xAxis - r.getMinX() ? r.getMaxX() : r.getMinX();
        }
        double yAxis = this.getYAxis();
        if (yAxis < r.getMinY()) {
            closestY = r.getMinY();
            farthestY = r.getMaxY();
        } else if (yAxis > r.getMaxY()) {
            closestY = r.getMaxY();
            farthestY = r.getMinY();
        } else {
            closestY = yAxis;
            double d = farthestY = r.getMaxY() - yAxis > yAxis - r.getMinY() ? r.getMaxY() : r.getMinY();
        }
        if (xAxis != closestX && yAxis != closestY && !this.contains(closestX, closestY)) {
            return SpatialRelation.DISJOINT;
        }
        if (bboxSect != SpatialRelation.CONTAINS) {
            return SpatialRelation.INTERSECTS;
        }
        if (!this.contains(farthestX, farthestY)) {
            return SpatialRelation.INTERSECTS;
        }
        if (this.point.getY() != this.getYAxis() && yAxis == closestY) {
            double otherY;
            double d = otherY = farthestY == r.getMaxY() ? r.getMinY() : r.getMaxY();
            if (!this.contains(farthestX, otherY)) {
                return SpatialRelation.INTERSECTS;
            }
        }
        return SpatialRelation.CONTAINS;
    }

    protected double getYAxis() {
        return this.point.getY();
    }

    protected double getXAxis() {
        return this.point.getX();
    }

    public SpatialRelation relate(Circle circle) {
        double bDist;
        double aDist;
        double crossDist = this.ctx.getDistCalc().distance(this.point, circle.getCenter());
        if (crossDist > (aDist = this.radiusDEG) + (bDist = circle.getRadius())) {
            return SpatialRelation.DISJOINT;
        }
        if (crossDist < aDist && crossDist + bDist <= aDist) {
            return SpatialRelation.CONTAINS;
        }
        if (crossDist < bDist && crossDist + aDist <= bDist) {
            return SpatialRelation.WITHIN;
        }
        return SpatialRelation.INTERSECTS;
    }

    public String toString() {
        return "Circle(" + this.point + ", d=" + this.radiusDEG + "\u00b0)";
    }

    @Override
    public boolean equals(Object obj) {
        return CircleImpl.equals(this, obj);
    }

    public static boolean equals(Circle thiz, Object o) {
        assert (thiz != null);
        if (thiz == o) {
            return true;
        }
        if (!(o instanceof Circle)) {
            return false;
        }
        Circle circle = (Circle)o;
        if (!thiz.getCenter().equals(circle.getCenter())) {
            return false;
        }
        return Double.compare(circle.getRadius(), thiz.getRadius()) == 0;
    }

    public int hashCode() {
        return CircleImpl.hashCode(this);
    }

    public static int hashCode(Circle thiz) {
        int result = thiz.getCenter().hashCode();
        long temp = thiz.getRadius() != 0.0 ? Double.doubleToLongBits(thiz.getRadius()) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

