/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;

public class Projections {
    private static final int INDEX_LAT = 0;
    private static final int INDEX_LON = 1;

    public static double[][] projToLatLon(Projection proj, double[][] from) {
        return Projections.projToLatLon(proj, from, new double[2][from[0].length]);
    }

    public static double[][] projToLatLon(Projection proj, double[][] from, double[][] to) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:from array not same length as to array");
        }
        for (int i = 0; i < from[0].length; ++i) {
            LatLonPoint endL = proj.projToLatLon(from[0][i], from[1][i]);
            to[0][i] = endL.getLatitude();
            to[1][i] = endL.getLongitude();
        }
        return to;
    }

    public static float[][] projToLatLon(Projection proj, float[][] from) {
        return Projections.projToLatLon(proj, from, new float[2][from[0].length]);
    }

    public static float[][] projToLatLon(Projection proj, float[][] from, float[][] to) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.projToLatLon:from array not same length as to array");
        }
        for (int i = 0; i < from[0].length; ++i) {
            ProjectionPoint ppi = ProjectionPoint.create(from[0][i], from[1][i]);
            LatLonPoint llpi = proj.projToLatLon(ppi);
            to[0][i] = (float)llpi.getLatitude();
            to[1][i] = (float)llpi.getLongitude();
        }
        return to;
    }

    public static double[][] latLonToProj(Projection proj, double[][] from) {
        return Projections.latLonToProj(proj, from, new double[2][from[0].length]);
    }

    public static double[][] latLonToProj(Projection proj, double[][] from, double[][] to) {
        return Projections.latLonToProj(proj, from, to, 0, 1);
    }

    public static double[][] latLonToProj(Projection proj, double[][] from, int latIndex, int lonIndex) {
        return Projections.latLonToProj(proj, from, new double[2][from[0].length], latIndex, lonIndex);
    }

    public static double[][] latLonToProj(Projection proj, double[][] from, double[][] to, int latIndex, int lonIndex) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:from array not same length as to array");
        }
        for (int i = 0; i < from[0].length; ++i) {
            LatLonPoint llpi = LatLonPoint.create(from[latIndex][i], from[lonIndex][i]);
            ProjectionPoint ppi = proj.latLonToProj(llpi);
            to[0][i] = ppi.getX();
            to[1][i] = ppi.getY();
        }
        return to;
    }

    public static float[][] latLonToProj(Projection proj, float[][] from) {
        return Projections.latLonToProj(proj, from, new float[2][from[0].length]);
    }

    public static float[][] latLonToProj(Projection proj, float[][] from, float[][] to) {
        return Projections.latLonToProj(proj, from, to, 0, 1);
    }

    public static float[][] latLonToProj(Projection proj, float[][] from, int latIndex, int lonIndex) {
        return Projections.latLonToProj(proj, from, new float[2][from[0].length], latIndex, lonIndex);
    }

    public static float[][] latLonToProj(Projection proj, float[][] from, float[][] to, int latIndex, int lonIndex) {
        if (from == null || from.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (from)");
        }
        if (to == null || to.length != 2) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:null array argument or wrong dimension (to)");
        }
        if (from[0].length != to[0].length) {
            throw new IllegalArgumentException("ProjectionImpl.latLonToProj:from array not same length as to array");
        }
        for (int i = 0; i < from[0].length; ++i) {
            LatLonPoint llpi = LatLonPoint.create(from[latIndex][i], from[lonIndex][i]);
            ProjectionPoint ppi = proj.latLonToProj(llpi);
            to[0][i] = (float)ppi.getX();
            to[1][i] = (float)ppi.getY();
        }
        return to;
    }
}

