/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import org.apache.sedona.common.utils.BBox;
import org.locationtech.jts.geom.Point;

public class PointGeoHashEncoder {
    private static String base32 = "0123456789bcdefghjkmnpqrstuvwxyz";
    private static int[] bits = new int[]{16, 8, 4, 2, 1};

    public static String calculateGeoHash(Point geom, long precision) {
        BBox bbox = new BBox(-180.0, 180.0, -90.0, 90.0);
        long precisionUpdated = Math.min(precision, 20L);
        if (precision <= 0L) {
            return "";
        }
        return PointGeoHashEncoder.geoHashAggregate(geom, precisionUpdated, 0L, "", true, bbox, 0, 0);
    }

    private static String geoHashAggregate(Point point, long precision, long currentPrecision, String geoHash, boolean isEven, BBox bbox, int bit, int ch) {
        double mid;
        if (currentPrecision >= precision) {
            return geoHash;
        }
        BBox updatedBbox = null;
        int updatedCh = -1;
        if (isEven) {
            mid = (bbox.startLon + bbox.endLon) / 2.0;
            if (point.getX() >= mid) {
                updatedBbox = new BBox(bbox);
                updatedBbox.startLon = mid;
                updatedCh = ch | bits[bit];
            } else {
                updatedBbox = new BBox(bbox);
                updatedBbox.endLon = mid;
                updatedCh = ch;
            }
        } else {
            mid = (bbox.startLat + bbox.endLat) / 2.0;
            if (point.getY() >= mid) {
                updatedBbox = new BBox(bbox);
                updatedBbox.startLat = mid;
                updatedCh = ch | bits[bit];
            } else {
                updatedBbox = new BBox(bbox);
                updatedBbox.endLat = mid;
                updatedCh = ch;
            }
        }
        if (bit < 4) {
            return PointGeoHashEncoder.geoHashAggregate(point, precision, currentPrecision, geoHash, !isEven, updatedBbox, bit + 1, updatedCh);
        }
        String geoHashUpdated = geoHash + base32.charAt(updatedCh);
        return PointGeoHashEncoder.geoHashAggregate(point, precision, currentPrecision + 1L, geoHashUpdated, !isEven, updatedBbox, 0, 0);
    }
}

