/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordAxisBuilder;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ft2.coverage.TimeAxis2DFmrc;
import ucar.nc2.util.Optional;

@Immutable
public class Time2DCoordSys {
    public final CoverageCoordAxis1D runAxis;
    public final TimeAxis2DFmrc timeAxis2D;

    public Time2DCoordSys(CoverageCoordAxis1D runAxis, TimeAxis2DFmrc timeAxis) {
        this.runAxis = runAxis;
        this.timeAxis2D = timeAxis;
    }

    public List<CoverageCoordAxis> getCoordAxes() {
        ArrayList<CoverageCoordAxis> result = new ArrayList<CoverageCoordAxis>();
        result.add(this.runAxis);
        result.add(this.timeAxis2D);
        return result;
    }

    public int[] getShape() {
        return this.timeAxis2D.getShape();
    }

    public Optional<List<CoverageCoordAxis>> subset(SubsetParams params, AtomicBoolean isConstantForcast, boolean makeCFcompliant) {
        return Optional.empty("not implemented by " + this.getClass().getName());
    }

    private CoverageCoordAxis makeScalarTimeCoord(double val, CoverageCoordAxis1D runAxisSubset) {
        String name = "constantForecastTime";
        String desc = "forecast time";
        AttributeContainerMutable atts = new AttributeContainerMutable(name);
        atts.addAttribute(new Attribute("units", runAxisSubset.getUnits()));
        atts.addAttribute(new Attribute("standard_name", "time"));
        atts.addAttribute(new Attribute("long_name", desc));
        atts.addAttribute(new Attribute("calendar", runAxisSubset.getCalendar().toString()));
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(name, runAxisSubset.getUnits(), desc, DataType.DOUBLE, AxisType.Time, atts, CoverageCoordAxis.DependenceType.scalar, null, CoverageCoordAxis.Spacing.regularPoint, 1, val, val, 0.0, null, null);
        builder.setIsSubset(true);
        return new CoverageCoordAxis1D(builder);
    }

    private CoverageCoordAxis makeCFTimeCoord(CoverageCoordAxis1D runAxisSubset, CoverageCoordAxis1D timeAxisSubset) {
        String name = timeAxisSubset.getName() + "Forecast";
        String desc = "forecast time";
        AttributeContainerMutable atts = new AttributeContainerMutable(name);
        atts.addAttribute(new Attribute("units", runAxisSubset.getUnits()));
        atts.addAttribute(new Attribute("standard_name", "time"));
        atts.addAttribute(new Attribute("long_name", desc));
        atts.addAttribute(new Attribute("calendar", runAxisSubset.getCalendar().toString()));
        if (runAxisSubset.getNcoords() == 1) {
            CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder();
            builder.name = name;
            builder.units = runAxisSubset.getUnits();
            builder.description = desc;
            builder.dataType = DataType.DOUBLE;
            builder.axisType = AxisType.Time;
            builder.attributes = atts;
            builder.dependenceType = CoverageCoordAxis.DependenceType.dependent;
            builder.setDependsOn(timeAxisSubset.getName());
            builder.spacing = timeAxisSubset.getSpacing();
            builder.ncoords = timeAxisSubset.ncoords;
            builder.isSubset = true;
            double offset = timeAxisSubset.getOffsetInTimeUnits(this.runAxis.getRefDate(), timeAxisSubset.getRefDate());
            switch (timeAxisSubset.getSpacing()) {
                case regularInterval: 
                case regularPoint: {
                    builder.startValue = timeAxisSubset.getStartValue() + offset;
                    builder.endValue = timeAxisSubset.getEndValue() + offset;
                    break;
                }
                case contiguousInterval: 
                case irregularPoint: 
                case discontiguousInterval: {
                    builder.values = timeAxisSubset.getValues();
                    int i = 0;
                    while (i < builder.values.length) {
                        int n = i++;
                        builder.values[n] = builder.values[n] + offset;
                    }
                    break;
                }
            }
            return new CoverageCoordAxis1D(builder);
        }
        return null;
    }
}

