/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Collections;
import javax.media.jai.RasterFactory;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sedona.common.raster.RasterAccessors;
import org.apache.sedona.common.raster.RasterBandAccessors;
import org.apache.sedona.common.raster.RasterConstructors;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CannotCropException;
import org.geotools.coverage.processing.operation.Crop;
import org.locationtech.jts.geom.Geometry;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

public class RasterBandEditors {
    public static GridCoverage2D setBandNoDataValue(GridCoverage2D raster, int bandIndex, Double noDataValue, boolean replace) {
        RasterUtils.ensureBand(raster, bandIndex);
        Double rasterNoData = RasterBandAccessors.getBandNoDataValue(raster, bandIndex);
        if (noDataValue == null) {
            if (RasterBandAccessors.getBandNoDataValue(raster) == null) {
                return raster;
            }
            GridSampleDimension[] sampleDimensions = raster.getSampleDimensions();
            sampleDimensions[bandIndex - 1] = RasterUtils.removeNoDataValue(sampleDimensions[bandIndex - 1]);
            return RasterUtils.clone(raster.getRenderedImage(), null, sampleDimensions, raster, null, true);
        }
        if (rasterNoData != null && rasterNoData.equals(noDataValue)) {
            return raster;
        }
        GridSampleDimension[] bands = raster.getSampleDimensions();
        bands[bandIndex - 1] = RasterUtils.createSampleDimensionWithNoDataValue(bands[bandIndex - 1], (double)noDataValue);
        if (replace) {
            if (rasterNoData == null) {
                throw new IllegalArgumentException("The raster provided doesn't have a no-data value. Please provide a raster that has a no-data value to use `replace` option.");
            }
            Raster rasterData = RasterUtils.getRaster(raster.getRenderedImage());
            int dataTypeCode = rasterData.getDataBuffer().getDataType();
            int numBands = RasterAccessors.numBands(raster);
            int height = RasterAccessors.getHeight(raster);
            int width = RasterAccessors.getWidth(raster);
            WritableRaster wr = RasterFactory.createBandedRaster((int)dataTypeCode, (int)width, (int)height, (int)numBands, null);
            double[] bandData = rasterData.getSamples(0, 0, width, height, bandIndex - 1, (double[])null);
            for (int i = 0; i < bandData.length; ++i) {
                if (bandData[i] != rasterNoData) continue;
                bandData[i] = noDataValue;
            }
            wr.setSamples(0, 0, width, height, bandIndex - 1, bandData);
            return RasterUtils.clone(wr, null, bands, raster, null, true);
        }
        return RasterUtils.clone(raster.getRenderedImage(), null, bands, raster, null, true);
    }

    public static GridCoverage2D setBandNoDataValue(GridCoverage2D raster, int bandIndex, Double noDataValue) {
        return RasterBandEditors.setBandNoDataValue(raster, bandIndex, noDataValue, false);
    }

    public static GridCoverage2D setBandNoDataValue(GridCoverage2D raster, Double noDataValue) {
        return RasterBandEditors.setBandNoDataValue(raster, 1, noDataValue, false);
    }

    public static GridCoverage2D addBand(GridCoverage2D toRaster, GridCoverage2D fromRaster, int fromBand, int toRasterIndex) {
        RasterUtils.ensureBand(fromRaster, fromBand);
        RasterBandEditors.ensureBandAppend(toRaster, toRasterIndex);
        RasterUtils.isRasterSameShape(toRaster, fromRaster);
        int width = RasterAccessors.getWidth(toRaster);
        int height = RasterAccessors.getHeight(toRaster);
        Raster rasterData = RasterUtils.getRaster(fromRaster.getRenderedImage());
        int dataTypeCode = RasterUtils.getRaster(toRaster.getRenderedImage()).getDataBuffer().getDataType();
        int numBands = RasterAccessors.numBands(toRaster);
        Double noDataValue = RasterBandAccessors.getBandNoDataValue(fromRaster, fromBand);
        if (RasterUtils.isDataTypeIntegral(dataTypeCode)) {
            int[] bandValues = rasterData.getSamples(0, 0, width, height, fromBand - 1, (int[])null);
            if (numBands + 1 == toRasterIndex) {
                return RasterUtils.copyRasterAndAppendBand(toRaster, bandValues, noDataValue);
            }
            return RasterUtils.copyRasterAndReplaceBand(toRaster, fromBand, bandValues, noDataValue, false);
        }
        double[] bandValues = rasterData.getSamples(0, 0, width, height, fromBand - 1, (double[])null);
        if (numBands + 1 == toRasterIndex) {
            return RasterUtils.copyRasterAndAppendBand(toRaster, bandValues, noDataValue);
        }
        return RasterUtils.copyRasterAndReplaceBand(toRaster, fromBand, bandValues, noDataValue, false);
    }

    public static GridCoverage2D addBand(GridCoverage2D toRaster, GridCoverage2D fromRaster, int fromBand) {
        int endBand = RasterAccessors.numBands(toRaster) + 1;
        return RasterBandEditors.addBand(toRaster, fromRaster, fromBand, endBand);
    }

    public static GridCoverage2D addBand(GridCoverage2D toRaster, GridCoverage2D fromRaster) {
        return RasterBandEditors.addBand(toRaster, fromRaster, 1);
    }

    public static GridCoverage2D rasterUnion(GridCoverage2D raster1, GridCoverage2D raster2, GridCoverage2D raster3, GridCoverage2D raster4, GridCoverage2D raster5, GridCoverage2D raster6, GridCoverage2D raster7) {
        return RasterBandEditors.rasterUnion(RasterBandEditors.rasterUnion(raster1, raster2, raster3, raster4, raster5, raster6), raster7);
    }

    public static GridCoverage2D rasterUnion(GridCoverage2D raster1, GridCoverage2D raster2, GridCoverage2D raster3, GridCoverage2D raster4, GridCoverage2D raster5, GridCoverage2D raster6) {
        return RasterBandEditors.rasterUnion(RasterBandEditors.rasterUnion(raster1, raster2, raster3, raster4, raster5), raster6);
    }

    public static GridCoverage2D rasterUnion(GridCoverage2D raster1, GridCoverage2D raster2, GridCoverage2D raster3, GridCoverage2D raster4, GridCoverage2D raster5) {
        return RasterBandEditors.rasterUnion(RasterBandEditors.rasterUnion(raster1, raster2, raster3, raster4), raster5);
    }

    public static GridCoverage2D rasterUnion(GridCoverage2D raster1, GridCoverage2D raster2, GridCoverage2D raster3, GridCoverage2D raster4) {
        return RasterBandEditors.rasterUnion(RasterBandEditors.rasterUnion(raster1, raster2, raster3), raster4);
    }

    public static GridCoverage2D rasterUnion(GridCoverage2D raster1, GridCoverage2D raster2, GridCoverage2D raster3) {
        return RasterBandEditors.rasterUnion(RasterBandEditors.rasterUnion(raster1, raster2), raster3);
    }

    public static GridCoverage2D rasterUnion(GridCoverage2D raster1, GridCoverage2D raster2) {
        RasterUtils.isRasterSameShape(raster1, raster2);
        int numBands1 = RasterAccessors.numBands(raster1);
        int numBands2 = RasterAccessors.numBands(raster2);
        GridCoverage2D result = raster1;
        for (int bandIndex = 1; bandIndex <= numBands2; ++bandIndex) {
            result = RasterBandEditors.addBand(result, raster2, bandIndex);
        }
        return result;
    }

    private static void ensureBandAppend(GridCoverage2D raster, int band) {
        if (band < 1 || band > RasterAccessors.numBands(raster) + 1) {
            throw new IllegalArgumentException(String.format("Provided band index %d is not present in the raster", band));
        }
    }

    public static GridCoverage2D clip(GridCoverage2D raster, int band, Geometry geometry, double noDataValue, boolean crop, boolean lenient) throws FactoryException, TransformException {
        GridCoverage2D newRaster;
        RasterUtils.ensureBand(raster, band);
        GridCoverage2D singleBandRaster = RasterBandAccessors.getBand(raster, new int[]{band});
        Pair<GridCoverage2D, Geometry> pair = RasterUtils.setDefaultCRSAndTransform(singleBandRaster, geometry);
        singleBandRaster = pair.getLeft();
        geometry = pair.getRight();
        Crop cropObject = new Crop();
        ParameterValueGroup parameters = cropObject.getParameters();
        parameters.parameter("Source").setValue((Object)singleBandRaster);
        parameters.parameter("destNoData").setValue((Object)new double[]{noDataValue});
        parameters.parameter("ROI").setValue((Object)geometry);
        try {
            newRaster = (GridCoverage2D)cropObject.doOperation(parameters, null);
        }
        catch (CannotCropException e) {
            if (lenient) {
                return null;
            }
            throw e;
        }
        if (!crop) {
            Object[] array;
            double[] metadataOriginal = RasterAccessors.metadata(raster);
            int widthOriginalRaster = (int)metadataOriginal[2];
            int heightOriginalRaster = (int)metadataOriginal[3];
            Raster rasterData = RasterUtils.getRaster(raster.getRenderedImage());
            String bandType = RasterBandAccessors.getBandType(raster, 1);
            int dataTypeCode = RasterUtils.getDataTypeCode(RasterBandAccessors.getBandType(raster, 1));
            boolean isDataTypeIntegral = RasterUtils.isDataTypeIntegral(dataTypeCode);
            WritableRaster resultRaster = RasterFactory.createBandedRaster((int)dataTypeCode, (int)widthOriginalRaster, (int)heightOriginalRaster, (int)1, null);
            int sizeOfArray = widthOriginalRaster * heightOriginalRaster;
            if (isDataTypeIntegral) {
                array = ArrayUtils.toPrimitive(Collections.nCopies(sizeOfArray, (int)noDataValue).toArray(new Integer[sizeOfArray]));
                resultRaster.setSamples(0, 0, widthOriginalRaster, heightOriginalRaster, 0, (int[])array);
            } else {
                array = ArrayUtils.toPrimitive(Collections.nCopies(sizeOfArray, noDataValue).toArray(new Double[sizeOfArray]));
                resultRaster.setSamples(0, 0, widthOriginalRaster, heightOriginalRaster, 0, (double[])array);
            }
            GridCoverage2D rasterized = RasterConstructors.asRaster(geometry, raster, bandType, 150.0);
            Raster rasterizedData = RasterUtils.getRaster(rasterized.getRenderedImage());
            double[] metadataRasterized = RasterAccessors.metadata(rasterized);
            int widthRasterized = (int)metadataRasterized[2];
            int heightRasterized = (int)metadataRasterized[3];
            for (int j = 0; j < heightRasterized; ++j) {
                for (int i = 0; i < widthRasterized; ++i) {
                    Object[] pixelValue;
                    Point2D point = RasterUtils.getWorldCornerCoordinates(rasterized, i, j);
                    int[] rasterCoord = RasterUtils.getGridCoordinatesFromWorld(raster, point.getX(), point.getY());
                    int x = Math.abs(rasterCoord[0]);
                    int y = Math.abs(rasterCoord[1]);
                    if (rasterizedData.getPixel(i, j, (int[])null)[0] == 0) continue;
                    if (isDataTypeIntegral) {
                        pixelValue = rasterData.getPixel(x, y, (int[])null);
                        resultRaster.setPixel(x, y, new int[]{pixelValue[band - 1]});
                        continue;
                    }
                    pixelValue = rasterData.getPixel(x, y, (double[])null);
                    resultRaster.setPixel(x, y, new double[]{pixelValue[band - 1]});
                }
            }
            newRaster = RasterUtils.clone(resultRaster, raster.getGridGeometry(), newRaster.getSampleDimensions(), newRaster, (Double)noDataValue, true);
        } else {
            RenderedImage image = newRaster.getRenderedImage();
            int minX = image.getMinX();
            int minY = image.getMinY();
            newRaster = minX != 0 || minY != 0 ? RasterUtils.shiftRasterToZeroOrigin(newRaster, noDataValue) : RasterUtils.clone(newRaster.getRenderedImage(), newRaster.getGridGeometry(), newRaster.getSampleDimensions(), newRaster, (Double)noDataValue, true);
        }
        return newRaster;
    }

    public static GridCoverage2D clip(GridCoverage2D raster, int band, Geometry geometry, double noDataValue, boolean crop) throws FactoryException, TransformException {
        return RasterBandEditors.clip(raster, band, geometry, noDataValue, crop, true);
    }

    public static GridCoverage2D clip(GridCoverage2D raster, int band, Geometry geometry, double noDataValue) throws FactoryException, TransformException {
        return RasterBandEditors.clip(raster, band, geometry, noDataValue, true);
    }

    public static GridCoverage2D clip(GridCoverage2D raster, int band, Geometry geometry) throws FactoryException, TransformException {
        boolean isDataTypeIntegral = RasterUtils.isDataTypeIntegral(RasterUtils.getDataTypeCode(RasterBandAccessors.getBandType(raster, band)));
        double noDataValue = isDataTypeIntegral ? -2.147483648E9 : Double.MIN_VALUE;
        return RasterBandEditors.clip(raster, band, geometry, noDataValue, true);
    }
}

