/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.sedona.core.joinJudgement.DedupParams;
import org.apache.sedona.core.spatialPartitioning.SpatialPartitioner;
import org.apache.spark.broadcast.Broadcast;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import scala.Tuple2;

public class BroadcastedSpatialPartitioner
extends SpatialPartitioner {
    private final Broadcast<SpatialPartitioner> bPartitioner;
    private transient SpatialPartitioner partitioner;

    public BroadcastedSpatialPartitioner(Broadcast<SpatialPartitioner> partitioner) {
        super(((SpatialPartitioner)partitioner.value()).gridType, null);
        this.bPartitioner = partitioner;
        this.partitioner = null;
    }

    private SpatialPartitioner getPartitioner() {
        if (this.partitioner == null) {
            this.partitioner = (SpatialPartitioner)this.bPartitioner.value();
        }
        return this.partitioner;
    }

    @Override
    public <T extends Geometry> Iterator<Tuple2<Integer, T>> placeObject(T spatialObject) throws Exception {
        return this.getPartitioner().placeObject(spatialObject);
    }

    @Override
    @Nullable
    public DedupParams getDedupParams() {
        return this.getPartitioner().getDedupParams();
    }

    @Override
    public List<Envelope> getGrids() {
        return this.getPartitioner().getGrids();
    }

    public int numPartitions() {
        return this.getPartitioner().numPartitions();
    }
}

