/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.shapes;

import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.shp.ShapeType;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.DbfFileReader;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.PrimitiveShape;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShapeFileReader;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShapeKey;
import org.apache.sedona.core.formatMapper.shapefileParser.shapes.ShxFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombineShapeReader
extends RecordReader<ShapeKey, PrimitiveShape> {
    private static final Logger logger = LoggerFactory.getLogger(CombineShapeReader.class);
    private static final String DBF_SUFFIX = "dbf";
    private static final String SHP_SUFFIX = "shp";
    private static final String SHX_SUFFIX = "shx";
    private FileSplit shpSplit = null;
    private FileSplit shxSplit = null;
    private FileSplit dbfSplit = null;
    private ShapeFileReader shapeFileReader = null;
    private DbfFileReader dbfFileReader = null;
    private boolean hasDbf = false;
    private boolean hasNextDbf = false;

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        CombineFileSplit fileSplit = (CombineFileSplit)split;
        Path[] paths = fileSplit.getPaths();
        for (int i = 0; i < paths.length; ++i) {
            String suffix = FilenameUtils.getExtension((String)paths[i].toString()).toLowerCase();
            if (suffix.equals(SHP_SUFFIX)) {
                this.shpSplit = new FileSplit(paths[i], fileSplit.getOffset(i), fileSplit.getLength(i), fileSplit.getLocations());
                continue;
            }
            if (suffix.equals(SHX_SUFFIX)) {
                this.shxSplit = new FileSplit(paths[i], fileSplit.getOffset(i), fileSplit.getLength(i), fileSplit.getLocations());
                continue;
            }
            if (!suffix.equals(DBF_SUFFIX)) continue;
            this.dbfSplit = new FileSplit(paths[i], fileSplit.getOffset(i), fileSplit.getLength(i), fileSplit.getLocations());
        }
        if (this.shpSplit == null) {
            throw new IOException("Can't find .shp file.");
        }
        if (this.shxSplit != null) {
            int[] indexes = ShxFileReader.readAll((InputSplit)this.shxSplit, context);
            this.shapeFileReader = new ShapeFileReader(indexes);
        } else {
            this.shapeFileReader = new ShapeFileReader();
        }
        this.shapeFileReader.initialize((InputSplit)this.shpSplit, context);
        if (this.dbfSplit != null) {
            this.dbfFileReader = new DbfFileReader();
            this.dbfFileReader.initialize((InputSplit)this.dbfSplit, context);
            this.hasDbf = true;
        } else {
            this.hasDbf = false;
        }
    }

    public boolean nextKeyValue() throws IOException {
        boolean hasNextShp = this.shapeFileReader.nextKeyValue();
        if (this.hasDbf) {
            this.hasNextDbf = this.dbfFileReader.nextKeyValue();
        }
        ShapeType curShapeType = this.shapeFileReader.getCurrentValue().getType();
        while (hasNextShp && !curShapeType.isSupported()) {
            logger.warn("[SEDONA] Shapefile type {} is not supported. Skipped this record. Please use QGIS or GeoPandas to convert it to a type listed in ShapeType.java", (Object)curShapeType.name());
            if (this.hasDbf) {
                this.hasNextDbf = this.dbfFileReader.nextKeyValue();
            }
            hasNextShp = this.shapeFileReader.nextKeyValue();
            curShapeType = this.shapeFileReader.getCurrentValue().getType();
        }
        if (this.hasDbf) {
            if (hasNextShp && !this.hasNextDbf) {
                Exception e = new Exception("shape record loses attributes in .dbf file at ID=" + this.shapeFileReader.getCurrentKey().getIndex());
                logger.warn(e.getMessage(), (Throwable)e);
            } else if (!hasNextShp && this.hasNextDbf) {
                Exception e = new Exception("Redundant attributes in .dbf exists");
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        return hasNextShp;
    }

    public ShapeKey getCurrentKey() {
        return this.shapeFileReader.getCurrentKey();
    }

    public PrimitiveShape getCurrentValue() {
        PrimitiveShape value = new PrimitiveShape(this.shapeFileReader.getCurrentValue());
        if (this.hasDbf && this.hasNextDbf) {
            value.setAttributes(this.dbfFileReader.getCurrentValue());
        }
        return value;
    }

    public float getProgress() {
        return this.shapeFileReader.getProgress();
    }

    public void close() throws IOException {
        this.shapeFileReader.close();
    }
}

