/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class GeometryDuplicateCoordinateRemover {
    private static GeometryFactory FACTORY = null;
    private static double TOLERANCE = 0.0;

    public static Coordinate[] removeDuplicates(Coordinate[] coords, int minPoints) {
        int numPoint = coords.length;
        int totalPointsOut = 1;
        double distance = Double.MAX_VALUE;
        if (numPoint <= minPoints) {
            return new Coordinate[0];
        }
        Coordinate lastPoint = coords[0];
        int writeIndex = 1;
        for (int i = 1; i < numPoint; ++i) {
            boolean isLastPoint = i == numPoint - 1;
            Coordinate currentPoint = coords[i];
            if (numPoint + totalPointsOut > minPoints + i) {
                if (TOLERANCE > 0.0) {
                    distance = currentPoint.distance(lastPoint);
                    if (!isLastPoint && distance <= TOLERANCE) {
                        continue;
                    }
                } else if (currentPoint.equals2D(lastPoint)) continue;
                if (isLastPoint && totalPointsOut > 1 && TOLERANCE > 0.0 && distance <= TOLERANCE) {
                    --totalPointsOut;
                    --writeIndex;
                }
            }
            coords[writeIndex] = currentPoint;
            ++totalPointsOut;
            ++writeIndex;
            lastPoint = currentPoint;
        }
        Coordinate[] newCoordinates = new Coordinate[totalPointsOut];
        System.arraycopy(coords, 0, newCoordinates, 0, totalPointsOut);
        return newCoordinates;
    }

    public static Coordinate[] removeDuplicatePointsMultiPoint(Coordinate[] coords, boolean recursion) {
        if (TOLERANCE == 0.0 || recursion) {
            LinkedHashSet<Coordinate> uniqueCoords = new LinkedHashSet<Coordinate>(Arrays.asList(coords));
            return uniqueCoords.toArray(new Coordinate[0]);
        }
        Coordinate[] deduplicated = (Coordinate[])Arrays.stream(GeometryDuplicateCoordinateRemover.removeDuplicatePointsMultiPoint(coords, true)).sorted().toArray(Coordinate[]::new);
        for (int i = 0; i < deduplicated.length; ++i) {
            for (int j = i + 1; j < deduplicated.length && deduplicated[i] != null && deduplicated[j] != null && deduplicated[i].distance(deduplicated[j]) < TOLERANCE; ++j) {
                deduplicated[j] = null;
            }
        }
        return (Coordinate[])Arrays.stream(deduplicated).filter(Objects::nonNull).toArray(Coordinate[]::new);
    }

    public static Geometry process(Geometry geometry, double tolerance) {
        TOLERANCE = tolerance;
        if (geometry.isEmpty()) {
            return geometry;
        }
        FACTORY = geometry.getFactory();
        if (geometry.getGeometryType().equals("Point")) {
            return geometry;
        }
        if (geometry.getGeometryType().equals("MultiPoint")) {
            return GeometryDuplicateCoordinateRemover.processMultiPoint((MultiPoint)geometry);
        }
        if (geometry.getGeometryType().equals("LinearRing")) {
            return GeometryDuplicateCoordinateRemover.processLinearRing((LinearRing)geometry);
        }
        if (geometry.getGeometryType().equals("LineString")) {
            return GeometryDuplicateCoordinateRemover.processLineString((LineString)geometry);
        }
        if (geometry.getGeometryType().equals("MultiLineString")) {
            return GeometryDuplicateCoordinateRemover.processMultiLineString((MultiLineString)geometry);
        }
        if (geometry.getGeometryType().equals("Polygon")) {
            return GeometryDuplicateCoordinateRemover.processPolygon((Polygon)geometry);
        }
        if (geometry.getGeometryType().equals("MultiPolygon")) {
            return GeometryDuplicateCoordinateRemover.processMultiPolygon((MultiPolygon)geometry);
        }
        if (geometry.getGeometryType().equals("GeometryCollection")) {
            return GeometryDuplicateCoordinateRemover.processGeometryCollection((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unknown Geometry subtype: " + geometry.getClass().getName());
    }

    private static MultiPoint processMultiPoint(MultiPoint geometry) {
        Coordinate[] coords = geometry.getCoordinates();
        return FACTORY.createMultiPointFromCoords(GeometryDuplicateCoordinateRemover.removeDuplicatePointsMultiPoint(coords, false));
    }

    private static LinearRing processLinearRing(LinearRing geometry) {
        Coordinate[] coords = geometry.getCoordinates();
        return FACTORY.createLinearRing(GeometryDuplicateCoordinateRemover.removeDuplicates(coords, 4));
    }

    private static LineString processLineString(LineString geometry) {
        if (geometry.getNumPoints() <= 2) {
            return geometry;
        }
        Coordinate[] coords = geometry.getCoordinates();
        return FACTORY.createLineString(GeometryDuplicateCoordinateRemover.removeDuplicates(coords, 2));
    }

    private static MultiLineString processMultiLineString(MultiLineString geometry) {
        LineString[] lineStrings = new LineString[geometry.getNumGeometries()];
        for (int i = 0; i < lineStrings.length; ++i) {
            lineStrings[i] = GeometryDuplicateCoordinateRemover.processLineString((LineString)geometry.getGeometryN(i));
        }
        return FACTORY.createMultiLineString(lineStrings);
    }

    private static Polygon processPolygon(Polygon geometry) {
        LinearRing shell = GeometryDuplicateCoordinateRemover.processLinearRing(geometry.getExteriorRing());
        LinearRing[] holes = new LinearRing[geometry.getNumInteriorRing()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = GeometryDuplicateCoordinateRemover.processLinearRing(geometry.getInteriorRingN(i));
        }
        return FACTORY.createPolygon(shell, holes);
    }

    private static MultiPolygon processMultiPolygon(MultiPolygon geometry) {
        Polygon[] polygons = new Polygon[geometry.getNumGeometries()];
        for (int i = 0; i < polygons.length; ++i) {
            polygons[i] = GeometryDuplicateCoordinateRemover.processPolygon((Polygon)geometry.getGeometryN(i));
        }
        return FACTORY.createMultiPolygon(polygons);
    }

    private static GeometryCollection processGeometryCollection(GeometryCollection geometry) {
        Geometry[] geometries = new Geometry[geometry.getNumGeometries()];
        for (int i = 0; i < geometries.length; ++i) {
            geometries[i] = GeometryDuplicateCoordinateRemover.process(geometry.getGeometryN(i), TOLERANCE);
        }
        return FACTORY.createGeometryCollection(geometries);
    }
}

