/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.viz.core;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.sedona.viz.core.ImageSerializableWrapper;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class RasterOverlayOperator {
    static final Logger logger = Logger.getLogger(RasterOverlayOperator.class);
    public BufferedImage backRasterImage = null;
    public JavaPairRDD<Integer, ImageSerializableWrapper> distributedBackRasterImage = null;
    public boolean generateDistributedImage = false;

    public RasterOverlayOperator(BufferedImage backRasterImage) {
        this.backRasterImage = backRasterImage;
        this.generateDistributedImage = false;
    }

    public RasterOverlayOperator(JavaPairRDD<Integer, ImageSerializableWrapper> distributedBackRasterImage) {
        this.distributedBackRasterImage = distributedBackRasterImage;
        this.generateDistributedImage = true;
    }

    public boolean JoinImage(JavaPairRDD<Integer, ImageSerializableWrapper> distributedFontImage) throws Exception {
        logger.info((Object)"[Sedona-Viz][JoinImage][Start]");
        if (!this.generateDistributedImage) {
            throw new Exception("[OverlayOperator][JoinImage] The back image is not distributed. Please don't use distributed format.");
        }
        this.distributedBackRasterImage = this.distributedBackRasterImage.cogroup(distributedFontImage).mapToPair((PairFunction)new PairFunction<Tuple2<Integer, Tuple2<Iterable<ImageSerializableWrapper>, Iterable<ImageSerializableWrapper>>>, Integer, ImageSerializableWrapper>(){

            public Tuple2<Integer, ImageSerializableWrapper> call(Tuple2<Integer, Tuple2<Iterable<ImageSerializableWrapper>, Iterable<ImageSerializableWrapper>>> imagePair) throws Exception {
                int imagePartitionId = (Integer)imagePair._1;
                Iterator backImageIterator = ((Iterable)((Tuple2)imagePair._2)._1).iterator();
                Iterator frontImageIterator = ((Iterable)((Tuple2)imagePair._2)._2).iterator();
                if (!backImageIterator.hasNext()) {
                    throw new Exception("[OverlayOperator][JoinImage] The back image iterator didn't get any image partitions.");
                }
                if (!frontImageIterator.hasNext()) {
                    throw new Exception("[OverlayOperator][JoinImage] The front image iterator didn't get any image partitions.");
                }
                BufferedImage backImage = ((ImageSerializableWrapper)backImageIterator.next()).image;
                BufferedImage frontImage = ((ImageSerializableWrapper)frontImageIterator.next()).image;
                if (backImage.getWidth() != frontImage.getWidth() || backImage.getHeight() != frontImage.getHeight()) {
                    throw new Exception("[OverlayOperator][JoinImage] The two given image don't have the same width or the same height.");
                }
                int w = Math.max(backImage.getWidth(), frontImage.getWidth());
                int h2 = Math.max(backImage.getHeight(), frontImage.getHeight());
                BufferedImage combinedImage = new BufferedImage(w, h2, 2);
                Graphics graphics = combinedImage.getGraphics();
                graphics.drawImage(backImage, 0, 0, null);
                graphics.drawImage(frontImage, 0, 0, null);
                logger.info((Object)"[Sedona-Viz][JoinImage][Stop]");
                return new Tuple2((Object)imagePartitionId, (Object)new ImageSerializableWrapper(combinedImage));
            }
        });
        return true;
    }

    public boolean JoinImage(BufferedImage frontRasterImage) throws Exception {
        if (this.generateDistributedImage) {
            throw new Exception("[OverlayOperator][JoinImage] The back image is distributed. Please don't use centralized format.");
        }
        if (this.backRasterImage.getWidth() != frontRasterImage.getWidth() || this.backRasterImage.getHeight() != frontRasterImage.getHeight()) {
            throw new Exception("[OverlayOperator][JoinImage] The two given image don't have the same width or the same height.");
        }
        int w = Math.max(this.backRasterImage.getWidth(), frontRasterImage.getWidth());
        int h2 = Math.max(this.backRasterImage.getHeight(), frontRasterImage.getHeight());
        BufferedImage combinedImage = new BufferedImage(w, h2, 2);
        Graphics graphics = combinedImage.getGraphics();
        graphics.drawImage(this.backRasterImage, 0, 0, null);
        graphics.drawImage(frontRasterImage, 0, 0, null);
        this.backRasterImage = combinedImage;
        return true;
    }
}

