/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.RasterFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sedona.common.raster.RasterAccessors;
import org.apache.sedona.common.raster.RasterBandAccessors;
import org.apache.sedona.common.raster.RasterConstructors;
import org.apache.sedona.common.raster.RasterPredicates;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.DirectPosition2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

public class PixelFunctionEditors {
    public static GridCoverage2D setValues(GridCoverage2D raster, int band, int colX, int rowY, int width, int height, double[] values, boolean keepNoData) {
        RasterUtils.ensureBand(raster, band);
        if (values.length != width * height) {
            throw new IllegalArgumentException("Shape of 'values' doesn't match provided width and height.");
        }
        WritableRaster rasterCopied = PixelFunctionEditors.makeCopiedRaster(raster);
        Double noDataValue = null;
        if (keepNoData) {
            noDataValue = RasterBandAccessors.getBandNoDataValue(raster, band);
        }
        --colX;
        int iterator = 0;
        for (int j = --rowY; j < rowY + height; ++j) {
            for (int i = colX; i < colX + width; ++i) {
                double[] pixel = rasterCopied.getPixel(i, j, (double[])null);
                if (keepNoData && noDataValue != null && noDataValue == pixel[band - 1]) {
                    ++iterator;
                    continue;
                }
                pixel[band - 1] = values[iterator];
                rasterCopied.setPixel(i, j, pixel);
                ++iterator;
            }
        }
        return RasterUtils.clone(rasterCopied, raster.getSampleDimensions(), raster, null, true);
    }

    public static GridCoverage2D setValues(GridCoverage2D raster, int band, int colX, int rowY, int width, int height, double[] values) {
        return PixelFunctionEditors.setValues(raster, band, colX, rowY, width, height, values, false);
    }

    public static GridCoverage2D setValues(GridCoverage2D raster, int band, Geometry geom, double value, boolean keepNoData) throws FactoryException, TransformException {
        GridCoverage2D rasterizedGeom;
        RasterUtils.ensureBand(raster, band);
        Pair<GridCoverage2D, Geometry> pair = RasterUtils.setDefaultCRSAndTransform(raster, geom);
        raster = (GridCoverage2D)pair.getLeft();
        geom = (Geometry)pair.getRight();
        if (!RasterPredicates.rsIntersects(raster, geom)) {
            throw new IllegalArgumentException("The provided geometry is not intersecting the raster. Please provide a geometry that is in the raster's extent.");
        }
        String bandDataType = RasterBandAccessors.getBandType(raster, band);
        Double noDataValue = null;
        if (keepNoData) {
            noDataValue = RasterBandAccessors.getBandNoDataValue(raster, band);
            rasterizedGeom = RasterConstructors.asRaster(geom, raster, bandDataType, value, noDataValue);
        } else {
            rasterizedGeom = RasterConstructors.asRaster(geom, raster, bandDataType, value);
        }
        Raster rasterizedGeomData = RasterUtils.getRaster(rasterizedGeom.getRenderedImage());
        double colX = RasterAccessors.getUpperLeftX(rasterizedGeom);
        double rowY = RasterAccessors.getUpperLeftY(rasterizedGeom);
        int heightGeometryRaster = RasterAccessors.getHeight(rasterizedGeom);
        int widthGeometryRaster = RasterAccessors.getWidth(rasterizedGeom);
        int heightOriginalRaster = RasterAccessors.getHeight(raster);
        int widthOriginalRaster = RasterAccessors.getWidth(raster);
        WritableRaster rasterCopied = PixelFunctionEditors.makeCopiedRaster(raster);
        String geometryType = geom.getGeometryType();
        if (geometryType.equalsIgnoreCase("Point") || geometryType.equalsIgnoreCase("MultiPoint")) {
            Coordinate[] coordinates;
            for (Coordinate pointCoordinate : coordinates = geom.getCoordinates()) {
                int[] pointLocation = raster.getGridGeometry().worldToGrid((DirectPosition)new DirectPosition2D(pointCoordinate.x, pointCoordinate.y)).getCoordinateValues();
                double[] pixel = rasterCopied.getPixel(pointLocation[0], pointLocation[1], (double[])null);
                pixel[band - 1] = rasterizedGeomData.getPixel(0, 0, (double[])null)[0];
                rasterCopied.setPixel(pointLocation[0], pointLocation[1], pixel);
            }
        } else {
            int[] pixelLocation = RasterUtils.getGridCoordinatesFromWorld(raster, colX, rowY);
            int x = pixelLocation[0];
            int y = pixelLocation[1];
            int rasterX = Math.max(x, 0);
            int rasterY = Math.max(y, 0);
            int geometryX = rasterX - x;
            int geometryY = rasterY - y;
            int widthRegion = Math.min(widthGeometryRaster - geometryX, widthOriginalRaster - rasterX);
            int heightRegion = Math.min(heightGeometryRaster - geometryY, heightOriginalRaster - rasterY);
            for (int j = 0; j < heightRegion; ++j) {
                for (int i = 0; i < widthRegion; ++i) {
                    double[] pixel = rasterCopied.getPixel(rasterX + i, rasterY + j, (double[])null);
                    double pixelNew = rasterizedGeomData.getPixel(geometryX + i, geometryY + j, (double[])null)[0];
                    if (pixelNew == 0.0 || keepNoData && noDataValue != null && noDataValue == pixel[band - 1]) continue;
                    pixel[band - 1] = pixelNew;
                    rasterCopied.setPixel(rasterX + i, rasterY + j, pixel);
                }
            }
        }
        return RasterUtils.clone(rasterCopied, raster.getSampleDimensions(), raster, null, true);
    }

    public static GridCoverage2D setValues(GridCoverage2D raster, int band, Geometry geom, double value) throws FactoryException, TransformException {
        return PixelFunctionEditors.setValues(raster, band, geom, value, false);
    }

    public static GridCoverage2D setValue(GridCoverage2D raster, int band, int colX, int rowY, double newValue) {
        return PixelFunctionEditors.setValues(raster, band, colX, rowY, 1, 1, new double[]{newValue}, false);
    }

    public static GridCoverage2D setValue(GridCoverage2D raster, int colX, int rowY, double newValue) {
        return PixelFunctionEditors.setValues(raster, 1, colX, rowY, 1, 1, new double[]{newValue}, false);
    }

    private static WritableRaster makeCopiedRaster(GridCoverage2D raster) {
        RenderedImage originalImage = raster.getRenderedImage();
        Raster rasterTemp = RasterUtils.getRaster(originalImage);
        Point location = rasterTemp.getBounds().getLocation();
        WritableRaster wr = RasterFactory.createBandedRaster((int)rasterTemp.getDataBuffer().getDataType(), (int)originalImage.getWidth(), (int)originalImage.getHeight(), (int)raster.getNumSampleDimensions(), (Point)location);
        return raster.getRenderedImage().copyData(wr);
    }
}

