/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.geoparquet.metadata;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.catalyst.FileSourceOptions;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.parquet.GeometryFieldMetaData;
import org.apache.spark.sql.execution.datasources.v2.geoparquet.metadata.GeoParquetMetadataPartitionReaderFactory;
import org.apache.spark.sql.execution.datasources.v2.geoparquet.metadata.GeoParquetMetadataTable$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.SerializableConfiguration;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;

public final class GeoParquetMetadataPartitionReaderFactory$
implements scala.Serializable {
    public static GeoParquetMetadataPartitionReaderFactory$ MODULE$;

    static {
        new GeoParquetMetadataPartitionReaderFactory$();
    }

    public Iterator<InternalRow> org$apache$spark$sql$execution$datasources$v2$geoparquet$metadata$GeoParquetMetadataPartitionReaderFactory$$readFile(Configuration configuration, PartitionedFile partitionedFile, StructType readDataSchema) {
        GenericInternalRow genericInternalRow;
        String filePath = partitionedFile.toPath().toString();
        java.util.Map metadata = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)partitionedFile.toPath(), (Configuration)configuration)).getFooter().getFileMetaData().getKeyValueMetaData();
        Option<GeoParquetMetaData> option = GeoParquetMetaData$.MODULE$.parseKeyValueMetaData(metadata);
        if (option instanceof Some) {
            Some some = (Some)option;
            GeoParquetMetaData geo = (GeoParquetMetaData)some.value();
            scala.collection.immutable.Map geoColumnsMap = (scala.collection.immutable.Map)geo.columns().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String columnName = (String)tuple2._1();
                GeometryFieldMetaData columnMetadata = (GeometryFieldMetaData)tuple2._2();
                Object[] columnMetadataFields = new Object[]{UTF8String.fromString((String)columnMetadata.encoding()), new GenericArrayData(((TraversableOnce)columnMetadata.geometryTypes().map((Function1 & Serializable & scala.Serializable)x$1 -> UTF8String.fromString((String)x$1), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(UTF8String.class))), new GenericArrayData((double[])columnMetadata.bbox().toArray(ClassTag$.MODULE$.Double())), columnMetadata.crs().map((Function1 & Serializable & scala.Serializable)projjson -> {
                    JsonAST.JValue x$1 = projjson;
                    Formats x$2 = JsonMethods$.MODULE$.render$default$2(x$1);
                    return UTF8String.fromString((String)JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$1, x$2)));
                }).orNull(Predef$.MODULE$.$conforms())};
                GenericInternalRow columnMetadataStruct = new GenericInternalRow(columnMetadataFields);
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UTF8String.fromString((String)columnName)), (Object)columnMetadataStruct);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            Object[] fields = new Object[]{UTF8String.fromString((String)filePath), UTF8String.fromString((String)((String)geo.version().orNull(Predef$.MODULE$.$conforms()))), UTF8String.fromString((String)geo.primaryColumn()), ArrayBasedMapData$.MODULE$.apply((Map)geoColumnsMap, ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3())};
            genericInternalRow = new GenericInternalRow(fields);
        } else if (None$.MODULE$.equals(option)) {
            Object[] fields = new Object[]{UTF8String.fromString((String)filePath), null, null, null};
            genericInternalRow = new GenericInternalRow(fields);
        } else {
            throw new MatchError(option);
        }
        GenericInternalRow row = genericInternalRow;
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{this.pruneBySchema((InternalRow)row, GeoParquetMetadataTable$.MODULE$.schema(), readDataSchema)}));
    }

    private InternalRow pruneBySchema(InternalRow row, StructType schema, StructType readDataSchema) {
        Object[] values = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readDataSchema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            int index = schema.fieldIndex(field.name());
            return row.get(index, field.dataType());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        return new GenericInternalRow(values);
    }

    public GeoParquetMetadataPartitionReaderFactory apply(SQLConf sqlConf, Broadcast<SerializableConfiguration> broadcastedConf, StructType dataSchema, StructType readDataSchema, StructType partitionSchema, FileSourceOptions options, Seq<Filter> filters) {
        return new GeoParquetMetadataPartitionReaderFactory(sqlConf, broadcastedConf, dataSchema, readDataSchema, partitionSchema, options, filters);
    }

    public Option<Tuple7<SQLConf, Broadcast<SerializableConfiguration>, StructType, StructType, StructType, FileSourceOptions, Seq<Filter>>> unapply(GeoParquetMetadataPartitionReaderFactory x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.sqlConf(), x$0.broadcastedConf(), (Object)x$0.dataSchema(), (Object)x$0.readDataSchema(), (Object)x$0.partitionSchema(), (Object)x$0.options(), x$0.filters()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GeoParquetMetadataPartitionReaderFactory$() {
        MODULE$ = this;
    }
}

