/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.parser.LegacyTypeStringParser$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoSchemaMergeUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Try$;

public final class GeoParquetFileFormat$
implements Logging,
scala.Serializable {
    public static GeoParquetFileFormat$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new GeoParquetFileFormat$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        boolean assumeBinaryIsString = sparkSession.sessionState().conf().isParquetBinaryAsString();
        boolean assumeInt96IsTimestamp = sparkSession.sessionState().conf().isParquetINT96AsTimestamp();
        Function3 & Serializable & scala.Serializable reader = (Function3 & Serializable & scala.Serializable)(files, conf, ignoreCorruptFiles) -> GeoParquetFileFormat$.$anonfun$mergeSchemasInParallel$1(assumeBinaryIsString, assumeInt96IsTimestamp, parameters, files, conf, BoxesRunTime.unboxToBoolean((Object)ignoreCorruptFiles));
        return GeoSchemaMergeUtils$.MODULE$.mergeSchemasInParallel(sparkSession, parameters, filesToTouch, (Function3<Seq<FileStatus>, Configuration, Object, Seq<StructType>>)reader);
    }

    private StructType readSchemaFromFooter(Footer footer, Map<String, String> keyValueMetaData, GeoParquetToSparkSchemaConverter converter, scala.collection.immutable.Map<String, String> parameters) {
        FileMetaData fileMetaData = footer.getParquetMetadata().getFileMetaData();
        return (StructType)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(fileMetaData.getKeyValueMetaData()).asScala()).toMap(Predef$.MODULE$.$conforms()).get((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()).flatMap((Function1 & Serializable & scala.Serializable)schema -> MODULE$.deserializeSchemaString((String)schema, keyValueMetaData, parameters)).getOrElse((Function0 & Serializable & scala.Serializable)() -> converter.convert(fileMetaData.getSchema()));
    }

    private Option<StructType> deserializeSchemaString(String schemaString, Map<String, String> keyValueMetaData, scala.collection.immutable.Map<String, String> parameters) {
        Option schemaOpt = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (StructType)DataType$.MODULE$.fromJson(schemaString)).recover((PartialFunction)new scala.Serializable(schemaString){
            public static final long serialVersionUID = 0L;
            private final String schemaString$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    GeoParquetFileFormat$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Serialized Spark schema in Parquet key-value metadata is not in JSON format, falling back to the deprecated DataType.fromCaseClassString parser.");
                    object = (StructType)LegacyTypeStringParser$.MODULE$.parseString(this.schemaString$1);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable != null;
                return bl;
            }
            {
                this.schemaString$1 = schemaString$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1()}, serializedLambda);
            }
        }).recoverWith((PartialFunction)new scala.Serializable(schemaString){
            public static final long serialVersionUID = 0L;
            private final String schemaString$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    A1 A12 = A1;
                    GeoParquetFileFormat$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(84).append("Failed to parse and ignored serialized Spark schema in ").append("Parquet key-value metadata:\n\t").append($this.schemaString$1).toString(), A12);
                    object = new Failure(A12);
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = throwable != null;
                return bl;
            }
            {
                this.schemaString$1 = schemaString$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormat$$anonfun$2 )}, serializedLambda);
            }
        }).toOption();
        return schemaOpt.map((Function1 & Serializable & scala.Serializable)schema -> MODULE$.replaceGeometryColumnWithGeometryUDT((StructType)schema, keyValueMetaData, parameters));
    }

    private StructType replaceGeometryColumnWithGeometryUDT(StructType schema, Map<String, String> keyValueMetaData, scala.collection.immutable.Map<String, String> parameters) {
        GeoParquetMetaData geoParquetMetaData = GeoParquetUtils$.MODULE$.parseGeoParquetMetaData(keyValueMetaData, parameters);
        StructField[] fields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            StructField structField;
            DataType dataType = field.dataType();
            if (dataType instanceof BinaryType && geoParquetMetaData.columns().contains((Object)field.name())) {
                GeometryUDT$ x$1 = GeometryUDT$.MODULE$;
                String x$2 = field.copy$default$1();
                boolean x$3 = field.copy$default$3();
                Metadata x$4 = field.copy$default$4();
                structField = field.copy(x$2, (DataType)x$1, x$3, x$4);
            } else {
                structField = field;
            }
            return structField;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return new StructType(fields);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Seq $anonfun$mergeSchemasInParallel$1(boolean assumeBinaryIsString$1, boolean assumeInt96IsTimestamp$1, scala.collection.immutable.Map parameters$1, Seq files, Configuration conf, boolean ignoreCorruptFiles) {
        return (Seq)ParquetFileFormat$.MODULE$.readParquetFootersInParallel(conf, files, ignoreCorruptFiles).map((Function1 & Serializable & scala.Serializable)footer -> {
            Map keyValueMetaData = footer.getParquetMetadata().getFileMetaData().getKeyValueMetaData();
            GeoParquetToSparkSchemaConverter converter = new GeoParquetToSparkSchemaConverter(keyValueMetaData, assumeBinaryIsString$1, assumeInt96IsTimestamp$1, (scala.collection.immutable.Map<String, String>)parameters$1);
            return MODULE$.readSchemaFromFooter((Footer)footer, keyValueMetaData, converter, (scala.collection.immutable.Map<String, String>)parameters$1);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private GeoParquetFileFormat$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

