/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialRDD;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.sedona.common.enums.FileDataSplitter;
import org.apache.sedona.core.formatMapper.FormatMapper;
import org.apache.sedona.core.formatMapper.PolygonFormatMapper;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.precision.GeometryPrecisionReducer;

public class PolygonRDD
extends SpatialRDD<Polygon> {
    public PolygonRDD() {
    }

    public PolygonRDD(JavaRDD<Polygon> rawSpatialRDD) {
        this.setRawSpatialRDD(rawSpatialRDD);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, Integer startOffset, Integer endOffset, FileDataSplitter splitter, boolean carryInputData) {
        this(sparkContext, InputLocation, startOffset, endOffset, splitter, carryInputData, null);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter, boolean carryInputData, Integer partitions) {
        this(sparkContext, InputLocation, null, null, splitter, carryInputData, partitions);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, FileDataSplitter splitter, boolean carryInputData) {
        this(sparkContext, InputLocation, null, null, splitter, carryInputData, null);
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, Integer partitions, FlatMapFunction userSuppliedMapper) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation, partitions.intValue()).mapPartitions(userSuppliedMapper));
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, FlatMapFunction userSuppliedMapper) {
        this.setRawSpatialRDD(sparkContext.textFile(InputLocation).mapPartitions(userSuppliedMapper));
    }

    public PolygonRDD(JavaSparkContext sparkContext, String InputLocation, Integer startOffset, Integer endOffset, FileDataSplitter splitter, boolean carryInputData, Integer partitions) {
        JavaRDD rawTextRDD;
        JavaRDD javaRDD = rawTextRDD = partitions != null ? sparkContext.textFile(InputLocation, partitions.intValue()) : sparkContext.textFile(InputLocation);
        if (startOffset != null && endOffset != null) {
            this.setRawSpatialRDD(rawTextRDD.mapPartitions((FlatMapFunction)new PolygonFormatMapper(startOffset, endOffset, splitter, carryInputData)));
        } else {
            this.setRawSpatialRDD(rawTextRDD.mapPartitions((FlatMapFunction)new PolygonFormatMapper(splitter, carryInputData)));
        }
        if (splitter.equals(FileDataSplitter.GEOJSON)) {
            this.fieldNames = FormatMapper.readGeoJsonPropertyNames(rawTextRDD.take(1).get(0).toString());
        }
        this.analyze();
    }

    public Polygon PolygonUnion() {
        Polygon result = (Polygon)this.rawSpatialRDD.reduce((Function2)new Function2<Polygon, Polygon, Polygon>(){

            public Polygon call(Polygon v1, Polygon v2) {
                PrecisionModel pModel = new PrecisionModel();
                GeometryPrecisionReducer pReducer = new GeometryPrecisionReducer(pModel);
                Geometry p1 = pReducer.reduce(v1);
                Geometry p2 = pReducer.reduce(v2);
                Geometry polygonGeom = p1.union(p2);
                Coordinate[] coordinates = polygonGeom.getCoordinates();
                ArrayList<Coordinate> coordinateList = new ArrayList<Coordinate>(Arrays.asList(coordinates));
                Coordinate lastCoordinate = coordinateList.get(0);
                coordinateList.add(lastCoordinate);
                Coordinate[] coordinatesClosed = new Coordinate[coordinateList.size()];
                coordinatesClosed = coordinateList.toArray(coordinatesClosed);
                GeometryFactory fact = new GeometryFactory();
                LinearRing linear = new GeometryFactory().createLinearRing(coordinatesClosed);
                Polygon polygon = new Polygon(linear, null, fact);
                return polygon;
            }
        });
        return result;
    }
}

