/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.sedona.common.utils.GeomUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.parquet.GeoDataSourceUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoDateTimeUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport$GeometryColumnBoundingBox$;
import org.apache.spark.sql.execution.datasources.parquet.GeometryFieldMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeometryFieldMetaData$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.json4s.DefaultFormats$;
import org.json4s.Extraction$;
import org.json4s.Formats;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBWriter;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r}e\u0001B(Q\u0001}CQ!\u001e\u0001\u0005\u0002Y,A!\u001f\u0001\u0005u\"Y\u0011\u0011\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u000e\u0011-\tI\u0003\u0001a\u0001\u0002\u0004%I!a\u000b\t\u0017\u0005E\u0002\u00011A\u0001B\u0003&\u0011Q\u0004\u0005\f\u0003g\u0001\u0001\u0019!a\u0001\n\u0013\t)\u0004C\u0006\u0002B\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0003bCA$\u0001\u0001\u0007\t\u0011)Q\u0005\u0003oA1\"!\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002L!Y\u00111\f\u0001A\u0002\u0003\u0007I\u0011BA/\u0011-\t\t\u0007\u0001a\u0001\u0002\u0003\u0006K!!\u0014\t\u0017\u0005\r\u0004\u00011AA\u0002\u0013%\u0011Q\r\u0005\f\u0003[\u0002\u0001\u0019!a\u0001\n\u0013\ty\u0007C\u0006\u0002t\u0001\u0001\r\u0011!Q!\n\u0005\u001d\u0004bCA;\u0001\u0001\u0007\t\u0019!C\u0005\u0003oB1\"!&\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0018\"Y\u00111\u0014\u0001A\u0002\u0003\u0005\u000b\u0015BA=\u0011%\ti\n\u0001b\u0001\n\u0013\ty\n\u0003\u0005\u0002*\u0002\u0001\u000b\u0011BAQ\u0011%\tY\u000b\u0001b\u0001\n\u0013\ty\n\u0003\u0005\u0002.\u0002\u0001\u000b\u0011BAQ\u0011%\ty\u000b\u0001b\u0001\n\u0013\t\t\f\u0003\u0005\u0002X\u0002\u0001\u000b\u0011BAZ\u0011%\tI\u000e\u0001b\u0001\n\u0013\tY\u000e\u0003\u0005\u0002d\u0002\u0001\u000b\u0011BAo\u0011%\t)\u000f\u0001b\u0001\n\u0013\t9\u000f\u0003\u0005\u0002r\u0002\u0001\u000b\u0011BAu\u0011%\t\u0019\u0010\u0001b\u0001\n\u0013\t\t\f\u0003\u0005\u0002v\u0002\u0001\u000b\u0011BAZ\u0011%\t9\u0010\u0001b\u0001\n\u0013\t9\u000f\u0003\u0005\u0002z\u0002\u0001\u000b\u0011BAu\u0011%\tY\u0010\u0001b\u0001\n\u0013\ti\u0010\u0003\u0005\u0003^\u0002\u0001\u000b\u0011BA\u0000\u0011\u001d\u0011y\u000e\u0001C!\u0005CDqaa\u0004\u0001\t\u0003\u001a\t\u0002C\u0004\u0004\u0016\u0001!\tea\u0006\t\u000f\r\u0005\u0002\u0001\"\u0011\u0004$!91\u0011\u0006\u0001\u0005\n\r-\u0002bBB\u001b\u0001\u0011%1q\u0007\u0005\n\u0007\u001b\u0002\u0011\u0013!C\u0005\u0007\u001fBqaa\u0015\u0001\t\u0013\u0019)\u0006C\u0004\u0004`\u0001!\ta!\u0019\t\u000f\r5\u0004\u0001\"\u0003\u0004p!911\u0010\u0001\u0005\n\ru\u0004bBBE\u0001\u0011%11\u0012\u0005\b\u0007\u001f\u0003A\u0011BBI\u000f\u001d\u0011y\u0002\u0015E\u0001\u0005C1aa\u0014)\t\u0002\t\r\u0002BB;1\t\u0003\u0011YC\u0002\u0004\u0003.A\u0002!q\u0006\u0005\u0007kJ\"\tA!\r\t\u0013\t]\"G1A\u0005\u0002\te\u0002\u0002\u0003BKe\u0001\u0006IAa\u000f\t\u0013\t]%G1A\u0005\u0002\te\u0005\u0002\u0003BYe\u0001\u0006IAa'\t\u000f\tm$\u0007\"\u0001\u00034\u001a1!Q\b\u0019\u0001\u0005\u007fA!B!\u0011:\u0005\u0003\u0007I\u0011\u0001B\"\u0011)\u0011Y%\u000fBA\u0002\u0013\u0005!Q\n\u0005\u000b\u0005#J$\u0011!Q!\n\t\u0015\u0003B\u0003B*s\t\u0005\r\u0011\"\u0001\u0003D!Q!QK\u001d\u0003\u0002\u0004%\tAa\u0016\t\u0015\tm\u0013H!A!B\u0013\u0011)\u0005\u0003\u0006\u0003^e\u0012\t\u0019!C\u0001\u0005\u0007B!Ba\u0018:\u0005\u0003\u0007I\u0011\u0001B1\u0011)\u0011)'\u000fB\u0001B\u0003&!Q\t\u0005\u000b\u0005OJ$\u00111A\u0005\u0002\t\r\u0003B\u0003B5s\t\u0005\r\u0011\"\u0001\u0003l!Q!qN\u001d\u0003\u0002\u0003\u0006KA!\u0012\t\rULD\u0011\u0001B9\u0011\u001d\u0011Y(\u000fC\u0001\u0005{:\u0011Ba.1\u0003\u0003E\tA!/\u0007\u0013\tu\u0002'!A\t\u0002\tm\u0006BB;J\t\u0003\u0011i\fC\u0005\u0003@&\u000b\n\u0011\"\u0001\u0003B\"I!q[%\u0012\u0002\u0013\u0005!\u0011\u0019\u0005\n\u00053L\u0015\u0013!C\u0001\u0005\u0003D\u0011Ba7J#\u0003%\tA!1\u0003-\u001d+w\u000eU1scV,Go\u0016:ji\u0016\u001cV\u000f\u001d9peRT!!\u0015*\u0002\u000fA\f'/];fi*\u00111\u000bV\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002V-\u0006IQ\r_3dkRLwN\u001c\u0006\u0003/b\u000b1a]9m\u0015\tI&,A\u0003ta\u0006\u00148N\u0003\u0002\\9\u00061\u0011\r]1dQ\u0016T\u0011!X\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0001|\u0007cA1hS6\t!M\u0003\u0002dI\u0006\u0019\u0011\r]5\u000b\u0005\u00154\u0017A\u00025bI>|\u0007O\u0003\u0002R5&\u0011\u0001N\u0019\u0002\r/JLG/Z*vaB|'\u000f\u001e\t\u0003U6l\u0011a\u001b\u0006\u0003YZ\u000b\u0001bY1uC2L8\u000f^\u0005\u0003].\u00141\"\u00138uKJt\u0017\r\u001c*poB\u0011\u0001o]\u0007\u0002c*\u0011!\u000fW\u0001\tS:$XM\u001d8bY&\u0011A/\u001d\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tq\u000f\u0005\u0002y\u00015\t\u0001KA\u0006WC2,Xm\u0016:ji\u0016\u0014\b\u0003C>\u007f\u0003\u0003\ti!a\u0005\u000e\u0003qT\u0011!`\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fr\u0014\u0011BR;oGRLwN\u001c\u001a\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002l\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005-\u0011Q\u0001\u0002\u0013'B,7-[1mSj,GmR3ui\u0016\u00148\u000fE\u0002|\u0003\u001fI1!!\u0005}\u0005\rIe\u000e\u001e\t\u0004w\u0006U\u0011bAA\fy\n!QK\\5u\u0003\u0019\u00198\r[3nCV\u0011\u0011Q\u0004\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111\u0005,\u0002\u000bQL\b/Z:\n\t\u0005\u001d\u0012\u0011\u0005\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017AC:dQ\u0016l\u0017m\u0018\u0013fcR!\u00111CA\u0017\u0011%\ty\u0003BA\u0001\u0002\u0004\ti\"A\u0002yIE\nqa]2iK6\f\u0007%\u0001\ts_>$h)[3mI^\u0013\u0018\u000e^3sgV\u0011\u0011q\u0007\t\u0006w\u0006e\u0012QH\u0005\u0004\u0003wa(!B!se\u0006L\bcAA \u00055\t\u0001!\u0001\u000bs_>$h)[3mI^\u0013\u0018\u000e^3sg~#S-\u001d\u000b\u0005\u0003'\t)\u0005C\u0005\u00020\u001d\t\t\u00111\u0001\u00028\u0005\t\"o\\8u\r&,G\u000eZ,sSR,'o\u001d\u0011\u0002\u001dI,7m\u001c:e\u0007>t7/^7feV\u0011\u0011Q\n\t\u0005\u0003\u001f\n9&\u0004\u0002\u0002R)\u00191-a\u0015\u000b\u0007\u0005Uc-\u0001\u0002j_&!\u0011\u0011LA)\u00059\u0011VmY8sI\u000e{gn];nKJ\f!C]3d_J$7i\u001c8tk6,'o\u0018\u0013fcR!\u00111CA0\u0011%\tyCCA\u0001\u0002\u0004\ti%A\bsK\u000e|'\u000fZ\"p]N,X.\u001a:!\u0003a9(/\u001b;f\u0019\u0016<\u0017mY=QCJ\fX/\u001a;G_Jl\u0017\r^\u000b\u0003\u0003O\u00022a_A5\u0013\r\tY\u0007 \u0002\b\u0005>|G.Z1o\u0003q9(/\u001b;f\u0019\u0016<\u0017mY=QCJ\fX/\u001a;G_Jl\u0017\r^0%KF$B!a\u0005\u0002r!I\u0011qF\u0007\u0002\u0002\u0003\u0007\u0011qM\u0001\u001aoJLG/\u001a'fO\u0006\u001c\u0017\u0010U1scV,GOR8s[\u0006$\b%A\npkR\u0004X\u000f\u001e+j[\u0016\u001cH/Y7q)f\u0004X-\u0006\u0002\u0002zA!\u00111PAG\u001d\u0011\ti(a\"\u000f\t\u0005}\u00141Q\u0007\u0003\u0003\u0003S!A\u001d,\n\t\u0005\u0015\u0015\u0011Q\u0001\b'Fc5i\u001c8g\u0013\u0011\tI)a#\u00025A\u000b'/];fi>+H\u000f];u)&lWm\u001d;b[B$\u0016\u0010]3\u000b\t\u0005\u0015\u0015\u0011Q\u0005\u0005\u0003\u001f\u000b\tJA\u0003WC2,X-C\u0002\u0002\u0014r\u00141\"\u00128v[\u0016\u0014\u0018\r^5p]\u00069r.\u001e;qkR$\u0016.\\3ti\u0006l\u0007\u000fV=qK~#S-\u001d\u000b\u0005\u0003'\tI\nC\u0005\u00020A\t\t\u00111\u0001\u0002z\u0005!r.\u001e;qkR$\u0016.\\3ti\u0006l\u0007\u000fV=qK\u0002\nq\u0002^5nKN$\u0018-\u001c9Ck\u001a4WM]\u000b\u0003\u0003C\u0003Ra_A\u001d\u0003G\u00032a_AS\u0013\r\t9\u000b \u0002\u0005\u0005f$X-\u0001\tuS6,7\u000f^1na\n+hMZ3sA\u0005iA-Z2j[\u0006d')\u001e4gKJ\fa\u0002Z3dS6\fGNQ;gM\u0016\u0014\b%\u0001\neCR,G/[7f%\u0016\u0014\u0017m]3N_\u0012,WCAAZ!\u0011\t),!$\u000f\t\u0005]\u00161\u001b\b\u0005\u0003s\u000b\u0019I\u0004\u0003\u0002<\u0006Eg\u0002BA_\u0003\u001ftA!a0\u0002N:!\u0011\u0011YAf\u001d\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'bAAd=\u00061AH]8pizJ\u0011!X\u0005\u00037rK!!\u0017.\n\u0005]C\u0016B\u0001:W\u0013\u0011\t).a#\u0002)1+w-Y2z\u0005\u0016D\u0017M^5peB{G.[2z\u0003M!\u0017\r^3uS6,'+\u001a2bg\u0016lu\u000eZ3!\u00039!\u0017\r^3SK\n\f7/\u001a$v]\u000e,\"!!8\u0011\u000fm\fy.!\u0004\u0002\u000e%\u0019\u0011\u0011\u001d?\u0003\u0013\u0019+hn\u0019;j_:\f\u0014a\u00043bi\u0016\u0014VMY1tK\u001a+hn\u0019\u0011\u0002'QLW.Z:uC6\u0004(+\u001a2bg\u00164UO\\2\u0016\u0005\u0005%\bcB>\u0002`\u0006-\u00181\u001e\t\u0004w\u00065\u0018bAAxy\n!Aj\u001c8h\u0003Q!\u0018.\\3ti\u0006l\u0007OU3cCN,g)\u001e8dA\u0005y\u0011N\u001c;:mI+'-Y:f\u001b>$W-\u0001\tj]RLdGU3cCN,Wj\u001c3fA\u0005y\u0011N\u001c;:mI+'-Y:f\rVt7-\u0001\tj]RLdGU3cCN,g)\u001e8dA\u0005)r-Z8nKR\u0014\u0018pQ8mk6t\u0017J\u001c4p\u001b\u0006\u0004XCAA\u0000!!\u0011\tAa\u0003\u0002\u000e\t=QB\u0001B\u0002\u0015\u0011\u0011)Aa\u0002\u0002\u000f5,H/\u00192mK*\u0019!\u0011\u0002?\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u000e\t\r!aA'baB\u0019!\u0011\u0003\u001a\u000f\u0007\tMqF\u0004\u0003\u0003\u0016\tua\u0002\u0002B\f\u00057qA!a/\u0003\u001a%\u0011QKV\u0005\u0003'RK!!\u0015*\u0002-\u001d+w\u000eU1scV,Go\u0016:ji\u0016\u001cV\u000f\u001d9peR\u0004\"\u0001\u001f\u0019\u0014\u0007A\u0012)\u0003E\u0002|\u0005OI1A!\u000b}\u0005\u0019\te.\u001f*fMR\u0011!\u0011\u0005\u0002\u0013\u000f\u0016|W.\u001a;ss\u000e{G.^7o\u0013:4wnE\u00023\u0005K!\"Aa\r\u0011\u0007\tU\"'D\u00011\u0003\u0011\u0011'm\u001c=\u0016\u0005\tm\u0002c\u0001B\u001bs\tIr)Z8nKR\u0014\u0018pQ8mk6t'i\\;oI&twMQ8y'\rI$QE\u0001\u0005[&t\u0007,\u0006\u0002\u0003FA\u00191Pa\u0012\n\u0007\t%CP\u0001\u0004E_V\u0014G.Z\u0001\t[&t\u0007l\u0018\u0013fcR!\u00111\u0003B(\u0011%\tycOA\u0001\u0002\u0004\u0011)%A\u0003nS:D\u0006%\u0001\u0003nS:L\u0016\u0001C7j]f{F%Z9\u0015\t\u0005M!\u0011\f\u0005\n\u0003_q\u0014\u0011!a\u0001\u0005\u000b\nQ!\\5o3\u0002\nA!\\1y1\u0006AQ.\u0019=Y?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\t\r\u0004\"CA\u0018\u0003\u0006\u0005\t\u0019\u0001B#\u0003\u0015i\u0017\r\u001f-!\u0003\u0011i\u0017\r_-\u0002\u00115\f\u00070W0%KF$B!a\u0005\u0003n!I\u0011q\u0006#\u0002\u0002\u0003\u0007!QI\u0001\u0006[\u0006D\u0018\f\t\u000b\u000b\u0005w\u0011\u0019H!\u001e\u0003x\te\u0004\"\u0003B!\rB\u0005\t\u0019\u0001B#\u0011%\u0011\u0019F\u0012I\u0001\u0002\u0004\u0011)\u0005C\u0005\u0003^\u0019\u0003\n\u00111\u0001\u0003F!I!q\r$\u0011\u0002\u0003\u0007!QI\u0001\u0007kB$\u0017\r^3\u0015\t\u0005M!q\u0010\u0005\b\u0005\u0003;\u0005\u0019\u0001BB\u0003\u00119Wm\\7\u0011\t\t\u0015%\u0011S\u0007\u0003\u0005\u000fSAA!!\u0003\n*!!1\u0012BG\u0003\rQGo\u001d\u0006\u0004\u0005\u001fc\u0016\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD\u0017\u0002\u0002BJ\u0005\u000f\u0013\u0001bR3p[\u0016$(/_\u0001\u0006E\n|\u0007\u0010I\u0001\u0012g\u0016,gnR3p[\u0016$(/\u001f+za\u0016\u001cXC\u0001BN!\u0019\u0011\tA!(\u0003\"&!!q\u0014B\u0002\u0005\r\u0019V\r\u001e\t\u0005\u0005G\u0013YK\u0004\u0003\u0003&\n\u001d\u0006cAAby&\u0019!\u0011\u0016?\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011iKa,\u0003\rM#(/\u001b8h\u0015\r\u0011I\u000b`\u0001\u0013g\u0016,gnR3p[\u0016$(/\u001f+za\u0016\u001c\b\u0005\u0006\u0003\u0002\u0014\tU\u0006b\u0002BAq\u0001\u0007!1Q\u0001\u001a\u000f\u0016|W.\u001a;ss\u000e{G.^7o\u0005>,h\u000eZ5oO\n{\u0007\u0010E\u0002\u00036%\u001b2!\u0013B\u0013)\t\u0011I,A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0007TCA!\u0012\u0003F.\u0012!q\u0019\t\u0005\u0005\u0013\u0014\u0019.\u0004\u0002\u0003L*!!Q\u001aBh\u0003%)hn\u00195fG.,GMC\u0002\u0003Rr\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Na3\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003Y9Wm\\7fiJL8i\u001c7v[:LeNZ8NCB\u0004\u0013\u0001B5oSR$BAa9\u0003~B!!Q\u001dB|\u001d\u0011\u00119Oa=\u000f\t\t%(\u0011\u001f\b\u0005\u0005W\u0014yO\u0004\u0003\u0002@\n5\u0018BA)[\u0013\t)g-\u0003\u0002dI&\u0019!Q\u001f2\u0002\u0019]\u0013\u0018\u000e^3TkB\u0004xN\u001d;\n\t\te(1 \u0002\r/JLG/Z\"p]R,\u0007\u0010\u001e\u0006\u0004\u0005k\u0014\u0007b\u0002B\u0000E\u0001\u00071\u0011A\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\t\r\r11B\u0007\u0003\u0007\u000bQAaa\u0002\u0004\n\u0005!1m\u001c8g\u0015\t)',\u0003\u0003\u0004\u000e\r\u0015!!D\"p]\u001aLw-\u001e:bi&|g.A\bqe\u0016\u0004\u0018M]3G_J<&/\u001b;f)\u0011\t\u0019ba\u0005\t\u000f\u0005%3\u00051\u0001\u0002N\u0005ia-\u001b8bY&TXm\u0016:ji\u0016$\"a!\u0007\u0011\t\rm1Q\u0004\b\u0004C\nM\u0018\u0002BB\u0010\u0005w\u0014QCR5oC2L'0\u001a3Xe&$XmQ8oi\u0016DH/A\u0003xe&$X\r\u0006\u0003\u0002\u0014\r\u0015\u0002BBB\u0014K\u0001\u0007\u0011.A\u0002s_^\f1b\u001e:ji\u00164\u0015.\u001a7egRA\u00111CB\u0017\u0007_\u0019\t\u0004\u0003\u0004\u0004(\u0019\u0002\r!\u001b\u0005\b\u000331\u0003\u0019AA\u000f\u0011\u001d\u0019\u0019D\na\u0001\u0003o\tABZ5fY\u0012<&/\u001b;feN\f!\"\\1lK^\u0013\u0018\u000e^3s)\u0019\tid!\u000f\u0004D!911H\u0014A\u0002\ru\u0012\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\t\u0005}1qH\u0005\u0005\u0007\u0003\n\tC\u0001\u0005ECR\fG+\u001f9f\u0011%\u0019)e\nI\u0001\u0002\u0004\u00199%A\u0006s_>$xJ\u001d3j]\u0006d\u0007#B>\u0004J\u00055\u0011bAB&y\n1q\n\u001d;j_:\fA#\\1lK^\u0013\u0018\u000e^3sI\u0011,g-Y;mi\u0012\u0012TCAB)U\u0011\u00199E!2\u0002#5\f7.\u001a#fG&l\u0017\r\\,sSR,'\u000f\u0006\u0004\u0002>\r]31\f\u0005\b\u00073J\u0003\u0019AA\u0007\u0003%\u0001(/Z2jg&|g\u000eC\u0004\u0004^%\u0002\r!!\u0004\u0002\u000bM\u001c\u0017\r\\3\u0002\u001f5\f7.Z!se\u0006LxK]5uKJ$B!!\u0010\u0004d!91Q\r\u0016A\u0002\r\u001d\u0014!C1se\u0006LH+\u001f9f!\u0011\tyb!\u001b\n\t\r-\u0014\u0011\u0005\u0002\n\u0003J\u0014\u0018-\u001f+za\u0016\fQ\"\\1lK6\u000b\u0007o\u0016:ji\u0016\u0014H\u0003BA\u001f\u0007cBqaa\u001d,\u0001\u0004\u0019)(A\u0004nCB$\u0016\u0010]3\u0011\t\u0005}1qO\u0005\u0005\u0007s\n\tCA\u0004NCB$\u0016\u0010]3\u0002\u001d\r|gn];nK6+7o]1hKR!\u00111CB@\u0011!\u0019\t\t\fCA\u0002\r\r\u0015!\u00014\u0011\u000bm\u001c))a\u0005\n\u0007\r\u001dEP\u0001\u0005=Eft\u0017-\\3?\u00031\u0019wN\\:v[\u0016<%o\\;q)\u0011\t\u0019b!$\t\u0011\r\u0005U\u0006\"a\u0001\u0007\u0007\u000bAbY8ogVlWMR5fY\u0012$baa%\u0004\u0018\u000emE\u0003BA\n\u0007+C\u0001b!!/\t\u0003\u000711\u0011\u0005\b\u00073s\u0003\u0019\u0001BQ\u0003\u00151\u0017.\u001a7e\u0011\u001d\u0019iJ\fa\u0001\u0003\u001b\tQ!\u001b8eKb\u0004")
public class GeoParquetWriteSupport
extends WriteSupport<InternalRow>
implements Logging {
    private StructType schema;
    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters;
    private RecordConsumer recordConsumer;
    private boolean writeLegacyParquetFormat;
    private Enumeration.Value outputTimestampType;
    private final byte[] timestampBuffer;
    private final byte[] decimalBuffer;
    private final Enumeration.Value datetimeRebaseMode;
    private final Function1<Object, Object> dateRebaseFunc;
    private final Function1<Object, Object> timestampRebaseFunc;
    private final Enumeration.Value int96RebaseMode;
    private final Function1<Object, Object> int96RebaseFunc;
    private final scala.collection.mutable.Map<Object, GeometryColumnInfo> geometryColumnInfoMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType schema() {
        return this.schema;
    }

    private void schema_$eq(StructType x$1) {
        this.schema = x$1;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters() {
        return this.rootFieldWriters;
    }

    private void rootFieldWriters_$eq(Function2<SpecializedGetters, Object, BoxedUnit>[] x$1) {
        this.rootFieldWriters = x$1;
    }

    private RecordConsumer recordConsumer() {
        return this.recordConsumer;
    }

    private void recordConsumer_$eq(RecordConsumer x$1) {
        this.recordConsumer = x$1;
    }

    private boolean writeLegacyParquetFormat() {
        return this.writeLegacyParquetFormat;
    }

    private void writeLegacyParquetFormat_$eq(boolean x$1) {
        this.writeLegacyParquetFormat = x$1;
    }

    private Enumeration.Value outputTimestampType() {
        return this.outputTimestampType;
    }

    private void outputTimestampType_$eq(Enumeration.Value x$1) {
        this.outputTimestampType = x$1;
    }

    private byte[] timestampBuffer() {
        return this.timestampBuffer;
    }

    private byte[] decimalBuffer() {
        return this.decimalBuffer;
    }

    private Enumeration.Value datetimeRebaseMode() {
        return this.datetimeRebaseMode;
    }

    private Function1<Object, Object> dateRebaseFunc() {
        return this.dateRebaseFunc;
    }

    private Function1<Object, Object> timestampRebaseFunc() {
        return this.timestampRebaseFunc;
    }

    private Enumeration.Value int96RebaseMode() {
        return this.int96RebaseMode;
    }

    private Function1<Object, Object> int96RebaseFunc() {
        return this.int96RebaseFunc;
    }

    private scala.collection.mutable.Map<Object, GeometryColumnInfo> geometryColumnInfoMap() {
        return this.geometryColumnInfoMap;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        String schemaString = configuration.get(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        this.schema_$eq(StructType$.MODULE$.fromString(schemaString));
        Predef$.MODULE$.assert(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()) != null);
        this.writeLegacyParquetFormat_$eq(new StringOps(Predef$.MODULE$.augmentString(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))).toBoolean());
        String key = SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key();
        Predef$.MODULE$.assert(configuration.get(key) != null);
        this.outputTimestampType_$eq(SQLConf.ParquetOutputTimestampType$.MODULE$.withName(configuration.get(key)));
        this.rootFieldWriters_$eq((Function2[])((TraversableOnce)((TraversableLike)this.schema().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField field = (StructField)tuple2._1();
            int ordinal = tuple2._2$mcI$sp();
            Function2<SpecializedGetters, Object, BoxedUnit> function2 = this.makeWriter(field.dataType(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)ordinal)));
            return function2;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class)));
        if (this.geometryColumnInfoMap().isEmpty()) {
            throw new RuntimeException("No geometry column found in the schema");
        }
        MessageType messageType = new SparkToParquetSchemaConverter(configuration).convert(this.schema());
        Enumeration.Value value = this.datetimeRebaseMode();
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value3 = this.int96RebaseMode();
        Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        scala.collection.immutable.Map metadata = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY()), (Object)org.apache.spark.package$.MODULE$.SPARK_VERSION_SHORT()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()), (Object)schemaString)}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)(!(value != null ? !value.equals(value2) : value2 != null) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.legacyDateTime"), (Object)"")) : None$.MODULE$))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)(!(value3 != null ? !value3.equals(value4) : value4 != null) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.legacyINT96"), (Object)"")) : None$.MODULE$)));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("Initialized Parquet WriteSupport with Catalyst schema:\n         |").append(this.schema().prettyJson()).append("\n         |and corresponding Parquet message type:\n         |").append(messageType).append("\n       ").toString())).stripMargin());
        return new WriteSupport.WriteContext(messageType, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)metadata).asJava());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer_$eq(recordConsumer);
    }

    public WriteSupport.FinalizedWriteContext finalizeWrite() {
        Object object;
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.geometryColumnInfoMap().nonEmpty()) {
            int primaryColumnIndex = BoxesRunTime.unboxToInt((Object)this.geometryColumnInfoMap().keys().head());
            String primaryColumn = this.schema().fields()[primaryColumnIndex].name();
            scala.collection.immutable.Map columns = ((TraversableOnce)this.geometryColumnInfoMap().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int ordinal = tuple2._1$mcI$sp();
                GeometryColumnInfo columnInfo = (GeometryColumnInfo)tuple2._2();
                String columnName = this.schema().fields()[ordinal].name();
                Seq geometryTypes = columnInfo.seenGeometryTypes().toSeq();
                Seq bbox = geometryTypes.nonEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{columnInfo.bbox().minX(), columnInfo.bbox().minY(), columnInfo.bbox().maxX(), columnInfo.bbox().maxY()})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0}));
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnName), (Object)new GeometryFieldMetaData("WKB", geometryTypes, bbox, GeometryFieldMetaData$.MODULE$.apply$default$4()));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            GeoParquetMetaData geoParquetMetadata = new GeoParquetMetaData((Option)new Some((Object)GeoParquetMetaData$.MODULE$.VERSION()), primaryColumn, columns);
            Formats formats = DefaultFormats$.MODULE$.preservingEmptyValues();
            String geoParquetMetadataJson = org.json4s.jackson.package$.MODULE$.compactJson(org.json4s.package$.MODULE$.jvalue2monadic(Extraction$.MODULE$.decompose((Object)geoParquetMetadata, formats)).underscoreKeys());
            object = metadata.put("geo", geoParquetMetadataJson);
        } else {
            object = BoxedUnit.UNIT;
        }
        return new WriteSupport.FinalizedWriteContext(metadata);
    }

    public void write(InternalRow row) {
        this.consumeMessage((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writeFields(row, this.schema(), this.rootFieldWriters()));
    }

    private void writeFields(InternalRow row, StructType schema, Function2<SpecializedGetters, Object, BoxedUnit>[] fieldWriters) {
        IntRef i = IntRef.create((int)0);
        while (i.elem < row.numFields()) {
            if (!row.isNullAt(i.elem)) {
                this.consumeField(schema.apply(i.elem).name(), i.elem, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fieldWriters[i$1.elem].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i$1.elem)));
            }
            ++i.elem;
        }
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeWriter(DataType dataType, Option<Object> rootOrdinal) {
        Function2 & Serializable & scala.Serializable intersect;
        block27: {
            while (true) {
                DecimalType decimalType;
                Option option;
                DataType dataType2;
                if (BooleanType$.MODULE$.equals(dataType2 = dataType)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (ByteType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (ShortType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (DateType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (IntegerType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (LongType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (FloatType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$7(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (DoubleType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (StringType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (TimestampType$.MODULE$.equals(dataType2)) {
                    Function2 & Serializable & scala.Serializable intersect2;
                    Enumeration.Value value = this.outputTimestampType();
                    Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                            GeoParquetWriteSupport.$anonfun$makeWriter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                            return BoxedUnit.UNIT;
                        };
                    } else {
                        Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                                GeoParquetWriteSupport.$anonfun$makeWriter$11(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                                return BoxedUnit.UNIT;
                            };
                        } else {
                            Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
                            Enumeration.Value value7 = value;
                            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                                    GeoParquetWriteSupport.$anonfun$makeWriter$12(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                                    return BoxedUnit.UNIT;
                                };
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                    intersect = intersect2;
                    break block27;
                }
                if (BinaryType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$13(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (dataType2 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType2)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    intersect = this.makeDecimalWriter(precision, scale);
                    break block27;
                }
                if (dataType2 instanceof StructType) {
                    StructType structType = (StructType)dataType2;
                    Function2[] fieldWriters = (Function2[])((TraversableOnce)((TraversableLike)structType.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> this.makeWriter((DataType)x$3, (Option<Object>)None$.MODULE$), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class));
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writeFields(row.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), structType.length()), structType, fieldWriters));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType2;
                    intersect = this.makeArrayWriter(arrayType);
                    break block27;
                }
                if (dataType2 instanceof MapType) {
                    MapType mapType = (MapType)dataType2;
                    intersect = this.makeMapWriter(mapType);
                    break block27;
                }
                if (GeometryUDT$.MODULE$.equals(dataType2)) {
                    GeometryColumnInfo geometryColumnInfo;
                    Option<Object> option2 = rootOrdinal;
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        int ordinal2 = BoxesRunTime.unboxToInt((Object)some.value());
                        geometryColumnInfo = (GeometryColumnInfo)this.geometryColumnInfoMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)ordinal2), (Function0 & Serializable & scala.Serializable)() -> new GeometryColumnInfo());
                    } else if (None$.MODULE$.equals(option2)) {
                        geometryColumnInfo = null;
                    } else {
                        throw new MatchError(option2);
                    }
                    GeometryColumnInfo geometryColumnInfo2 = geometryColumnInfo;
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$19(this, geometryColumnInfo2, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (!(dataType2 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                rootOrdinal = this.makeWriter$default$2();
                dataType = userDefinedType.sqlType();
            }
            throw scala.sys.package$.MODULE$.error(new StringBuilder(23).append("Unsupported data type ").append(dataType).append(".").toString());
        }
        return intersect;
    }

    private Option<Object> makeWriter$default$2() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function2<SpecializedGetters, Object, BoxedUnit> makeDecimalWriter(int precision, int scale) {
        Predef$.MODULE$.assert(precision <= DecimalType$.MODULE$.MAX_PRECISION(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Decimal precision ").append(precision).append(" exceeds max precision ").append(DecimalType$.MODULE$.MAX_PRECISION()).toString());
        int numBytes = Decimal$.MODULE$.minBytesForPrecision()[precision];
        Function2 & Serializable & scala.Serializable int32Writer = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$2(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable int64Writer = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$3(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable binaryWriterUsingUnscaledLong = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$4(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable binaryWriterUsingUnscaledBytes = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$5(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.writeLegacyParquetFormat();
        if (!bl3) {
            bl = true;
            bl2 = bl3;
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                return int32Writer;
            }
        }
        if (bl && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return int64Writer;
        }
        if (true != bl3) return binaryWriterUsingUnscaledBytes;
        if (precision > Decimal$.MODULE$.MAX_LONG_DIGITS()) return binaryWriterUsingUnscaledBytes;
        return binaryWriterUsingUnscaledLong;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function2<SpecializedGetters, Object, BoxedUnit> makeArrayWriter(ArrayType arrayType) {
        boolean bl;
        Function2<SpecializedGetters, Object, BoxedUnit> elementWriter = this.makeWriter(arrayType.elementType(), this.makeWriter$default$2());
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.writeLegacyParquetFormat(), arrayType.containsNull());
        if (sp2 != null && !(bl = sp2._1$mcZ$sp())) {
            return this.threeLevelArrayWriter$1("list", "element", elementWriter);
        }
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl2 && bl3) {
                return this.threeLevelArrayWriter$1("bag", "array", elementWriter);
            }
        }
        if (sp2 == null) throw new MatchError((Object)sp2);
        boolean bl4 = sp2._1$mcZ$sp();
        boolean bl5 = sp2._2$mcZ$sp();
        if (true != bl4) throw new MatchError((Object)sp2);
        if (false != bl5) throw new MatchError((Object)sp2);
        return this.twoLevelArrayWriter$1("array", elementWriter);
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeMapWriter(MapType mapType) {
        Function2<SpecializedGetters, Object, BoxedUnit> keyWriter = this.makeWriter(mapType.keyType(), this.makeWriter$default$2());
        Function2<SpecializedGetters, Object, BoxedUnit> valueWriter = this.makeWriter(mapType.valueType(), this.makeWriter$default$2());
        String repeatedGroupName = this.writeLegacyParquetFormat() ? "map" : "key_value";
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeMapWriter$1(this, repeatedGroupName, keyWriter, valueWriter, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    private void consumeMessage(Function0<BoxedUnit> f) {
        this.recordConsumer().startMessage();
        f.apply$mcV$sp();
        this.recordConsumer().endMessage();
    }

    private void consumeGroup(Function0<BoxedUnit> f) {
        this.recordConsumer().startGroup();
        f.apply$mcV$sp();
        this.recordConsumer().endGroup();
    }

    private void consumeField(String field, int index, Function0<BoxedUnit> f) {
        this.recordConsumer().startField(field, index);
        f.apply$mcV$sp();
        this.recordConsumer().endField(field, index);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$1(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBoolean(row.getBoolean(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$2(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getByte(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$3(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getShort(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$4(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger($this.dateRebaseFunc().apply$mcII$sp(row.getInt(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$5(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger(row.getInt(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$6(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$7(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addFloat(row.getFloat(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$8(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addDouble(row.getDouble(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$9(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getUTF8String(ordinal).getBytes()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$10(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = $this.int96RebaseFunc().apply$mcJJ$sp(row.getLong(ordinal));
        Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(micros);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int julianDay = tuple2._1$mcI$sp();
        long timeOfDayNanos = tuple2._2$mcJ$sp();
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(julianDay, timeOfDayNanos);
        Tuple2.mcIJ.sp sp3 = sp2;
        int julianDay2 = sp3._1$mcI$sp();
        long timeOfDayNanos2 = sp3._2$mcJ$sp();
        ByteBuffer buf = ByteBuffer.wrap($this.timestampBuffer());
        buf.order(ByteOrder.LITTLE_ENDIAN).putLong(timeOfDayNanos2).putInt(julianDay2);
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.timestampBuffer()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$11(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        $this.recordConsumer().addLong($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$12(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        long millis = GeoDateTimeUtils$.MODULE$.microsToMillis($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
        $this.recordConsumer().addLong(millis);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$13(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$19(GeoParquetWriteSupport $this, GeometryColumnInfo geometryColumnInfo$1, SpecializedGetters row, int ordinal) {
        block0: {
            byte[] serializedGeometry = row.getBinary(ordinal);
            Geometry geom = GeometryUDT$.MODULE$.deserialize((Object)serializedGeometry);
            WKBWriter wkbWriter = new WKBWriter(GeomUtils.getDimension((Geometry)geom));
            $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])wkbWriter.write(geom)));
            if (geometryColumnInfo$1 == null) break block0;
            geometryColumnInfo$1.update(geom);
        }
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$2(GeoParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addInteger((int)unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$3(GeoParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addLong(unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$4(GeoParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        long unscaled = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        int i = 0;
        int shift = 8 * (numBytes$1 - 1);
        while (i < numBytes$1) {
            $this.decimalBuffer()[i] = (byte)(unscaled >> shift);
            ++i;
            shift -= 8;
        }
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.decimalBuffer(), (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$5(GeoParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        byte[] byArray;
        Decimal decimal = row.getDecimal(ordinal, precision$1, scale$1);
        byte[] bytes = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
        if (bytes.length == numBytes$1) {
            byArray = bytes;
        } else {
            byte signByte = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).head()) < 0 ? (byte)-1 : 0;
            Arrays.fill($this.decimalBuffer(), 0, numBytes$1 - bytes.length, signByte);
            System.arraycopy(bytes, 0, $this.decimalBuffer(), numBytes$1 - bytes.length, bytes.length);
            byArray = $this.decimalBuffer();
        }
        byte[] fixedLengthBytes = byArray;
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])fixedLengthBytes, (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$1(GeoParquetWriteSupport $this, String repeatedGroupName$1, String elementFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (array.numElements() <= 0) break block0;
                $this.consumeField(repeatedGroupName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < array.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            block0: {
                                if (array.isNullAt(i$2.elem)) break block0;
                                $this.consumeField(elementFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i$2.elem)));
                            }
                        });
                        ++i.elem;
                    }
                });
            }
        });
    }

    private final Function2 threeLevelArrayWriter$1(String repeatedGroupName, String elementFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeArrayWriter$1(this, repeatedGroupName, elementFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$6(GeoParquetWriteSupport $this, String repeatedFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (array.numElements() <= 0) break block0;
                $this.consumeField(repeatedFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    for (int i = 0; i < array.numElements(); ++i) {
                        elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                });
            }
        });
    }

    private final Function2 twoLevelArrayWriter$1(String repeatedFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeArrayWriter$6(this, repeatedFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeMapWriter$1(GeoParquetWriteSupport $this, String repeatedGroupName$2, Function2 keyWriter$1, Function2 valueWriter$1, SpecializedGetters row, int ordinal) {
        MapData map = row.getMap(ordinal);
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (map.numElements() <= 0) break block0;
                $this.consumeField(repeatedGroupName$2, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < map.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            block0: {
                                $this.consumeField("key", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> keyWriter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                                if (map.valueArray().isNullAt(i$3.elem)) break block0;
                                $this.consumeField("value", 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> valueWriter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                            }
                        });
                        ++i.elem;
                    }
                });
            }
        });
    }

    public GeoParquetWriteSupport() {
        Logging.$init$((Logging)this);
        this.timestampBuffer = new byte[12];
        this.decimalBuffer = new byte[Decimal$.MODULE$.minBytesForPrecision()[DecimalType$.MODULE$.MAX_PRECISION()]];
        this.datetimeRebaseMode = SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(SQLConf$.MODULE$.get().getConfString(GeoDataSourceUtils$.MODULE$.PARQUET_REBASE_MODE_IN_WRITE()));
        this.dateRebaseFunc = GeoDataSourceUtils$.MODULE$.creteDateRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.timestampRebaseFunc = GeoDataSourceUtils$.MODULE$.creteTimestampRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.int96RebaseMode = SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(SQLConf$.MODULE$.get().getConfString(GeoDataSourceUtils$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_WRITE()));
        this.int96RebaseFunc = GeoDataSourceUtils$.MODULE$.creteTimestampRebaseFuncInWrite(this.int96RebaseMode(), "Parquet INT96");
        this.geometryColumnInfoMap = Map$.MODULE$.empty();
    }

    public static class GeometryColumnBoundingBox {
        private double minX;
        private double minY;
        private double maxX;
        private double maxY;

        public double minX() {
            return this.minX;
        }

        public void minX_$eq(double x$1) {
            this.minX = x$1;
        }

        public double minY() {
            return this.minY;
        }

        public void minY_$eq(double x$1) {
            this.minY = x$1;
        }

        public double maxX() {
            return this.maxX;
        }

        public void maxX_$eq(double x$1) {
            this.maxX = x$1;
        }

        public double maxY() {
            return this.maxY;
        }

        public void maxY_$eq(double x$1) {
            this.maxY = x$1;
        }

        public void update(Geometry geom) {
            Envelope env = geom.getEnvelopeInternal();
            this.minX_$eq(scala.math.package$.MODULE$.min(this.minX(), env.getMinX()));
            this.minY_$eq(scala.math.package$.MODULE$.min(this.minY(), env.getMinY()));
            this.maxX_$eq(scala.math.package$.MODULE$.max(this.maxX(), env.getMaxX()));
            this.maxY_$eq(scala.math.package$.MODULE$.max(this.maxY(), env.getMaxY()));
        }

        public GeometryColumnBoundingBox(double minX, double minY, double maxX, double maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }
    }

    public static class GeometryColumnInfo {
        private final GeometryColumnBoundingBox bbox = new GeometryColumnBoundingBox(GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$1(), GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$2(), GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$3(), GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$4());
        private final Set<String> seenGeometryTypes = Set$.MODULE$.empty();

        public GeometryColumnBoundingBox bbox() {
            return this.bbox;
        }

        public Set<String> seenGeometryTypes() {
            return this.seenGeometryTypes;
        }

        public void update(Geometry geom) {
            this.bbox().update(geom);
            Coordinate coordinate = geom.getCoordinate();
            boolean hasZ = coordinate != null ? !Double.isNaN(coordinate.getZ()) : false;
            String geometryType = !hasZ ? geom.getGeometryType() : new StringBuilder(2).append(geom.getGeometryType()).append(" Z").toString();
            this.seenGeometryTypes().add((Object)geometryType);
        }
    }
}

