/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.GeoDataSourceUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormatBase;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t=a\u0001\u0002\u000b\u0016\u0001\u0011B\u0001B\u0013\u0001\u0003\u0006\u0004%\ta\u0013\u0005\t'\u0002\u0011\t\u0011)A\u0005\u0019\")A\u000b\u0001C\u0001+\")A\u000b\u0001C\u00011\")\u0011\f\u0001C!5\")1\r\u0001C!I\")\u0001\u000e\u0001C\u0001S\")1\u000e\u0001C!Y\"9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA'\u0001\u0011\u0005\u0013q\n\u0005\b\u00033\u0003A\u0011IAN\u0011\u001d\t9\u000b\u0001C!\u0003S;q!!-\u0016\u0011\u0003\t\u0019L\u0002\u0004\u0015+!\u0005\u0011Q\u0017\u0005\u0007):!\t!a3\t\u000f\u00055g\u0002\"\u0001\u0002P\"9\u0011\u0011\u001c\b\u0005\n\u0005m\u0007bBA|\u001d\u0011%\u0011\u0011 \u0005\n\u0003\u007ft\u0011\u0011!C\u0005\u0005\u0003\u0011AcR3p!\u0006\u0014\u0018/^3u\r&dWMR8s[\u0006$(B\u0001\f\u0018\u0003\u001d\u0001\u0018M]9vKRT!\u0001G\r\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u00035m\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005qi\u0012aA:rY*\u0011adH\u0001\u0006gB\f'o\u001b\u0006\u0003A\u0005\na!\u00199bG\",'\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001)\u0013\u0006\f\u00197yA\u0011aeJ\u0007\u0002+%\u0011\u0001&\u0006\u0002\u0012!\u0006\u0014\u0018/^3u\r&dWMR8s[\u0006$\bC\u0001\u0014+\u0013\tYSC\u0001\rHK>\u0004\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\"bg\u0016\u0004\"!\f\u0018\u000e\u0003]I!aL\f\u0003\u0015\u0019KG.\u001a$pe6\fG\u000f\u0005\u00022i5\t!G\u0003\u000247\u000591o\\;sG\u0016\u001c\u0018BA\u001b3\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\u0011\u0005]RT\"\u0001\u001d\u000b\u0005ej\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005mB$a\u0002'pO\u001eLgn\u001a\t\u0003{\u001ds!A\u0010#\u000f\u0005}\u0012U\"\u0001!\u000b\u0005\u0005\u001b\u0013A\u0002\u001fs_>$h(C\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)e)A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\rK!\u0001S%\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u00153\u0015!D:qCRL\u0017\r\u001c$jYR,'/F\u0001M!\rie\nU\u0007\u0002\r&\u0011qJ\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0019\n\u0016B\u0001*\u0016\u0005]9Um\u001c)beF,X\r^*qCRL\u0017\r\u001c$jYR,'/\u0001\bta\u0006$\u0018.\u00197GS2$XM\u001d\u0011\u0002\rqJg.\u001b;?)\t1v\u000b\u0005\u0002'\u0001!)!j\u0001a\u0001\u0019R\ta+\u0001\u0004fcV\fGn\u001d\u000b\u00037z\u0003\"!\u0014/\n\u0005u3%a\u0002\"p_2,\u0017M\u001c\u0005\u0006?\u0016\u0001\r\u0001Y\u0001\u0006_RDWM\u001d\t\u0003\u001b\u0006L!A\u0019$\u0003\u0007\u0005s\u00170\u0001\u0005iCND7i\u001c3f)\u0005)\u0007CA'g\u0013\t9gIA\u0002J]R\fQc^5uQN\u0003\u0018\r^5bYB\u0013X\rZ5dCR,7\u000f\u0006\u0002WU\")!j\u0002a\u0001!\u0006Y\u0011N\u001c4feN\u001b\u0007.Z7b)\u0015iGO_A\b!\rieJ\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003cn\tQ\u0001^=qKNL!a\u001d9\u0003\u0015M#(/^2u)f\u0004X\rC\u0003v\u0011\u0001\u0007a/\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002xq6\t1$\u0003\u0002z7\ta1\u000b]1sWN+7o]5p]\")1\u0010\u0003a\u0001y\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0011\u000fu\f\u0019!!\u0003\u0002\n9\u0011ap \t\u0003\u007f\u0019K1!!\u0001G\u0003\u0019\u0001&/\u001a3fM&!\u0011QAA\u0004\u0005\ri\u0015\r\u001d\u0006\u0004\u0003\u00031\u0005cA?\u0002\f%!\u0011QBA\u0004\u0005\u0019\u0019FO]5oO\"9\u0011\u0011\u0003\u0005A\u0002\u0005M\u0011!\u00024jY\u0016\u001c\b#B\u001f\u0002\u0016\u0005e\u0011bAA\f\u0013\n\u00191+Z9\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005\u0011am\u001d\u0006\u0004\u0003Gy\u0012A\u00025bI>|\u0007/\u0003\u0003\u0002(\u0005u!A\u0003$jY\u0016\u001cF/\u0019;vg\u0006a\u0001O]3qCJ,wK]5uKRQ\u0011QFA\u001a\u0003k\t)%!\u0013\u0011\u00075\ny#C\u0002\u00022]\u00111cT;uaV$xK]5uKJ4\u0015m\u0019;pefDQ!^\u0005A\u0002YDq!a\u000e\n\u0001\u0004\tI$A\u0002k_\n\u0004B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t#A\u0005nCB\u0014X\rZ;dK&!\u00111IA\u001f\u0005\rQuN\u0019\u0005\u0007\u0003\u000fJ\u0001\u0019\u0001?\u0002\u000f=\u0004H/[8og\"1\u00111J\u0005A\u00029\f!\u0002Z1uCN\u001b\u0007.Z7b\u0003y\u0011W/\u001b7e%\u0016\fG-\u001a:XSRD\u0007+\u0019:uSRLwN\u001c,bYV,7\u000f\u0006\t\u0002R\u0005=\u0014\u0011OA:\u0003o\nY(a\"\u0002\nB9Q*a\u0015\u0002X\u0005u\u0013bAA+\r\nIa)\u001e8di&|g.\r\t\u0004[\u0005e\u0013bAA./\ty\u0001+\u0019:uSRLwN\\3e\r&dW\rE\u0003>\u0003?\n\u0019'C\u0002\u0002b%\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0005\u0003K\nY'\u0004\u0002\u0002h)\u0019\u0011\u0011N\u000e\u0002\u0011\r\fG/\u00197zgRLA!!\u001c\u0002h\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0015)(\u00021\u0001w\u0011\u0019\tYE\u0003a\u0001]\"1\u0011Q\u000f\u0006A\u00029\fq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\u0007\u0003sR\u0001\u0019\u00018\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\"9\u0011Q\u0010\u0006A\u0002\u0005}\u0014a\u00024jYR,'o\u001d\t\u0006{\u0005U\u0011\u0011\u0011\t\u0004c\u0005\r\u0015bAACe\t1a)\u001b7uKJDa!a\u0012\u000b\u0001\u0004a\bbBAF\u0015\u0001\u0007\u0011QR\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003BAH\u0003+k!!!%\u000b\t\u0005M\u0015\u0011E\u0001\u0005G>tg-\u0003\u0003\u0002\u0018\u0006E%!D\"p]\u001aLw-\u001e:bi&|g.A\btkB\u0004xN\u001d;ECR\fG+\u001f9f)\rY\u0016Q\u0014\u0005\b\u0003?[\u0001\u0019AAQ\u0003!!\u0017\r^1UsB,\u0007cA8\u0002$&\u0019\u0011Q\u00159\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAb];qa>\u0014HOQ1uG\"$RaWAV\u0003[CQ!\u001e\u0007A\u0002YDa!a,\r\u0001\u0004q\u0017AB:dQ\u0016l\u0017-\u0001\u000bHK>\u0004\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003M9\u0019bADA\\m\u0005u\u0006cA'\u0002:&\u0019\u00111\u0018$\u0003\r\u0005s\u0017PU3g!\u0011\ty,!3\u000e\u0005\u0005\u0005'\u0002BAb\u0003\u000b\f!![8\u000b\u0005\u0005\u001d\u0017\u0001\u00026bm\u0006L1\u0001SAa)\t\t\u0019,\u0001\fnKJ<WmU2iK6\f7/\u00138QCJ\fG\u000e\\3m)\u001di\u0017\u0011[Aj\u0003/DQa\u001f\tA\u0002qDq!!6\u0011\u0001\u0004\t\u0019\"\u0001\u0007gS2,7\u000fV8U_V\u001c\u0007\u000eC\u0003v!\u0001\u0007a/\u0001\u000bsK\u0006$7k\u00195f[\u00064%o\\7G_>$XM\u001d\u000b\u0006]\u0006u\u0017Q\u001e\u0005\b\u0003?\f\u0002\u0019AAq\u0003\u00191wn\u001c;feB!\u00111]Au\u001b\t\t)O\u0003\u0003\u0002$\u0005\u001d(B\u0001\f \u0013\u0011\tY/!:\u0003\r\u0019{w\u000e^3s\u0011\u001d\ty/\u0005a\u0001\u0003c\f\u0011bY8om\u0016\u0014H/\u001a:\u0011\u0007\u0019\n\u00190C\u0002\u0002vV\u0011\u0001eR3p!\u0006\u0014\u0018/^3u)>\u001c\u0006/\u0019:l'\u000eDW-\\1D_:4XM\u001d;fe\u00069B-Z:fe&\fG.\u001b>f'\u000eDW-\\1TiJLgn\u001a\u000b\u0004[\u0006m\bbBA\u007f%\u0001\u0007\u0011\u0011B\u0001\rg\u000eDW-\\1TiJLgnZ\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u0007\u0001BA!\u0002\u0003\f5\u0011!q\u0001\u0006\u0005\u0005\u0013\t)-\u0001\u0003mC:<\u0017\u0002\u0002B\u0007\u0005\u000f\u0011aa\u00142kK\u000e$\b")
public class GeoParquetFileFormat
extends ParquetFileFormat
implements GeoParquetFileFormatBase {
    private final Option<GeoParquetSpatialFilter> spatialFilter;

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        return GeoParquetFileFormat$.MODULE$.mergeSchemasInParallel(parameters, filesToTouch, sparkSession);
    }

    public String shortName() {
        return GeoParquetFileFormatBase.shortName$((GeoParquetFileFormatBase)this);
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof GeoParquetFileFormat)) return false;
        Option<GeoParquetSpatialFilter> option = ((GeoParquetFileFormat)((Object)other)).spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = this.spatialFilter();
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public GeoParquetFileFormat withSpatialPredicates(GeoParquetSpatialFilter spatialFilter) {
        return new GeoParquetFileFormat((Option<GeoParquetSpatialFilter>)new Some((Object)spatialFilter));
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return GeoParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), Boolean.toString(sparkSession.sessionState().conf().writeLegacyParquetFormat()));
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sparkSession.sessionState().conf().parquetOutputTimestampType().toString());
        try {
            String fieldIdWriteEnabled = SQLConf$.MODULE$.get().getConfString("spark.sql.parquet.fieldId.write.enabled");
            conf.set("spark.sql.parquet.fieldId.write.enabled", fieldIdWriteEnabled);
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").toString()).append(" create job summaries. ").append(new StringBuilder(58).append("Set Parquet option ").append("parquet.summary.metadata.level").append(" to NONE.").toString()).toString());
        }
        conf.set("parquet.write.support.class", GeoParquetWriteSupport.class.getName());
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
        };
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        ParquetWriteSupport$.MODULE$.setSchema(requiredSchema, hadoopConf);
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), (Object)requiredSchema.fields(), ClassTag$.MODULE$.apply(StructField.class)));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$1)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        int capacity = sqlConf.parquetVectorizedReaderBatchSize();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean returningBatch = this.supportBatch(sparkSession, resultSchema);
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean pushDownStringStartWith = sqlConf.parquetFilterPushDownStringStartWith();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        return (Function1 & Serializable)file -> {
            Iterator iterator;
            None$ none$;
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = new Path(new URI(file.filePath()));
            ParquetInputSplit split = new ParquetInputSplit(filePath, file.start(), file.start() + file.length(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), null);
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            FileMetaData footerFileMetaData = ParquetFileReader.readFooter((Configuration)sharedConf, (Path)filePath, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData();
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = footerFileMetaData.getSchema();
                GeoParquetFilters parquetFilters = new GeoParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringStartWith, pushDownInFilterThreshold, isCaseSensitive);
                none$ = ((IterableOnceOps)filters.flatMap((Function1 & Serializable)x$2 -> parquetFilters.createFilter((Filter)x$2))).reduceOption((Function2 & Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            boolean shouldScanFile = GeoParquetMetaData$.MODULE$.parseKeyValueMetaData(footerFileMetaData.getKeyValueMetaData()).forall((Function1 & Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$5(this, metadata)));
            if (!shouldScanFile) {
                iterator = package$.MODULE$.Seq().empty().iterator();
            } else {
                ParquetRecordReader parquetRecordReader;
                None$ convertTz = timestampConversion && !GeoParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
                Map map = footerFileMetaData.getKeyValueMetaData();
                Enumeration.Value datetimeRebaseMode = GeoDataSourceUtils$.MODULE$.datetimeRebaseMode((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map.get(x$1), SQLConf$.MODULE$.get().getConfString(GeoDataSourceUtils$.MODULE$.PARQUET_REBASE_MODE_IN_READ()));
                Map map2 = footerFileMetaData.getKeyValueMetaData();
                Enumeration.Value int96RebaseMode = GeoDataSourceUtils$.MODULE$.int96RebaseMode((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map2.get(x$1), SQLConf$.MODULE$.get().getConfString(GeoDataSourceUtils$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_READ()));
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
                if (pushed.isDefined()) {
                    ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
                }
                Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
                if (enableVectorizedReader) {
                    this.logWarning((Function0 & Serializable)() -> "GeoParquet currently does not support vectorized reader. Falling back to parquet-mr");
                }
                this.logDebug((Function0 & Serializable)() -> "Falling back to parquet-mr");
                GeoParquetReadSupport readSupport = new GeoParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseMode, int96RebaseMode);
                if (pushed.isDefined() && enableRecordFilter) {
                    FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
                } else {
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
                }
                ParquetRecordReader reader = parquetRecordReader;
                RecordReaderIterator iter = new RecordReaderIterator((RecordReader)reader);
                taskContext.foreach((Function1 & Serializable)x$4 -> x$4.addTaskCompletionListener((Function1 & Serializable)x$5 -> {
                    iter.close();
                    return BoxedUnit.UNIT;
                }));
                reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)requiredSchema.toAttributes().$plus$plus((IterableOnce)partitionSchema.toAttributes());
                UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                if (partitionSchema.length() == 0) {
                    iterator = iter.map((Function1)unsafeProjection);
                } else {
                    JoinedRow joinedRow = new JoinedRow();
                    iterator = iter.map((Function1 & Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                }
            }
            return iterator;
        };
    }

    public boolean supportDataType(DataType dataType) {
        return super.supportDataType(dataType);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$5(GeoParquetFileFormat $this, GeoParquetMetaData metadata) {
        return $this.spatialFilter().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.evaluate(metadata.columns())));
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public GeoParquetFileFormat(Option<GeoParquetSpatialFilter> spatialFilter) {
        this.spatialFilter = spatialFilter;
        GeoParquetFileFormatBase.$init$((GeoParquetFileFormatBase)this);
    }

    public GeoParquetFileFormat() {
        this((Option<GeoParquetSpatialFilter>)None$.MODULE$);
    }
}

