/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.sedona.core.formatMapper.netcdfParser.SerNetCDFUtils;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import ucar.ma2.Array;
import ucar.nc2.dataset.NetcdfDataset;

public class EarthdataHDFPointMapper
implements FlatMapFunction<Iterator<String>, Geometry> {
    private final String geolocationField = "Geolocation_Fields";
    private final String longitudeName = "Longitude";
    private final String latitudeName = "Latitude";
    private final String dataFieldName = "Data_Fields";
    private final String[] dataVariableList;
    private final String[] dataPathList;
    private int offset = 0;
    private int increment = 1;
    private String rootGroupName = "MOD_Swath_LST";
    private String dataVariableName = "LST";
    private String longitudePath = "";
    private String latitudePath = "";
    private String dataPath = "";
    private boolean switchCoordinateXY = false;
    private String urlPrefix = "";

    public EarthdataHDFPointMapper(int offset, int increment, String rootGroupName, String[] dataVariableList, String dataVariableName, boolean switchCoordinateXY) {
        this.offset = offset;
        this.increment = increment;
        this.rootGroupName = rootGroupName;
        this.dataVariableList = dataVariableList;
        this.dataVariableName = dataVariableName;
        this.longitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.longitudeName;
        this.latitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.latitudeName;
        this.dataPath = this.rootGroupName + "/" + this.dataFieldName + "/" + this.dataVariableName;
        this.dataPathList = new String[dataVariableList.length];
        for (int i = 0; i < dataVariableList.length; ++i) {
            this.dataPathList[i] = this.rootGroupName + "/" + this.dataFieldName + "/" + dataVariableList[i];
        }
        this.switchCoordinateXY = switchCoordinateXY;
    }

    public EarthdataHDFPointMapper(int offset, int increment, String rootGroupName, String[] dataVariableList, String dataVariableName) {
        this.offset = offset;
        this.increment = increment;
        this.rootGroupName = rootGroupName;
        this.dataVariableList = dataVariableList;
        this.dataVariableName = dataVariableName;
        this.longitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.longitudeName;
        this.latitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.latitudeName;
        this.dataPath = this.rootGroupName + "/" + this.dataFieldName + "/" + this.dataVariableName;
        this.dataPathList = new String[dataVariableList.length];
        for (int i = 0; i < dataVariableList.length; ++i) {
            this.dataPathList[i] = this.rootGroupName + "/" + this.dataFieldName + "/" + dataVariableList[i];
        }
    }

    public EarthdataHDFPointMapper(int offset, int increment, String rootGroupName, String[] dataVariableList, String dataVariableName, boolean switchCoordinateXY, String urlPrefix) {
        this.offset = offset;
        this.increment = increment;
        this.rootGroupName = rootGroupName;
        this.dataVariableList = dataVariableList;
        this.dataVariableName = dataVariableName;
        this.longitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.longitudeName;
        this.latitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.latitudeName;
        this.dataPath = this.rootGroupName + "/" + this.dataFieldName + "/" + this.dataVariableName;
        this.dataPathList = new String[dataVariableList.length];
        for (int i = 0; i < dataVariableList.length; ++i) {
            this.dataPathList[i] = this.rootGroupName + "/" + this.dataFieldName + "/" + dataVariableList[i];
        }
        this.switchCoordinateXY = switchCoordinateXY;
        this.urlPrefix = urlPrefix;
    }

    public EarthdataHDFPointMapper(int offset, int increment, String rootGroupName, String[] dataVariableList, String dataVariableName, String urlPrefix) {
        this.offset = offset;
        this.increment = increment;
        this.rootGroupName = rootGroupName;
        this.dataVariableList = dataVariableList;
        this.dataVariableName = dataVariableName;
        this.longitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.longitudeName;
        this.latitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.latitudeName;
        this.dataPath = this.rootGroupName + "/" + this.dataFieldName + "/" + this.dataVariableName;
        this.dataPathList = new String[dataVariableList.length];
        for (int i = 0; i < dataVariableList.length; ++i) {
            this.dataPathList[i] = this.rootGroupName + "/" + this.dataFieldName + "/" + dataVariableList[i];
        }
        this.urlPrefix = urlPrefix;
    }

    public Iterator<Geometry> call(Iterator<String> stringIterator) throws Exception {
        ArrayList<Point> hdfData = new ArrayList<Point>();
        while (stringIterator.hasNext()) {
            String hdfAddress = stringIterator.next();
            NetcdfDataset netcdfSet = SerNetCDFUtils.loadNetCDFDataSet(this.urlPrefix + hdfAddress);
            Array longitudeArray = SerNetCDFUtils.getNetCDF2DArray(netcdfSet, this.longitudePath);
            Array latitudeArray = SerNetCDFUtils.getNetCDF2DArray(netcdfSet, this.latitudePath);
            Array dataArray = SerNetCDFUtils.getNetCDF2DArray(netcdfSet, this.dataPath);
            Array[] dataArrayList = new Array[this.dataVariableList.length];
            for (int i = 0; i < this.dataVariableList.length; ++i) {
                dataArrayList[i] = SerNetCDFUtils.getNetCDF2DArray(netcdfSet, this.dataPathList[i]);
            }
            int[] geolocationShape = longitudeArray.getShape();
            GeometryFactory geometryFactory = new GeometryFactory();
            for (int j = 0; j < geolocationShape[0]; ++j) {
                for (int i = 0; i < geolocationShape[1]; ++i) {
                    Coordinate coordinate = null;
                    coordinate = this.switchCoordinateXY ? new Coordinate(SerNetCDFUtils.getDataSym(longitudeArray, j, i).doubleValue(), SerNetCDFUtils.getDataSym(latitudeArray, j, i).doubleValue(), SerNetCDFUtils.getDataAsym(dataArray, j, i, this.offset, this.increment).doubleValue()) : new Coordinate(SerNetCDFUtils.getDataSym(latitudeArray, j, i).doubleValue(), SerNetCDFUtils.getDataSym(longitudeArray, j, i).doubleValue(), SerNetCDFUtils.getDataAsym(dataArray, j, i, this.offset, this.increment).doubleValue());
                    Point observation = geometryFactory.createPoint(coordinate);
                    String userData = "";
                    for (int k = 0; k < this.dataVariableList.length - 1; ++k) {
                        userData = userData + SerNetCDFUtils.getDataAsym(dataArrayList[k], j, i, this.offset, this.increment) + " ";
                    }
                    userData = userData + SerNetCDFUtils.getDataAsym(dataArrayList[this.dataVariableList.length - 1], j, i, this.offset, this.increment);
                    observation.setUserData((Object)userData);
                    hdfData.add(observation);
                }
            }
        }
        return hdfData.iterator();
    }
}

