/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.viz.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.sedona.viz.utils.ColorizeOption;
import org.apache.sedona.viz.utils.Pixel;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Tuple2;

public class RasterizationUtils
implements Serializable {
    static final Logger logger = Logger.getLogger(RasterizationUtils.class);

    public static Tuple2<Integer, Integer> FindOnePixelCoordinate(int resolutionX, int resolutionY, Envelope datasetBoundaryOriginal, Coordinate spatialCoordinateOriginal, boolean reverseSpatialCoordinate) {
        Envelope datasetBoundary;
        Coordinate spatialCoordinate;
        if (reverseSpatialCoordinate) {
            spatialCoordinate = new Coordinate(spatialCoordinateOriginal.y, spatialCoordinateOriginal.x);
            datasetBoundary = new Envelope(datasetBoundaryOriginal.getMinY(), datasetBoundaryOriginal.getMaxY(), datasetBoundaryOriginal.getMinX(), datasetBoundaryOriginal.getMaxX());
        } else {
            spatialCoordinate = spatialCoordinateOriginal;
            datasetBoundary = datasetBoundaryOriginal;
        }
        Double pixelXDouble = (spatialCoordinate.x - datasetBoundary.getMinX()) / (datasetBoundary.getMaxX() - datasetBoundary.getMinX()) * (double)resolutionX;
        Double xRemainder = (spatialCoordinate.x - datasetBoundary.getMinX()) % (datasetBoundary.getMaxX() - datasetBoundary.getMinX());
        Double pixelYDouble = (spatialCoordinate.y - datasetBoundary.getMinY()) / (datasetBoundary.getMaxY() - datasetBoundary.getMinY()) * (double)resolutionY;
        Double yRemainder = (spatialCoordinate.y - datasetBoundary.getMinY()) % (datasetBoundary.getMaxY() - datasetBoundary.getMinY());
        int pixelX = pixelXDouble.intValue();
        int pixelY = pixelYDouble.intValue();
        if (xRemainder == 0.0 && pixelXDouble != 0.0) {
            --pixelX;
        }
        if (pixelX >= resolutionX) {
            --pixelX;
        }
        if (yRemainder == 0.0 && pixelYDouble != 0.0) {
            --pixelY;
        }
        if (pixelY >= resolutionY) {
            --pixelY;
        }
        return new Tuple2((Object)pixelX, (Object)pixelY);
    }

    public static Tuple2<Integer, Integer> FindOnePixelCoordinate(int resolutionX, int resolutionY, Envelope datasetBoundaryOriginal, Coordinate spatialCoordinateOriginal, boolean reverseSpatialCoordinate, boolean flipOverX, boolean flipOverY) {
        Envelope datasetBoundary;
        Coordinate spatialCoordinate;
        if (reverseSpatialCoordinate) {
            spatialCoordinate = new Coordinate(spatialCoordinateOriginal.y, spatialCoordinateOriginal.x);
            datasetBoundary = new Envelope(datasetBoundaryOriginal.getMinY(), datasetBoundaryOriginal.getMaxY(), datasetBoundaryOriginal.getMinX(), datasetBoundaryOriginal.getMaxX());
        } else {
            spatialCoordinate = spatialCoordinateOriginal;
            datasetBoundary = datasetBoundaryOriginal;
        }
        Double pixelXDouble = (spatialCoordinate.x - datasetBoundary.getMinX()) / (datasetBoundary.getMaxX() - datasetBoundary.getMinX()) * (double)resolutionX;
        Double xRemainder = (spatialCoordinate.x - datasetBoundary.getMinX()) % (datasetBoundary.getMaxX() - datasetBoundary.getMinX());
        Double pixelYDouble = (spatialCoordinate.y - datasetBoundary.getMinY()) / (datasetBoundary.getMaxY() - datasetBoundary.getMinY()) * (double)resolutionY;
        Double yRemainder = (spatialCoordinate.y - datasetBoundary.getMinY()) / (datasetBoundary.getMaxY() - datasetBoundary.getMinY());
        int pixelX = pixelXDouble.intValue();
        int pixelY = pixelYDouble.intValue();
        if (xRemainder == 0.0 && pixelXDouble != 0.0) {
            --pixelX;
        }
        if (pixelX >= resolutionX) {
            --pixelX;
        }
        if (yRemainder == 0.0 && pixelYDouble != 0.0) {
            --pixelY;
        }
        if (pixelY >= resolutionY) {
            --pixelY;
        }
        if (flipOverX) {
            pixelX = resolutionX - pixelX;
        }
        if (flipOverY) {
            pixelY = resolutionY - pixelY;
        }
        return new Tuple2((Object)pixelX, (Object)pixelY);
    }

    public static int GetWidthFromHeight(int y, Envelope boundary) {
        int x = (int)((double)y * (boundary.getWidth() / boundary.getHeight()));
        return x;
    }

    public static int Encode2DTo1DId(int resolutionX, int resolutionY, int twoDimensionIdX, int twoDimensionIdY) throws Exception {
        if (twoDimensionIdX < 0 || twoDimensionIdX >= resolutionX || twoDimensionIdY < 0 || twoDimensionIdY >= resolutionY) {
            throw new Exception("[RasterizationUtils][Encode2DTo1DId] This given 2 dimension coordinate is " + twoDimensionIdX + " " + twoDimensionIdY + ". This coordinate is out of the given boundary and will be dropped.");
        }
        return twoDimensionIdX + twoDimensionIdY * resolutionX;
    }

    public static Tuple2<Integer, Integer> Decode1DTo2DId(int resolutionX, int resolutionY, int oneDimensionId) {
        int twoDimensionIdX = oneDimensionId % resolutionX;
        int twoDimensionIdY = oneDimensionId / resolutionX;
        return new Tuple2((Object)twoDimensionIdX, (Object)twoDimensionIdY);
    }

    public static List<Tuple2<Pixel, Double>> FindPixelCoordinates(int resolutionX, int resolutionY, Envelope datasetBoundary, Point spatialObject, ColorizeOption colorizeOption, boolean reverseSpatialCoordinate) {
        ArrayList<Tuple2<Pixel, Double>> result2 = new ArrayList<Tuple2<Pixel, Double>>();
        Tuple2<Integer, Integer> pixelCoordinate = null;
        try {
            pixelCoordinate = RasterizationUtils.FindOnePixelCoordinate(resolutionX, resolutionY, datasetBoundary, spatialObject.getCoordinate(), reverseSpatialCoordinate);
        }
        catch (Exception e) {
            return result2;
        }
        if (colorizeOption == ColorizeOption.EARTHOBSERVATION) {
            Pixel newPixel = new Pixel(((Integer)pixelCoordinate._1).intValue(), ((Integer)pixelCoordinate._2).intValue(), resolutionX, resolutionY);
            result2.add((Tuple2<Pixel, Double>)new Tuple2((Object)newPixel, (Object)spatialObject.getCoordinate().z));
        } else {
            Pixel newPixel = new Pixel(((Integer)pixelCoordinate._1).intValue(), ((Integer)pixelCoordinate._2).intValue(), resolutionX, resolutionY);
            result2.add((Tuple2<Pixel, Double>)new Tuple2((Object)newPixel, (Object)new Double(1.0)));
        }
        return result2;
    }

    public static Coordinate[] FindPixelCoordinates(int resolutionX, int resolutionY, Envelope datasetBoundary, Coordinate[] coordinates, boolean reverseSpatialCoordinate, boolean flipOverX, boolean flipOverY) {
        ArrayList<Coordinate> result2 = new ArrayList<Coordinate>();
        for (Coordinate coordinate : coordinates) {
            Tuple2<Integer, Integer> pixelCoordinate = RasterizationUtils.FindOnePixelCoordinate(resolutionX, resolutionY, datasetBoundary, coordinate, reverseSpatialCoordinate, flipOverX, flipOverY);
            result2.add(new Coordinate((double)((Integer)pixelCoordinate._1()).intValue(), (double)((Integer)pixelCoordinate._2()).intValue()));
        }
        Coordinate[] arrayResult = result2.toArray(new Coordinate[result2.size()]);
        return arrayResult;
    }

    public static Coordinate FindPixelCoordinates(int resolutionX, int resolutionY, Envelope datasetBoundary, Coordinate coordinate, boolean reverseSpatialCoordinate, boolean flipOverX, boolean flipOverY) {
        Tuple2<Integer, Integer> pixelCoordinate = RasterizationUtils.FindOnePixelCoordinate(resolutionX, resolutionY, datasetBoundary, coordinate, reverseSpatialCoordinate, flipOverX, flipOverY);
        return new Coordinate((double)((Integer)pixelCoordinate._1()).intValue(), (double)((Integer)pixelCoordinate._2()).intValue());
    }

    public static List<Tuple2<Pixel, Double>> FindPixelCoordinates(int resolutionX, int resolutionY, Envelope datasetBoundary, Polygon spatialObject, boolean reverseSpatialCoordinate) {
        ArrayList<Tuple2<Pixel, Double>> result2 = new ArrayList<Tuple2<Pixel, Double>>();
        for (int i = 0; i < spatialObject.getCoordinates().length - 1; ++i) {
            Tuple2<Integer, Integer> pixelCoordinate1 = null;
            Tuple2<Integer, Integer> pixelCoordinate2 = null;
            try {
                pixelCoordinate1 = RasterizationUtils.FindOnePixelCoordinate(resolutionX, resolutionY, datasetBoundary, spatialObject.getCoordinates()[i], reverseSpatialCoordinate);
                pixelCoordinate2 = RasterizationUtils.FindOnePixelCoordinate(resolutionX, resolutionY, datasetBoundary, spatialObject.getCoordinates()[i + 1], reverseSpatialCoordinate);
            }
            catch (Exception e) {
                continue;
            }
            result2.addAll(RasterizationUtils.FindPixelCoordinates(resolutionX, resolutionY, pixelCoordinate1, pixelCoordinate2, reverseSpatialCoordinate));
        }
        return result2;
    }

    public static List<Tuple2<Pixel, Double>> FindPixelCoordinates(int resolutionX, int resolutionY, Envelope datasetBoundary, Polygon spatialObject, boolean reverseSpatialCoordinate, Double objectWeight) {
        ArrayList<Tuple2<Pixel, Double>> result2 = new ArrayList<Tuple2<Pixel, Double>>();
        GeometryFactory geometryfactory = new GeometryFactory();
        ArrayList<Object> coordinatesList = new ArrayList<Object>();
        for (int i = 0; i < spatialObject.getCoordinates().length; ++i) {
            Tuple2<Integer, Integer> pixelCoordinate = null;
            pixelCoordinate = RasterizationUtils.FindOnePixelCoordinate(resolutionX, resolutionY, datasetBoundary, spatialObject.getCoordinates()[i], reverseSpatialCoordinate);
            coordinatesList.add(new Coordinate((double)((Integer)pixelCoordinate._1).intValue(), (double)((Integer)pixelCoordinate._2).intValue()));
        }
        coordinatesList.add(coordinatesList.get(0));
        LinearRing linear = geometryfactory.createLinearRing(coordinatesList.toArray(new Coordinate[coordinatesList.size()]));
        Polygon polygon = new Polygon(linear, null, geometryfactory);
        int minPixelX = (int)polygon.getEnvelopeInternal().getMinX();
        int maxPixelX = (int)polygon.getEnvelopeInternal().getMaxX();
        int minPixelY = (int)polygon.getEnvelopeInternal().getMinY();
        int maxPixelY = (int)polygon.getEnvelopeInternal().getMaxY();
        for (int j = minPixelY; j <= maxPixelY; ++j) {
            for (int i = minPixelX; i <= maxPixelX; ++i) {
                if (!polygon.contains((Geometry)geometryfactory.createPoint(new Coordinate((double)i, (double)j)))) continue;
                try {
                    Pixel newPixel = new Pixel(i, j, resolutionX, resolutionY);
                    result2.add((Tuple2<Pixel, Double>)new Tuple2((Object)newPixel, (Object)new Double(objectWeight)));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result2;
    }

    public static List<Tuple2<Pixel, Double>> FindPixelCoordinates(int resolutionX, int resolutionY, Tuple2<Integer, Integer> pixelCoordinate1, Tuple2<Integer, Integer> pixelCoordinate2, boolean reverseSpatialCoordinate) {
        int x1 = (Integer)pixelCoordinate1._1;
        int y1 = (Integer)pixelCoordinate1._2;
        int x2 = (Integer)pixelCoordinate2._1;
        int y2 = (Integer)pixelCoordinate2._2;
        int dx = x2 - x1;
        int dy = y2 - y1;
        int ux = dx > 0 ? 1 : -1;
        int uy = dy > 0 ? 1 : -1;
        int x = x1;
        int y = y1;
        int eps = 0;
        dx = Math.abs(dx);
        dy = Math.abs(dy);
        ArrayList<Tuple2<Pixel, Double>> result2 = new ArrayList<Tuple2<Pixel, Double>>();
        if (dx > dy) {
            for (x = x1; x != x2; x += ux) {
                try {
                    Pixel newPixel = new Pixel(x, y, resolutionX, resolutionY);
                    result2.add((Tuple2<Pixel, Double>)new Tuple2((Object)newPixel, (Object)1.0));
                }
                catch (Exception newPixel) {
                    // empty catch block
                }
                if ((eps += dy) << 1 < dx) continue;
                y += uy;
                eps -= dx;
            }
        } else {
            for (y = y1; y != y2; y += uy) {
                try {
                    Pixel newPixel = new Pixel(x, y, resolutionX, resolutionY);
                    result2.add((Tuple2<Pixel, Double>)new Tuple2((Object)newPixel, (Object)1.0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((eps += dx) << 1 < dy) continue;
                x += ux;
                eps -= dy;
            }
        }
        return result2;
    }

    public static List<Tuple2<Pixel, Double>> FindPixelCoordinates(int resolutionX, int resolutionY, Envelope datasetBoundary, LineString spatialObject, boolean reverseSpatialCoordinate) {
        ArrayList<Tuple2<Pixel, Double>> result2 = new ArrayList<Tuple2<Pixel, Double>>();
        for (int i = 0; i < spatialObject.getCoordinates().length - 1; ++i) {
            Tuple2<Integer, Integer> pixelCoordinate1 = null;
            Tuple2<Integer, Integer> pixelCoordinate2 = null;
            try {
                pixelCoordinate1 = RasterizationUtils.FindOnePixelCoordinate(resolutionX, resolutionY, datasetBoundary, spatialObject.getCoordinates()[i], reverseSpatialCoordinate);
                pixelCoordinate2 = RasterizationUtils.FindOnePixelCoordinate(resolutionX, resolutionY, datasetBoundary, spatialObject.getCoordinates()[i + 1], reverseSpatialCoordinate);
            }
            catch (Exception e) {
                continue;
            }
            result2.addAll(RasterizationUtils.FindPixelCoordinates(resolutionX, resolutionY, pixelCoordinate1, pixelCoordinate2, reverseSpatialCoordinate));
        }
        return result2;
    }

    public static String getImageTileName(int zoomLevel, int partitionOnX, int partitionOnY, int tileSerialId) {
        Tuple2<Integer, Integer> tileCoordinate = RasterizationUtils.Decode1DTo2DId(partitionOnX, partitionOnY, tileSerialId);
        return zoomLevel + "-" + tileCoordinate._1() + "-" + tileCoordinate._2();
    }
}

