/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.flink;

import com.esotericsoftware.kryo.Serializer;
import java.util.Arrays;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.sedona.core.geometryObjects.Circle;
import org.apache.sedona.core.geometryObjects.GeometrySerde;
import org.apache.sedona.core.geometryObjects.SpatialIndexSerde;
import org.apache.sedona.flink.Catalog;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.index.strtree.STRtree;

public class SedonaFlinkRegistrator {
    public static void registerFunc(StreamTableEnvironment tblEnv) {
        Arrays.stream(Catalog.getFuncs()).forEach(func -> tblEnv.createTemporarySystemFunction(func.getClass().getSimpleName(), func));
        Arrays.stream(Catalog.getPredicates()).forEach(func -> tblEnv.createTemporarySystemFunction(func.getClass().getSimpleName(), func));
    }

    public static void registerType(StreamExecutionEnvironment env) {
        GeometrySerde serializer = new GeometrySerde();
        SpatialIndexSerde indexSerializer = new SpatialIndexSerde(serializer);
        env.getConfig().registerTypeWithKryoSerializer(Point.class, (Serializer)serializer);
        env.getConfig().registerTypeWithKryoSerializer(LineString.class, (Serializer)serializer);
        env.getConfig().registerTypeWithKryoSerializer(Polygon.class, (Serializer)serializer);
        env.getConfig().registerTypeWithKryoSerializer(MultiPoint.class, (Serializer)serializer);
        env.getConfig().registerTypeWithKryoSerializer(MultiLineString.class, (Serializer)serializer);
        env.getConfig().registerTypeWithKryoSerializer(MultiPolygon.class, (Serializer)serializer);
        env.getConfig().registerTypeWithKryoSerializer(GeometryCollection.class, (Serializer)serializer);
        env.getConfig().registerTypeWithKryoSerializer(Circle.class, (Serializer)serializer);
        env.getConfig().registerTypeWithKryoSerializer(Envelope.class, (Serializer)serializer);
        env.getConfig().registerTypeWithKryoSerializer(Quadtree.class, (Serializer)indexSerializer);
        env.getConfig().registerTypeWithKryoSerializer(STRtree.class, (Serializer)indexSerializer);
    }
}

