/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.LinkedBuffer;
import io.protostuff.WriteSession;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;

public final class StringSerializer {
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final byte[] INT_MIN_VALUE = new byte[]{45, 50, 49, 52, 55, 52, 56, 51, 54, 52, 56};
    static final byte[] LONG_MIN_VALUE = new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56};
    static final int TWO_BYTE_LOWER_LIMIT = 128;
    static final int ONE_BYTE_EXCLUSIVE = 43;
    static final int THREE_BYTE_LOWER_LIMIT = 16384;
    static final int TWO_BYTE_EXCLUSIVE = 5462;
    static final int FOUR_BYTE_LOWER_LIMIT = 0x200000;
    static final int THREE_BYTE_EXCLUSIVE = 699051;
    static final int FIVE_BYTE_LOWER_LIMIT = 0x10000000;
    static final int FOUR_BYTE_EXCLUSIVE = 0x5555556;

    private StringSerializer() {
    }

    static void putBytesFromInt(int i, int offset, int size, byte[] buf) {
        int r;
        int q;
        int charPos = offset + size;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = (byte)DigitOnes[r];
            buf[--charPos] = (byte)DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = (byte)digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--charPos] = (byte)sign;
        }
    }

    static void putBytesFromLong(long i, int offset, int size, byte[] buf) {
        int q2;
        int r;
        int charPos = offset + size;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = (byte)DigitOnes[r];
            buf[--charPos] = (byte)DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = (byte)DigitOnes[r];
            buf[--charPos] = (byte)DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = (byte)digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = (byte)sign;
        }
    }

    static int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public static LinkedBuffer writeInt(int value, WriteSession session, LinkedBuffer lb) {
        int size;
        if (value == Integer.MIN_VALUE) {
            int valueLen = INT_MIN_VALUE.length;
            if (lb.offset + valueLen > lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            System.arraycopy(INT_MIN_VALUE, 0, lb.buffer, lb.offset, valueLen);
            lb.offset += valueLen;
            session.size += valueLen;
            return lb;
        }
        int n = size = value < 0 ? StringSerializer.stringSize(-value) + 1 : StringSerializer.stringSize(value);
        if (lb.offset + size > lb.buffer.length) {
            lb = new LinkedBuffer(session.nextBufferSize, lb);
        }
        StringSerializer.putBytesFromInt(value, lb.offset, size, lb.buffer);
        lb.offset += size;
        session.size += size;
        return lb;
    }

    public static LinkedBuffer writeLong(long value, WriteSession session, LinkedBuffer lb) {
        int size;
        if (value == Long.MIN_VALUE) {
            int valueLen = LONG_MIN_VALUE.length;
            if (lb.offset + valueLen > lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            System.arraycopy(LONG_MIN_VALUE, 0, lb.buffer, lb.offset, valueLen);
            lb.offset += valueLen;
            session.size += valueLen;
            return lb;
        }
        int n = size = value < 0L ? StringSerializer.stringSize(-value) + 1 : StringSerializer.stringSize(value);
        if (lb.offset + size > lb.buffer.length) {
            lb = new LinkedBuffer(session.nextBufferSize, lb);
        }
        StringSerializer.putBytesFromLong(value, lb.offset, size, lb.buffer);
        lb.offset += size;
        session.size += size;
        return lb;
    }

    public static LinkedBuffer writeFloat(float value, WriteSession session, LinkedBuffer lb) {
        return StringSerializer.writeAscii(Float.toString(value), session, lb);
    }

    public static LinkedBuffer writeDouble(double value, WriteSession session, LinkedBuffer lb) {
        return StringSerializer.writeAscii(Double.toString(value), session, lb);
    }

    public static int computeUTF8Size(CharSequence str, int index, int len) {
        int size = len;
        for (int i = index; i < len; ++i) {
            char c = str.charAt(i);
            if (c < '\u0080') continue;
            if (c < '\u0800') {
                ++size;
                continue;
            }
            size += 2;
        }
        return size;
    }

    static LinkedBuffer writeUTF8(CharSequence str, int i, int len, byte[] buffer, int offset, int limit, WriteSession session, LinkedBuffer lb) {
        char c = '\u0000';
        while (true) {
            if (i != len && offset != limit) {
                char c2 = str.charAt(i++);
                c = c2;
                if (c2 < '\u0080') {
                    buffer[offset++] = (byte)c;
                    continue;
                }
            }
            if (i == len && c < '\u0080') {
                session.size += offset - lb.offset;
                lb.offset = offset;
                return lb;
            }
            if (offset == limit) {
                session.size += offset - lb.offset;
                lb.offset = offset;
                if (lb.next == null) {
                    offset = 0;
                    limit = session.nextBufferSize;
                    buffer = new byte[limit];
                    lb = new LinkedBuffer(buffer, 0, lb);
                } else {
                    lb = lb.next;
                    lb.offset = offset = lb.start;
                    buffer = lb.buffer;
                    limit = buffer.length;
                }
            } else if (c < '\u0800') {
                if (offset == limit) {
                    session.size += offset - lb.offset;
                    lb.offset = offset;
                    if (lb.next == null) {
                        offset = 0;
                        limit = session.nextBufferSize;
                        buffer = new byte[limit];
                        lb = new LinkedBuffer(buffer, 0, lb);
                    } else {
                        lb = lb.next;
                        lb.offset = offset = lb.start;
                        buffer = lb.buffer;
                        limit = buffer.length;
                    }
                }
                buffer[offset++] = (byte)(0xC0 | c >> 6 & 0x1F);
                if (offset == limit) {
                    session.size += offset - lb.offset;
                    lb.offset = offset;
                    if (lb.next == null) {
                        offset = 0;
                        limit = session.nextBufferSize;
                        buffer = new byte[limit];
                        lb = new LinkedBuffer(buffer, 0, lb);
                    } else {
                        lb = lb.next;
                        lb.offset = offset = lb.start;
                        buffer = lb.buffer;
                        limit = buffer.length;
                    }
                }
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else if (Character.isHighSurrogate(c) && i < len && Character.isLowSurrogate(str.charAt(i))) {
                if (offset == limit) {
                    session.size += offset - lb.offset;
                    lb.offset = offset;
                    if (lb.next == null) {
                        offset = 0;
                        limit = session.nextBufferSize;
                        buffer = new byte[limit];
                        lb = new LinkedBuffer(buffer, 0, lb);
                    } else {
                        lb = lb.next;
                        lb.offset = offset = lb.start;
                        buffer = lb.buffer;
                        limit = buffer.length;
                    }
                }
                int codePoint = Character.toCodePoint(c, str.charAt(i));
                buffer[offset++] = (byte)(0xF0 | codePoint >> 18 & 7);
                if (offset == limit) {
                    session.size += offset - lb.offset;
                    lb.offset = offset;
                    if (lb.next == null) {
                        offset = 0;
                        limit = session.nextBufferSize;
                        buffer = new byte[limit];
                        lb = new LinkedBuffer(buffer, 0, lb);
                    } else {
                        lb = lb.next;
                        lb.offset = offset = lb.start;
                        buffer = lb.buffer;
                        limit = buffer.length;
                    }
                }
                buffer[offset++] = (byte)(0x80 | codePoint >> 12 & 0x3F);
                if (offset == limit) {
                    session.size += offset - lb.offset;
                    lb.offset = offset;
                    if (lb.next == null) {
                        offset = 0;
                        limit = session.nextBufferSize;
                        buffer = new byte[limit];
                        lb = new LinkedBuffer(buffer, 0, lb);
                    } else {
                        lb = lb.next;
                        lb.offset = offset = lb.start;
                        buffer = lb.buffer;
                        limit = buffer.length;
                    }
                }
                buffer[offset++] = (byte)(0x80 | codePoint >> 6 & 0x3F);
                if (offset == limit) {
                    session.size += offset - lb.offset;
                    lb.offset = offset;
                    if (lb.next == null) {
                        offset = 0;
                        limit = session.nextBufferSize;
                        buffer = new byte[limit];
                        lb = new LinkedBuffer(buffer, 0, lb);
                    } else {
                        lb = lb.next;
                        lb.offset = offset = lb.start;
                        buffer = lb.buffer;
                        limit = buffer.length;
                    }
                }
                buffer[offset++] = (byte)(0x80 | codePoint >> 0 & 0x3F);
                ++i;
            } else {
                if (offset == limit) {
                    session.size += offset - lb.offset;
                    lb.offset = offset;
                    if (lb.next == null) {
                        offset = 0;
                        limit = session.nextBufferSize;
                        buffer = new byte[limit];
                        lb = new LinkedBuffer(buffer, 0, lb);
                    } else {
                        lb = lb.next;
                        lb.offset = offset = lb.start;
                        buffer = lb.buffer;
                        limit = buffer.length;
                    }
                }
                buffer[offset++] = (byte)(0xE0 | c >> 12 & 0xF);
                if (offset == limit) {
                    session.size += offset - lb.offset;
                    lb.offset = offset;
                    if (lb.next == null) {
                        offset = 0;
                        limit = session.nextBufferSize;
                        buffer = new byte[limit];
                        lb = new LinkedBuffer(buffer, 0, lb);
                    } else {
                        lb = lb.next;
                        lb.offset = offset = lb.start;
                        buffer = lb.buffer;
                        limit = buffer.length;
                    }
                }
                buffer[offset++] = (byte)(0x80 | c >> 6 & 0x3F);
                if (offset == limit) {
                    session.size += offset - lb.offset;
                    lb.offset = offset;
                    if (lb.next == null) {
                        offset = 0;
                        limit = session.nextBufferSize;
                        buffer = new byte[limit];
                        lb = new LinkedBuffer(buffer, 0, lb);
                    } else {
                        lb = lb.next;
                        lb.offset = offset = lb.start;
                        buffer = lb.buffer;
                        limit = buffer.length;
                    }
                }
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            c = '\u0000';
        }
    }

    static LinkedBuffer writeUTF8(CharSequence str, int i, int len, WriteSession session, LinkedBuffer lb) {
        byte[] buffer = lb.buffer;
        char c = '\u0000';
        int offset = lb.offset;
        int adjustableLimit = offset + len;
        while (true) {
            if (i != len && (c = str.charAt(i++)) < '\u0080') {
                buffer[offset++] = (byte)c;
                continue;
            }
            if (i == len && c < '\u0080') {
                session.size += offset - lb.offset;
                lb.offset = offset;
                return lb;
            }
            if (c < '\u0800') {
                if (++adjustableLimit > buffer.length) {
                    session.size += offset - lb.offset;
                    lb.offset = offset;
                    return StringSerializer.writeUTF8(str, i - 1, len, buffer, offset, buffer.length, session, lb);
                }
                buffer[offset++] = (byte)(0xC0 | c >> 6 & 0x1F);
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else if (Character.isHighSurrogate(c) && i < len && Character.isLowSurrogate(str.charAt(i))) {
                if ((adjustableLimit += 3) > buffer.length) {
                    session.size += offset - lb.offset;
                    lb.offset = offset;
                    return StringSerializer.writeUTF8(str, i - 1, len, buffer, offset, buffer.length, session, lb);
                }
                int codePoint = Character.toCodePoint(c, str.charAt(i));
                buffer[offset++] = (byte)(0xF0 | codePoint >> 18 & 7);
                buffer[offset++] = (byte)(0x80 | codePoint >> 12 & 0x3F);
                buffer[offset++] = (byte)(0x80 | codePoint >> 6 & 0x3F);
                buffer[offset++] = (byte)(0x80 | codePoint >> 0 & 0x3F);
                ++i;
            } else {
                if ((adjustableLimit += 2) > buffer.length) {
                    session.size += offset - lb.offset;
                    lb.offset = offset;
                    return StringSerializer.writeUTF8(str, i - 1, len, buffer, offset, buffer.length, session, lb);
                }
                buffer[offset++] = (byte)(0xE0 | c >> 12 & 0xF);
                buffer[offset++] = (byte)(0x80 | c >> 6 & 0x3F);
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            c = '\u0000';
        }
    }

    public static LinkedBuffer writeUTF8(CharSequence str, WriteSession session, LinkedBuffer lb) {
        int len = str.length();
        if (len == 0) {
            return lb;
        }
        return lb.offset + len > lb.buffer.length ? StringSerializer.writeUTF8(str, 0, len, lb.buffer, lb.offset, lb.buffer.length, session, lb) : StringSerializer.writeUTF8(str, 0, len, session, lb);
    }

    public static LinkedBuffer writeAscii(CharSequence str, WriteSession session, LinkedBuffer lb) {
        int len = str.length();
        if (len == 0) {
            return lb;
        }
        byte[] buffer = lb.buffer;
        int offset = lb.offset;
        int limit = lb.buffer.length;
        session.size += len;
        if (offset + len > limit) {
            for (int i = 0; i < len; ++i) {
                if (offset == limit) {
                    lb.offset = offset;
                    offset = 0;
                    limit = session.nextBufferSize;
                    buffer = new byte[limit];
                    lb = new LinkedBuffer(buffer, 0, lb);
                }
                buffer[offset++] = (byte)str.charAt(i);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                buffer[offset++] = (byte)str.charAt(i);
            }
        }
        lb.offset = offset;
        return lb;
    }

    static void writeFixed2ByteInt(int value, byte[] buffer, int offset, boolean littleEndian) {
        if (littleEndian) {
            buffer[offset++] = (byte)value;
            buffer[offset] = (byte)(value >>> 8 & 0xFF);
        } else {
            buffer[offset++] = (byte)(value >>> 8 & 0xFF);
            buffer[offset] = (byte)value;
        }
    }

    public static LinkedBuffer writeUTF8FixedDelimited(CharSequence str, WriteSession session, LinkedBuffer lb) {
        return StringSerializer.writeUTF8FixedDelimited(str, false, session, lb);
    }

    public static LinkedBuffer writeUTF8FixedDelimited(CharSequence str, boolean littleEndian, WriteSession session, LinkedBuffer lb) {
        int lastSize = session.size;
        int len = str.length();
        int withIntOffset = lb.offset + 2;
        if (withIntOffset > lb.buffer.length) {
            lb = new LinkedBuffer(len + 2 > session.nextBufferSize ? len + 2 : session.nextBufferSize, lb);
            lb.offset = 2;
            if (len == 0) {
                StringSerializer.writeFixed2ByteInt(0, lb.buffer, 0, littleEndian);
                session.size += 2;
                return lb;
            }
            LinkedBuffer rb = StringSerializer.writeUTF8(str, 0, len, session, lb);
            StringSerializer.writeFixed2ByteInt(session.size - lastSize, lb.buffer, 0, littleEndian);
            session.size += 2;
            return rb;
        }
        if (len == 0) {
            StringSerializer.writeFixed2ByteInt(0, lb.buffer, lb.offset, littleEndian);
            lb.offset = withIntOffset;
            session.size += 2;
            return lb;
        }
        if (withIntOffset + len > lb.buffer.length) {
            lb.offset = withIntOffset;
            LinkedBuffer rb = StringSerializer.writeUTF8(str, 0, len, lb.buffer, withIntOffset, lb.buffer.length, session, lb);
            StringSerializer.writeFixed2ByteInt(session.size - lastSize, lb.buffer, withIntOffset - 2, littleEndian);
            session.size += 2;
            return rb;
        }
        lb.offset = withIntOffset;
        LinkedBuffer rb = StringSerializer.writeUTF8(str, 0, len, session, lb);
        StringSerializer.writeFixed2ByteInt(session.size - lastSize, lb.buffer, withIntOffset - 2, littleEndian);
        session.size += 2;
        return rb;
    }

    private static LinkedBuffer writeUTF8OneByteDelimited(CharSequence str, int index, int len, WriteSession session, LinkedBuffer lb) {
        int lastSize = session.size;
        if (lb.offset == lb.buffer.length) {
            lb = new LinkedBuffer(len + 1 > session.nextBufferSize ? len + 1 : session.nextBufferSize, lb);
            lb.offset = 1;
            LinkedBuffer rb = StringSerializer.writeUTF8(str, index, len, session, lb);
            lb.buffer[0] = (byte)(session.size - lastSize);
            ++session.size;
            return rb;
        }
        int withIntOffset = lb.offset + 1;
        if (withIntOffset + len > lb.buffer.length) {
            lb.offset = withIntOffset;
            byte[] buffer = lb.buffer;
            LinkedBuffer rb = StringSerializer.writeUTF8(str, index, len, buffer, withIntOffset, buffer.length, session, lb);
            buffer[withIntOffset - 1] = (byte)(session.size - lastSize);
            ++session.size;
            return rb;
        }
        lb.offset = withIntOffset;
        LinkedBuffer rb = StringSerializer.writeUTF8(str, index, len, session, lb);
        lb.buffer[withIntOffset - 1] = (byte)(session.size - lastSize);
        ++session.size;
        return rb;
    }

    private static LinkedBuffer writeUTF8VarDelimited(CharSequence str, int index, int len, int lowerLimit, int expectedSize, WriteSession session, LinkedBuffer lb) {
        int lastSize = session.size;
        int offset = lb.offset;
        int withIntOffset = offset + expectedSize;
        if (withIntOffset > lb.buffer.length) {
            lb = new LinkedBuffer(len + expectedSize > session.nextBufferSize ? len + expectedSize : session.nextBufferSize, lb);
            offset = lb.start;
            lb.offset = withIntOffset = offset + expectedSize;
            LinkedBuffer rb = StringSerializer.writeUTF8(str, index, len, session, lb);
            int size = session.size - lastSize;
            if (size < lowerLimit) {
                System.arraycopy(lb.buffer, withIntOffset, lb.buffer, withIntOffset - 1, lb.offset - withIntOffset);
                --expectedSize;
                --lb.offset;
            }
            session.size += expectedSize;
            while (--expectedSize > 0) {
                lb.buffer[offset++] = (byte)(size & 0x7F | 0x80);
                size >>>= 7;
            }
            lb.buffer[offset] = (byte)size;
            return rb;
        }
        if (withIntOffset + len > lb.buffer.length) {
            lb.offset = withIntOffset;
            LinkedBuffer rb = StringSerializer.writeUTF8(str, index, len, lb.buffer, withIntOffset, lb.buffer.length, session, lb);
            int size = session.size - lastSize;
            if (size < lowerLimit) {
                System.arraycopy(lb.buffer, withIntOffset, lb.buffer, withIntOffset - 1, lb.offset - withIntOffset);
                --expectedSize;
                --lb.offset;
            }
            session.size += expectedSize;
            while (--expectedSize > 0) {
                lb.buffer[offset++] = (byte)(size & 0x7F | 0x80);
                size >>>= 7;
            }
            lb.buffer[offset] = (byte)size;
            return rb;
        }
        lb.offset = withIntOffset;
        LinkedBuffer rb = StringSerializer.writeUTF8(str, index, len, session, lb);
        int size = session.size - lastSize;
        if (size < lowerLimit) {
            System.arraycopy(lb.buffer, withIntOffset, lb.buffer, withIntOffset - 1, lb.offset - withIntOffset);
            --expectedSize;
            --lb.offset;
        }
        session.size += expectedSize;
        while (--expectedSize > 0) {
            lb.buffer[offset++] = (byte)(size & 0x7F | 0x80);
            size >>>= 7;
        }
        lb.buffer[offset] = (byte)size;
        return rb;
    }

    public static LinkedBuffer writeUTF8VarDelimited(CharSequence str, WriteSession session, LinkedBuffer lb) {
        int len = str.length();
        if (len == 0) {
            if (lb.offset == lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            lb.buffer[lb.offset++] = 0;
            ++session.size;
            return lb;
        }
        if (len < 43) {
            return StringSerializer.writeUTF8OneByteDelimited(str, 0, len, session, lb);
        }
        if (len < 5462) {
            return StringSerializer.writeUTF8VarDelimited(str, 0, len, 128, 2, session, lb);
        }
        if (len < 699051) {
            return StringSerializer.writeUTF8VarDelimited(str, 0, len, 16384, 3, session, lb);
        }
        if (len < 0x5555556) {
            return StringSerializer.writeUTF8VarDelimited(str, 0, len, 0x200000, 4, session, lb);
        }
        return StringSerializer.writeUTF8VarDelimited(str, 0, len, 0x10000000, 5, session, lb);
    }

    public static char highSurrogate(int codePoint) {
        return (char)((codePoint >>> 10) + 55232);
    }

    public static char lowSurrogate(int codePoint) {
        return (char)((codePoint & 0x3FF) + 56320);
    }

    public static final class STRING {
        static final boolean CESU8_COMPAT = Boolean.getBoolean("io.protostuff.cesu8_compat");

        private STRING() {
        }

        public static String deser(byte[] nonNullValue) {
            return STRING.deser(nonNullValue, 0, nonNullValue.length);
        }

        public static String deser(byte[] nonNullValue, int offset, int len) {
            String result;
            try {
                result = new String(nonNullValue, offset, len, "UTF-8");
                if (CESU8_COMPAT && result.indexOf(65533) != -1) {
                    try {
                        return STRING.readUTF(nonNullValue, offset, len);
                    }
                    catch (UTFDataFormatException e) {
                        return result;
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        static String deserCustomOnly(byte[] nonNullValue) {
            try {
                return STRING.readUTF(nonNullValue, 0, nonNullValue.length);
            }
            catch (UTFDataFormatException e) {
                throw new RuntimeException(e);
            }
        }

        public static byte[] ser(String nonNullValue) {
            try {
                return nonNullValue.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        private static String readUTF(byte[] buffer, int offset, int len) throws UTFDataFormatException {
            int ch;
            int i;
            char[] charArray = new char[len];
            int c = 0;
            for (i = 0; i < len && (ch = buffer[offset + i] & 0xFF) <= 127; ++i) {
                charArray[c++] = (char)ch;
            }
            while (i < len) {
                byte ch3;
                byte ch2;
                ch = buffer[offset + i] & 0xFF;
                int upperBits = ch >> 4;
                if (upperBits <= 7) {
                    charArray[c++] = (char)ch;
                    ++i;
                    continue;
                }
                if (upperBits == 12 || upperBits == 13) {
                    if ((i += 2) > len) {
                        throw new UTFDataFormatException("Malformed input: Partial character at end");
                    }
                    ch2 = buffer[offset + i - 1];
                    if ((ch2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("Malformed input around byte " + i);
                    }
                    charArray[c++] = (char)((ch & 0x1F) << 6 | ch2 & 0x3F);
                    continue;
                }
                if (upperBits == 14) {
                    if ((i += 3) > len) {
                        throw new UTFDataFormatException("Malformed input: Partial character at end");
                    }
                    ch2 = buffer[offset + i - 2];
                    ch3 = buffer[offset + i - 1];
                    if ((ch2 & 0xC0) != 128 || (ch3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("Malformed input around byte " + (i - 1));
                    }
                    charArray[c++] = (char)((ch & 0xF) << 12 | (ch2 & 0x3F) << 6 | ch3 & 0x3F);
                    continue;
                }
                upperBits = ch >> 3;
                if (upperBits == 30) {
                    if ((i += 4) > len) {
                        throw new UTFDataFormatException("Malformed input: Partial character at end");
                    }
                    ch2 = buffer[offset + i - 3];
                    ch3 = buffer[offset + i - 2];
                    byte ch4 = buffer[offset + i - 1];
                    int value = (ch & 7) << 18 | (ch2 & 0x3F) << 12 | (ch3 & 0x3F) << 6 | ch4 & 0x3F;
                    charArray[c++] = StringSerializer.highSurrogate(value);
                    charArray[c++] = StringSerializer.lowSurrogate(value);
                    continue;
                }
                throw new UTFDataFormatException("Malformed input at byte " + i);
            }
            return new String(charArray, 0, c);
        }
    }
}

