/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.service.impl;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.seatunnel.app.common.UserTokenStatusEnum;
import org.apache.seatunnel.app.dal.dao.IUserDao;
import org.apache.seatunnel.app.dal.entity.User;
import org.apache.seatunnel.app.domain.dto.user.ListUserDto;
import org.apache.seatunnel.app.domain.dto.user.UpdateUserDto;
import org.apache.seatunnel.app.domain.dto.user.UserLoginLogDto;
import org.apache.seatunnel.app.domain.request.user.AddUserReq;
import org.apache.seatunnel.app.domain.request.user.UpdateUserReq;
import org.apache.seatunnel.app.domain.request.user.UserListReq;
import org.apache.seatunnel.app.domain.request.user.UserLoginReq;
import org.apache.seatunnel.app.domain.response.PageInfo;
import org.apache.seatunnel.app.domain.response.user.AddUserRes;
import org.apache.seatunnel.app.domain.response.user.UserSimpleInfoRes;
import org.apache.seatunnel.app.security.JwtUtils;
import org.apache.seatunnel.app.service.IRoleService;
import org.apache.seatunnel.app.service.IUserService;
import org.apache.seatunnel.app.utils.PasswordUtils;
import org.apache.seatunnel.server.common.PageData;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UserServiceImpl
implements IUserService {
    @Resource
    private IUserDao userDaoImpl;
    @Resource
    private IRoleService roleServiceImpl;
    @Resource
    private JwtUtils jwtUtils;
    @Value(value="${user.default.passwordSalt:seatunnel}")
    private String defaultSalt;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AddUserRes add(AddUserReq addReq) {
        this.userDaoImpl.checkUserExists(addReq.getUsername());
        UpdateUserDto dto = UpdateUserDto.builder().id(null).username(addReq.getUsername()).password(PasswordUtils.encryptWithSalt(this.defaultSalt, addReq.getPassword())).status(addReq.getStatus().byteValue()).type(addReq.getType().byteValue()).build();
        int userId = this.userDaoImpl.add(dto);
        AddUserRes res = new AddUserRes();
        res.setId(userId);
        this.roleServiceImpl.addUserToRole(userId, addReq.getType().intValue());
        return res;
    }

    @Override
    public void update(UpdateUserReq updateReq) {
        UpdateUserDto dto = UpdateUserDto.builder().id(updateReq.getUserId()).username(updateReq.getUsername()).password(PasswordUtils.encryptWithSalt(this.defaultSalt, updateReq.getPassword())).status(updateReq.getStatus().byteValue()).type(updateReq.getType().byteValue()).build();
        this.userDaoImpl.update(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(int id) {
        this.userDaoImpl.delete(id);
        this.roleServiceImpl.deleteByUserId(id);
    }

    @Override
    public PageInfo<UserSimpleInfoRes> list(UserListReq userListReq) {
        ListUserDto dto = ListUserDto.builder().name(userListReq.getName()).build();
        PageData<User> userPageData = this.userDaoImpl.list(dto, userListReq.getRealPageNo(), userListReq.getPageSize());
        List data = userPageData.getData().stream().map(this::translate).collect(Collectors.toList());
        PageInfo<UserSimpleInfoRes> pageInfo = new PageInfo<UserSimpleInfoRes>();
        pageInfo.setPageNo(userListReq.getPageNo());
        pageInfo.setPageSize(userListReq.getPageSize());
        pageInfo.setData(data);
        pageInfo.setTotalCount(userPageData.getTotalCount());
        return pageInfo;
    }

    @Override
    public void enable(int id) {
        this.userDaoImpl.enable(id);
    }

    @Override
    public void disable(int id) {
        this.userDaoImpl.disable(id);
    }

    @Override
    public UserSimpleInfoRes login(UserLoginReq req) {
        String password;
        String username = req.getUsername();
        User user = this.userDaoImpl.checkPassword(username, password = PasswordUtils.encryptWithSalt(this.defaultSalt, req.getPassword()));
        if (Objects.isNull(user)) {
            throw new SeatunnelException(SeatunnelErrorEnum.USERNAME_PASSWORD_NO_MATCHED);
        }
        UserSimpleInfoRes translate = this.translate(user);
        String token = this.jwtUtils.genToken(translate.toMap());
        translate.setToken(token);
        UserLoginLogDto logDto = UserLoginLogDto.builder().token(token).tokenStatus(UserTokenStatusEnum.ENABLE.enable()).userId(user.getId()).build();
        this.userDaoImpl.insertLoginLog(logDto);
        return translate;
    }

    private UserSimpleInfoRes translate(User user) {
        UserSimpleInfoRes info = new UserSimpleInfoRes();
        info.setId(user.getId());
        info.setStatus(user.getStatus());
        info.setType(user.getType());
        info.setCreateTime(user.getCreateTime());
        info.setUpdateTime(user.getUpdateTime());
        info.setName(user.getUsername());
        return info;
    }
}

