/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client.job;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.engine.client.SeaTunnelHazelcastClient;
import org.apache.seatunnel.engine.client.job.ClientJobProxy;
import org.apache.seatunnel.engine.client.job.JobClient;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.core.job.AbstractJobEnvironment;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.parse.MultipleTableJobConfigParser;

public class JobExecutionEnvironment
extends AbstractJobEnvironment {
    private final String jobFilePath;
    private final SeaTunnelHazelcastClient seaTunnelHazelcastClient;
    private final JobClient jobClient;

    public JobExecutionEnvironment(JobConfig jobConfig, String jobFilePath, SeaTunnelHazelcastClient seaTunnelHazelcastClient, boolean isStartWithSavePoint, Long jobId) {
        super(jobConfig, isStartWithSavePoint);
        this.jobFilePath = jobFilePath;
        this.seaTunnelHazelcastClient = seaTunnelHazelcastClient;
        this.jobClient = new JobClient(seaTunnelHazelcastClient);
        this.jobConfig.setJobContext(new JobContext(Long.valueOf(isStartWithSavePoint ? jobId.longValue() : this.jobClient.getNewJobId())));
    }

    public JobExecutionEnvironment(JobConfig jobConfig, String jobFilePath, SeaTunnelHazelcastClient seaTunnelHazelcastClient) {
        this(jobConfig, jobFilePath, seaTunnelHazelcastClient, false, null);
    }

    protected MultipleTableJobConfigParser getJobConfigParser() {
        return new MultipleTableJobConfigParser(this.jobFilePath, this.idGenerator, this.jobConfig, this.commonPluginJars, this.isStartWithSavePoint);
    }

    public ClientJobProxy execute() throws ExecutionException, InterruptedException {
        JobImmutableInformation jobImmutableInformation = new JobImmutableInformation(Long.parseLong(this.jobConfig.getJobContext().getJobId()), this.jobConfig.getName(), this.isStartWithSavePoint, this.seaTunnelHazelcastClient.getSerializationService().toData((Object)this.getLogicalDag()), this.jobConfig, new ArrayList(this.jarUrls));
        return this.jobClient.createJobProxy(jobImmutableInformation);
    }
}

