/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.execution;

import java.net.URL;
import java.util.List;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public interface RuntimeEnvironment {
    public RuntimeEnvironment setConfig(Config var1);

    public Config getConfig();

    public CheckResult checkConfig();

    public RuntimeEnvironment prepare();

    public RuntimeEnvironment setJobMode(JobMode var1);

    public JobMode getJobMode();

    public void registerPlugin(List<URL> var1);

    default public void initialize(Config config) {
        this.setConfig(config.getConfig("env")).setJobMode(RuntimeEnvironment.getJobMode(config)).prepare();
    }

    public static JobMode getJobMode(Config config) {
        Config envConfig = config.getConfig("env");
        JobMode jobMode = envConfig.hasPath("job.mode") ? (JobMode)envConfig.getEnum(JobMode.class, "job.mode") : JobMode.BATCH;
        return jobMode;
    }
}

