/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.command;

import com.beust.jcommander.Parameter;
import java.util.Collections;
import java.util.List;
import org.apache.seatunnel.common.config.DeployMode;
import org.apache.seatunnel.core.starter.command.CommandArgs;

public abstract class AbstractCommandArgs
extends CommandArgs {
    @Parameter(names={"-c", "--config"}, description="Config file")
    protected String configFile;
    @Parameter(names={"-i", "--variable"}, description="Variable substitution, such as -i city=beijing, or -i date=20190318")
    protected List<String> variables = Collections.emptyList();
    @Parameter(names={"--check"}, description="Whether check config")
    protected boolean checkConfig = false;
    @Parameter(names={"-n", "--name"}, description="SeaTunnel job name")
    protected String jobName = "SeaTunnel";
    @Parameter(names={"--encrypt"}, description="Encrypt config file, when both --decrypt and --encrypt are specified, only --encrypt will take effect")
    protected boolean encrypt = false;
    @Parameter(names={"--decrypt"}, description="Decrypt config file, When both --decrypt and --encrypt are specified, only --encrypt will take effect")
    protected boolean decrypt = false;

    public abstract DeployMode getDeployMode();

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractCommandArgs)) {
            return false;
        }
        AbstractCommandArgs other = (AbstractCommandArgs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isCheckConfig() != other.isCheckConfig()) {
            return false;
        }
        if (this.isEncrypt() != other.isEncrypt()) {
            return false;
        }
        if (this.isDecrypt() != other.isDecrypt()) {
            return false;
        }
        String this$configFile = this.getConfigFile();
        String other$configFile = other.getConfigFile();
        if (this$configFile == null ? other$configFile != null : !this$configFile.equals(other$configFile)) {
            return false;
        }
        List<String> this$variables = this.getVariables();
        List<String> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        String this$jobName = this.getJobName();
        String other$jobName = other.getJobName();
        return !(this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractCommandArgs;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isCheckConfig() ? 79 : 97);
        result = result * 59 + (this.isEncrypt() ? 79 : 97);
        result = result * 59 + (this.isDecrypt() ? 79 : 97);
        String $configFile = this.getConfigFile();
        result = result * 59 + ($configFile == null ? 43 : $configFile.hashCode());
        List<String> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        String $jobName = this.getJobName();
        result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
        return result;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public boolean isCheckConfig() {
        return this.checkConfig;
    }

    public String getJobName() {
        return this.jobName;
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public boolean isDecrypt() {
        return this.decrypt;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setVariables(List<String> variables) {
        this.variables = variables;
    }

    public void setCheckConfig(boolean checkConfig) {
        this.checkConfig = checkConfig;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public void setDecrypt(boolean decrypt) {
        this.decrypt = decrypt;
    }

    @Override
    public String toString() {
        return "AbstractCommandArgs(configFile=" + this.getConfigFile() + ", variables=" + this.getVariables() + ", checkConfig=" + this.isCheckConfig() + ", jobName=" + this.getJobName() + ", encrypt=" + this.isEncrypt() + ", decrypt=" + this.isDecrypt() + ")";
    }
}

