/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.parse;

import com.hazelcast.logging.ILogger;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.api.common.CommonOptions;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.env.EnvCommonOptions;
import org.apache.seatunnel.api.env.ParsingMode;
import org.apache.seatunnel.api.sink.DataSaveMode;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SupportDataSaveMode;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableTransformFactory;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.core.starter.utils.ConfigBuilder;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.exception.JobDefineCheckException;
import org.apache.seatunnel.engine.common.loader.SeaTunnelChildFirstClassLoader;
import org.apache.seatunnel.engine.common.utils.IdGenerator;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.actions.SinkAction;
import org.apache.seatunnel.engine.core.dag.actions.SinkConfig;
import org.apache.seatunnel.engine.core.dag.actions.SourceAction;
import org.apache.seatunnel.engine.core.dag.actions.TransformAction;
import org.apache.seatunnel.engine.core.parse.ConfigParserUtil;
import org.apache.seatunnel.engine.core.parse.JobConfigParser;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSinkPluginDiscovery;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class MultipleTableJobConfigParser {
    private static final Logger log = LoggerFactory.getLogger(MultipleTableJobConfigParser.class);
    private static final ILogger LOGGER = com.hazelcast.logging.Logger.getLogger(MultipleTableJobConfigParser.class);
    static final String DEFAULT_ID = "default-identifier";
    private final IdGenerator idGenerator;
    private final JobConfig jobConfig;
    private final List<URL> commonPluginJars;
    private final Config seaTunnelJobConfig;
    private final ReadonlyConfig envOptions;
    private final JobConfigParser fallbackParser;
    private final boolean isStartWithSavePoint;

    public MultipleTableJobConfigParser(String jobDefineFilePath, IdGenerator idGenerator, JobConfig jobConfig) {
        this(jobDefineFilePath, idGenerator, jobConfig, Collections.emptyList(), false);
    }

    public MultipleTableJobConfigParser(String jobDefineFilePath, IdGenerator idGenerator, JobConfig jobConfig, List<URL> commonPluginJars, boolean isStartWithSavePoint) {
        this.idGenerator = idGenerator;
        this.jobConfig = jobConfig;
        this.commonPluginJars = commonPluginJars;
        this.isStartWithSavePoint = isStartWithSavePoint;
        this.seaTunnelJobConfig = ConfigBuilder.of((Path)Paths.get(jobDefineFilePath, new String[0]));
        this.envOptions = ReadonlyConfig.fromConfig((Config)this.seaTunnelJobConfig.getConfig("env"));
        this.fallbackParser = new JobConfigParser(idGenerator, commonPluginJars, isStartWithSavePoint);
    }

    public MultipleTableJobConfigParser(Config seaTunnelJobConfig, IdGenerator idGenerator, JobConfig jobConfig, List<URL> commonPluginJars, boolean isStartWithSavePoint) {
        this.idGenerator = idGenerator;
        this.jobConfig = jobConfig;
        this.commonPluginJars = commonPluginJars;
        this.isStartWithSavePoint = isStartWithSavePoint;
        this.seaTunnelJobConfig = seaTunnelJobConfig;
        this.envOptions = ReadonlyConfig.fromConfig((Config)seaTunnelJobConfig.getConfig("env"));
        this.fallbackParser = new JobConfigParser(idGenerator, commonPluginJars, isStartWithSavePoint);
    }

    public ImmutablePair<List<Action>, Set<URL>> parse() {
        List sourceConfigs = TypesafeConfigUtils.getConfigList((Config)this.seaTunnelJobConfig, (String)"source", Collections.emptyList());
        List transformConfigs = TypesafeConfigUtils.getConfigList((Config)this.seaTunnelJobConfig, (String)"transform", Collections.emptyList());
        List sinkConfigs = TypesafeConfigUtils.getConfigList((Config)this.seaTunnelJobConfig, (String)"sink", Collections.emptyList());
        List<URL> connectorJars = this.getConnectorJarList(sourceConfigs, sinkConfigs);
        if (!this.commonPluginJars.isEmpty()) {
            connectorJars.addAll(this.commonPluginJars);
        }
        SeaTunnelChildFirstClassLoader classLoader = new SeaTunnelChildFirstClassLoader(connectorJars, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
        ConfigParserUtil.checkGraph(sourceConfigs, transformConfigs, sinkConfigs);
        this.fillJobConfig();
        LinkedHashMap<String, List<Tuple2<CatalogTable, Action>>> tableWithActionMap = new LinkedHashMap<String, List<Tuple2<CatalogTable, Action>>>();
        log.info("start generating all sources.");
        for (Config sourceConfig : sourceConfigs) {
            Tuple2<String, List<Tuple2<CatalogTable, Action>>> tuple2 = this.parseSource(sourceConfig, (ClassLoader)classLoader);
            tableWithActionMap.put((String)tuple2._1(), (List<Tuple2<CatalogTable, Action>>)tuple2._2());
        }
        log.info("start generating all transforms.");
        this.parseTransforms(transformConfigs, (ClassLoader)classLoader, tableWithActionMap);
        log.info("start generating all sinks.");
        ArrayList<Action> sinkActions = new ArrayList<Action>();
        for (int configIndex = 0; configIndex < sinkConfigs.size(); ++configIndex) {
            Config sinkConfig = (Config)sinkConfigs.get(configIndex);
            sinkActions.addAll(this.parseSink(configIndex, sinkConfig, (ClassLoader)classLoader, tableWithActionMap));
        }
        Set<URL> factoryUrls = this.getUsedFactoryUrls(sinkActions);
        factoryUrls.addAll(this.commonPluginJars);
        sinkActions.forEach(this::addCommonPluginJarsToAction);
        return new ImmutablePair(sinkActions, factoryUrls);
    }

    public Set<URL> getUsedFactoryUrls(List<Action> sinkActions) {
        HashSet<URL> urls = new HashSet<URL>();
        this.fillUsedFactoryUrls(sinkActions, urls);
        return urls;
    }

    private List<URL> getConnectorJarList(List<? extends Config> sourceConfigs, List<? extends Config> sinkConfigs) {
        List factoryIds = Stream.concat(sourceConfigs.stream().map(ConfigParserUtil::getFactoryId).map(factory -> PluginIdentifier.of((String)"seatunnel", (String)"source", (String)factory)), sinkConfigs.stream().map(ConfigParserUtil::getFactoryId).map(factory -> PluginIdentifier.of((String)"seatunnel", (String)"sink", (String)factory))).collect(Collectors.toList());
        return new SeaTunnelSinkPluginDiscovery().getPluginJarPaths(factoryIds);
    }

    private void fillUsedFactoryUrls(List<Action> actions, Set<URL> result) {
        actions.forEach(action -> {
            result.addAll(action.getJarUrls());
            if (!action.getUpstream().isEmpty()) {
                this.fillUsedFactoryUrls(action.getUpstream(), result);
            }
        });
    }

    void addCommonPluginJarsToAction(Action action) {
        action.getJarUrls().addAll(this.commonPluginJars);
        if (!action.getUpstream().isEmpty()) {
            action.getUpstream().forEach(this::addCommonPluginJarsToAction);
        }
    }

    private void fillJobConfig() {
        this.jobConfig.getJobContext().setJobMode((JobMode)this.envOptions.get(EnvCommonOptions.JOB_MODE));
        if (StringUtils.isEmpty((CharSequence)this.jobConfig.getName()) || this.jobConfig.getName().equals("SeaTunnel")) {
            this.jobConfig.setName((String)this.envOptions.get(EnvCommonOptions.JOB_NAME));
        }
        this.envOptions.toMap().forEach((k, v) -> this.jobConfig.getEnvOptions().put(k, v));
    }

    private static <T extends Factory> boolean isFallback(ClassLoader classLoader, Class<T> factoryClass, String factoryId, Consumer<T> virtualCreator) {
        block3: {
            Optional factory = FactoryUtil.discoverOptionalFactory((ClassLoader)classLoader, factoryClass, (String)factoryId);
            if (!factory.isPresent()) {
                return true;
            }
            try {
                virtualCreator.accept(factory.get());
            }
            catch (Exception e) {
                if (!(e instanceof UnsupportedOperationException) || !"The Factory has not been implemented and the deprecated Plugin will be used.".equals(e.getMessage())) break block3;
                return true;
            }
        }
        return false;
    }

    private int getParallelism(ReadonlyConfig config) {
        return Math.max(1, (Integer)config.getOptional(CommonOptions.PARALLELISM).orElse(this.envOptions.get(CommonOptions.PARALLELISM)));
    }

    public Tuple2<String, List<Tuple2<CatalogTable, Action>>> parseSource(Config sourceConfig, ClassLoader classLoader) {
        List tables;
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig((Config)sourceConfig);
        String factoryId = ConfigParserUtil.getFactoryId(readonlyConfig);
        String tableId = readonlyConfig.getOptional(CommonOptions.RESULT_TABLE_NAME).orElse(DEFAULT_ID);
        int parallelism = this.getParallelism(readonlyConfig);
        boolean fallback = MultipleTableJobConfigParser.isFallback(classLoader, TableSourceFactory.class, factoryId, factory -> factory.createSource(null));
        ArrayList<CatalogTable> catalogTables = new ArrayList<CatalogTable>();
        if (!fallback && !(tables = CatalogTableUtil.getCatalogTables((Config)sourceConfig, (ClassLoader)classLoader)).isEmpty()) {
            catalogTables.addAll(tables);
        }
        if (fallback || catalogTables.isEmpty()) {
            Tuple2<CatalogTable, Action> tuple = this.fallbackParser.parseSource(sourceConfig, this.jobConfig, tableId, parallelism);
            return new Tuple2((Object)tableId, Collections.singletonList(tuple));
        }
        if (readonlyConfig.get(SourceOptions.DAG_PARSING_MODE) == ParsingMode.SHARDING) {
            CatalogTable shardingTable = (CatalogTable)catalogTables.get(0);
            catalogTables.clear();
            catalogTables.add(shardingTable);
        }
        List sources = FactoryUtil.createAndPrepareSource(catalogTables, (ReadonlyConfig)readonlyConfig, (ClassLoader)classLoader, (String)factoryId);
        Set<URL> factoryUrls = ConfigParserUtil.getFactoryUrls(readonlyConfig, classLoader, TableSourceFactory.class, factoryId);
        ArrayList<Tuple2> actions = new ArrayList<Tuple2>();
        for (int configIndex = 0; configIndex < sources.size(); ++configIndex) {
            Tuple2 tuple2 = (Tuple2)sources.get(configIndex);
            long id = this.idGenerator.getNextId();
            String actionName = JobConfigParser.createSourceActionName(configIndex, factoryId, tableId);
            SeaTunnelSource source = (SeaTunnelSource)tuple2._1();
            source.setJobContext(this.jobConfig.getJobContext());
            MultipleTableJobConfigParser.ensureJobModeMatch(this.jobConfig.getJobContext(), source);
            SourceAction action = new SourceAction(id, actionName, (SeaTunnelSource)tuple2._1(), factoryUrls);
            action.setParallelism(parallelism);
            for (CatalogTable catalogTable : (List)tuple2._2()) {
                actions.add(new Tuple2((Object)catalogTable, action));
            }
        }
        return new Tuple2((Object)tableId, actions);
    }

    public static void ensureJobModeMatch(JobContext jobContext, SeaTunnelSource source) {
        if (jobContext.getJobMode() == JobMode.BATCH && source.getBoundedness() == Boundedness.UNBOUNDED) {
            throw new JobDefineCheckException(String.format("'%s' source don't support off-line job.", source.getPluginName()));
        }
    }

    public void parseTransforms(List<? extends Config> transformConfigs, ClassLoader classLoader, LinkedHashMap<String, List<Tuple2<CatalogTable, Action>>> tableWithActionMap) {
        if (CollectionUtils.isEmpty(transformConfigs) || transformConfigs.size() == 0) {
            return;
        }
        LinkedList<Config> configList = new LinkedList<Config>(transformConfigs);
        while (!configList.isEmpty()) {
            this.parseTransform(configList, classLoader, tableWithActionMap);
        }
    }

    private void parseTransform(Queue<Config> transforms, ClassLoader classLoader, LinkedHashMap<String, List<Tuple2<CatalogTable, Action>>> tableWithActionMap) {
        Config config = transforms.poll();
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig((Config)config);
        String factoryId = ConfigParserUtil.getFactoryId(readonlyConfig);
        Set<URL> factoryUrls = ConfigParserUtil.getFactoryUrls(readonlyConfig, classLoader, TableTransformFactory.class, factoryId);
        List<String> inputIds = ConfigParserUtil.getInputIds(readonlyConfig);
        List<Object> inputs = inputIds.stream().map(tableWithActionMap::get).filter(Objects::nonNull).peek(input -> {
            if (input.size() > 1) {
                throw new JobDefineCheckException("Adding transform to multi-table source is not supported.");
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
        if (inputs.isEmpty()) {
            if (transforms.isEmpty()) {
                inputs = MultipleTableJobConfigParser.findLast(tableWithActionMap);
            } else {
                transforms.offer(config);
                return;
            }
        }
        String tableId = readonlyConfig.getOptional(CommonOptions.RESULT_TABLE_NAME).orElse(DEFAULT_ID);
        boolean fallback = MultipleTableJobConfigParser.isFallback(classLoader, TableTransformFactory.class, factoryId, factory -> factory.createTransform(null));
        Set inputActions = inputs.stream().map(Tuple2::_2).collect(Collectors.toCollection(LinkedHashSet::new));
        SeaTunnelDataType<?> expectedType = MultipleTableJobConfigParser.getProducedType((Action)((Tuple2)inputs.get(0))._2());
        MultipleTableJobConfigParser.checkProducedTypeEquals(inputActions);
        int spareParallelism = ((Action)((Tuple2)inputs.get(0))._2()).getParallelism();
        int parallelism = readonlyConfig.getOptional(CommonOptions.PARALLELISM).orElse(spareParallelism);
        if (fallback) {
            Tuple2<CatalogTable, Action> tuple = this.fallbackParser.parseTransform(config, this.jobConfig, tableId, parallelism, (SeaTunnelRowType)expectedType, inputActions);
            tableWithActionMap.put(tableId, Collections.singletonList(tuple));
            return;
        }
        CatalogTable catalogTable = (CatalogTable)((Tuple2)inputs.get(0))._1();
        SeaTunnelTransform transform = FactoryUtil.createAndPrepareTransform((CatalogTable)catalogTable, (ReadonlyConfig)readonlyConfig, (ClassLoader)classLoader, (String)factoryId);
        transform.setJobContext(this.jobConfig.getJobContext());
        long id = this.idGenerator.getNextId();
        String actionName = JobConfigParser.createTransformActionName(0, factoryId, JobConfigParser.getTableName(config));
        TransformAction transformAction = new TransformAction(id, actionName, new ArrayList<Action>(inputActions), transform, factoryUrls);
        transformAction.setParallelism(parallelism);
        tableWithActionMap.put(tableId, Collections.singletonList(new Tuple2((Object)transform.getProducedCatalogTable(), (Object)transformAction)));
    }

    public static SeaTunnelDataType<?> getProducedType(Action action) {
        if (action instanceof SourceAction) {
            return ((SourceAction)action).getSource().getProducedType();
        }
        if (action instanceof TransformAction) {
            return ((TransformAction)action).getTransform().getProducedType();
        }
        throw new UnsupportedOperationException();
    }

    public static void checkProducedTypeEquals(Set<Action> inputActions) {
        SeaTunnelDataType<?> expectedType = MultipleTableJobConfigParser.getProducedType(new ArrayList<Action>(inputActions).get(0));
        for (Action action : inputActions) {
            SeaTunnelDataType<?> producedType = MultipleTableJobConfigParser.getProducedType(action);
            if (expectedType.equals(producedType)) continue;
            throw new JobDefineCheckException("Transform/Sink don't support processing data with two different structures.");
        }
    }

    @Deprecated
    private static <T> T findLast(LinkedHashMap<?, T> map) {
        int size = map.size();
        int i = 1;
        for (T value : map.values()) {
            if (i == size) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public List<SinkAction<?, ?, ?, ?>> parseSink(int configIndex, Config sinkConfig, ClassLoader classLoader, LinkedHashMap<String, List<Tuple2<CatalogTable, Action>>> tableWithActionMap) {
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig((Config)sinkConfig);
        String factoryId = ConfigParserUtil.getFactoryId(readonlyConfig);
        List<String> inputIds = ConfigParserUtil.getInputIds(readonlyConfig);
        List<Object> inputVertices = inputIds.stream().map(tableWithActionMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        if (inputVertices.isEmpty()) {
            inputVertices = Collections.singletonList(MultipleTableJobConfigParser.findLast(tableWithActionMap));
        } else if (inputVertices.size() > 1) {
            for (List inputVertex : inputVertices) {
                if (inputVertex.size() <= 1) continue;
                throw new JobDefineCheckException("Sink don't support simultaneous writing of data from multi-table source and other sources.");
            }
        }
        boolean fallback = MultipleTableJobConfigParser.isFallback(classLoader, TableSinkFactory.class, factoryId, factory -> factory.createSink(null));
        if (fallback) {
            return this.fallbackParser.parseSinks(inputVertices, sinkConfig, this.jobConfig);
        }
        Map<TablePath, CatalogTable> tableMap = CatalogTableUtil.getCatalogTables((Config)sinkConfig, (ClassLoader)classLoader).stream().collect(Collectors.toMap(catalogTable -> catalogTable.getTableId().toTablePath(), catalogTable -> catalogTable));
        Set<URL> factoryUrls = ConfigParserUtil.getFactoryUrls(readonlyConfig, classLoader, TableSinkFactory.class, factoryId);
        ArrayList sinkActions = new ArrayList();
        if (inputVertices.size() > 1) {
            Set inputActions = inputVertices.stream().flatMap(Collection::stream).map(Tuple2::_2).collect(Collectors.toCollection(LinkedHashSet::new));
            MultipleTableJobConfigParser.checkProducedTypeEquals(inputActions);
            Tuple2 inputActionSample = (Tuple2)((List)inputVertices.get(0)).get(0);
            SinkAction<?, ?, ?, ?> sinkAction = this.createSinkAction((CatalogTable)inputActionSample._1(), tableMap, inputActions, readonlyConfig, classLoader, factoryUrls, factoryId, ((Action)inputActionSample._2()).getParallelism(), configIndex);
            sinkActions.add(sinkAction);
            return sinkActions;
        }
        for (Tuple2 tuple : (List)inputVertices.get(0)) {
            SinkAction<?, ?, ?, ?> sinkAction = this.createSinkAction((CatalogTable)tuple._1(), tableMap, Collections.singleton(tuple._2()), readonlyConfig, classLoader, factoryUrls, factoryId, ((Action)tuple._2()).getParallelism(), configIndex);
            sinkActions.add(sinkAction);
        }
        return sinkActions;
    }

    private SinkAction<?, ?, ?, ?> createSinkAction(CatalogTable catalogTable, Map<TablePath, CatalogTable> sinkTableMap, Set<Action> inputActions, ReadonlyConfig readonlyConfig, ClassLoader classLoader, Set<URL> factoryUrls, String factoryId, int parallelism, int configIndex) {
        Optional<CatalogTable> insteadTable = sinkTableMap.size() == 1 ? sinkTableMap.values().stream().findFirst() : Optional.ofNullable(sinkTableMap.get(catalogTable.getTableId().toTablePath()));
        if (insteadTable.isPresent()) {
            catalogTable = insteadTable.get();
        }
        SeaTunnelSink sink = FactoryUtil.createAndPrepareSink((CatalogTable)catalogTable, (ReadonlyConfig)readonlyConfig, (ClassLoader)classLoader, (String)factoryId);
        sink.setJobContext(this.jobConfig.getJobContext());
        SinkConfig actionConfig = new SinkConfig(catalogTable.getTableId().toTablePath().toString());
        long id = this.idGenerator.getNextId();
        String actionName = JobConfigParser.createSinkActionName(configIndex, factoryId, actionConfig.getMultipleRowTableId());
        SinkAction sinkAction = new SinkAction(id, actionName, new ArrayList<Action>(inputActions), sink, factoryUrls, actionConfig);
        if (!this.isStartWithSavePoint) {
            MultipleTableJobConfigParser.handleSaveMode(sink);
        }
        sinkAction.setParallelism(parallelism);
        return sinkAction;
    }

    public static void handleSaveMode(SeaTunnelSink<?, ?, ?, ?> sink) {
        if (SupportDataSaveMode.class.isAssignableFrom(sink.getClass())) {
            SupportDataSaveMode saveModeSink = (SupportDataSaveMode)sink;
            DataSaveMode dataSaveMode = saveModeSink.getUserConfigSaveMode();
            saveModeSink.handleSaveMode(dataSaveMode);
        }
    }
}

