/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.JobClassLoaderService;
import com.hazelcast.jet.impl.deployment.JetDelegatingClassLoader;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.impl.execution.init.EdgeDef;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.execution.init.VertexDef;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.PrefixedLogger;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.security.auth.Subject;

public final class ExecutionPlanBuilder {
    private ExecutionPlanBuilder() {
    }

    public static Map<MemberInfo, ExecutionPlan> createExecutionPlans(NodeEngineImpl nodeEngine, List<MemberInfo> memberInfos, DAG dag, long jobId, long executionId, JobConfig jobConfig, long lastSnapshotId, boolean isLightJob, Subject subject) {
        int defaultParallelism = nodeEngine.getConfig().getJetConfig().getCooperativeThreadCount();
        Map<MemberInfo, int[]> partitionsByMember = ExecutionPlanBuilder.getPartitionAssignment(nodeEngine, memberInfos);
        Map<Address, int[]> partitionsByAddress = partitionsByMember.entrySet().stream().collect(Collectors.toMap(en -> ((MemberInfo)en.getKey()).getAddress(), Map.Entry::getValue));
        List<Address> addresses = Util.toList(partitionsByMember.keySet(), MemberInfo::getAddress);
        int clusterSize = partitionsByMember.size();
        boolean isJobDistributed = clusterSize > 1;
        EdgeConfig defaultEdgeConfig = nodeEngine.getConfig().getJetConfig().getDefaultEdgeConfig();
        HashMap<MemberInfo, ExecutionPlan> plans = new HashMap<MemberInfo, ExecutionPlan>();
        int memberIndex = 0;
        for (MemberInfo member : partitionsByMember.keySet()) {
            plans.put(member, new ExecutionPlan(partitionsByAddress, jobConfig, lastSnapshotId, memberIndex++, clusterSize, isLightJob, subject));
        }
        Map<String, Integer> vertexIdMap = ExecutionPlanBuilder.assignVertexIds(dag);
        for (Map.Entry<String, Integer> entry : vertexIdMap.entrySet()) {
            Vertex vertex = dag.getVertex(entry.getKey());
            assert (vertex != null);
            ProcessorMetaSupplier metaSupplier = vertex.getMetaSupplier();
            int vertexId = entry.getValue();
            int localParallelism = vertex.determineLocalParallelism(defaultParallelism);
            int totalParallelism = localParallelism * clusterSize;
            List<EdgeDef> inbound = ExecutionPlanBuilder.toEdgeDefs(dag.getInboundEdges(vertex.getName()), defaultEdgeConfig, e -> (Integer)vertexIdMap.get(e.getSourceName()), isJobDistributed);
            List<EdgeDef> outbound = ExecutionPlanBuilder.toEdgeDefs(dag.getOutboundEdges(vertex.getName()), defaultEdgeConfig, e -> (Integer)vertexIdMap.get(e.getDestName()), isJobDistributed);
            String prefix = PrefixedLogger.prefix(jobConfig.getName(), jobId, vertex.getName(), "#PMS");
            ILogger logger = PrefixedLogger.prefixedLogger(nodeEngine.getLogger(metaSupplier.getClass()), prefix);
            JetServiceBackend jetBackend = (JetServiceBackend)nodeEngine.getService("hz:impl:jetService");
            JobClassLoaderService jobClassLoaderService = jetBackend.getJobClassLoaderService();
            JetDelegatingClassLoader processorClassLoader = jobClassLoaderService.getClassLoader(jobId);
            try {
                Util.doWithClassLoader((ClassLoader)processorClassLoader, () -> metaSupplier.init(new Contexts.MetaSupplierCtx(nodeEngine, jobId, executionId, jobConfig, logger, vertex.getName(), localParallelism, totalParallelism, clusterSize, isLightJob, partitionsByAddress, subject, processorClassLoader)));
            }
            catch (Exception e2) {
                throw ExceptionUtil.sneakyThrow(e2);
            }
            Function procSupplierFn = Util.doWithClassLoader((ClassLoader)processorClassLoader, () -> metaSupplier.get(addresses));
            for (Map.Entry e3 : plans.entrySet()) {
                ProcessorSupplier processorSupplier = Util.doWithClassLoader((ClassLoader)processorClassLoader, () -> (ProcessorSupplier)procSupplierFn.apply(((MemberInfo)e3.getKey()).getAddress()));
                if (!isLightJob) {
                    Util.checkSerializable(processorSupplier, "ProcessorSupplier in vertex '" + vertex.getName() + '\'');
                }
                VertexDef vertexDef = new VertexDef(vertexId, vertex.getName(), processorSupplier, localParallelism);
                vertexDef.addInboundEdges(inbound);
                vertexDef.addOutboundEdges(outbound);
                ((ExecutionPlan)e3.getValue()).addVertex(vertexDef);
            }
        }
        return plans;
    }

    private static Map<String, Integer> assignVertexIds(DAG dag) {
        LinkedHashMap<String, Integer> vertexIdMap = new LinkedHashMap<String, Integer>();
        int[] vertexId = new int[]{0};
        dag.forEach(v -> {
            int n = vertexId[0];
            vertexId[0] = n + 1;
            vertexIdMap.put(v.getName(), n);
        });
        return vertexIdMap;
    }

    private static List<EdgeDef> toEdgeDefs(List<Edge> edges, EdgeConfig defaultEdgeConfig, Function<Edge, Integer> oppositeVtxId, boolean isJobDistributed) {
        ArrayList<EdgeDef> list = new ArrayList<EdgeDef>(edges.size());
        for (Edge edge : edges) {
            list.add(new EdgeDef(edge, edge.getConfig() == null ? defaultEdgeConfig : edge.getConfig(), oppositeVtxId.apply(edge), isJobDistributed));
        }
        return list;
    }

    public static Map<MemberInfo, int[]> getPartitionAssignment(NodeEngine nodeEngine, List<MemberInfo> memberList) {
        IPartitionService partitionService = nodeEngine.getPartitionService();
        Map membersByAddress = memberList.stream().collect(Collectors.toMap(MemberInfo::getAddress, FunctionEx.identity()));
        MemberInfo[] partitionOwners = new MemberInfo[partitionService.getPartitionCount()];
        int memberIndex = 0;
        for (int partitionId = 0; partitionId < partitionOwners.length; ++partitionId) {
            Address address = partitionService.getPartitionOwnerOrWait(partitionId);
            MemberInfo member = (MemberInfo)membersByAddress.get(address);
            if (member == null) {
                member = memberList.get(memberIndex++ % memberList.size());
            }
            partitionOwners[partitionId] = member;
        }
        return IntStream.range(0, partitionOwners.length).mapToObj(i -> Tuple2.tuple2(partitionOwners[i], i)).collect(Collectors.groupingBy(Tuple2::f0, Collectors.mapping(Tuple2::f1, Collectors.collectingAndThen(Collectors.toList(), intList -> intList.stream().mapToInt(Integer::intValue).toArray()))));
    }
}

