/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddPartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAddListenerMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.security.Permission;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class MapAddPartitionLostListenerMessageTask
extends AbstractAddListenerMessageTask<MapAddPartitionLostListenerCodec.RequestParameters> {
    public MapAddPartitionLostListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<UUID> processInternal() {
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        MapPartitionLostListener listener = event -> {
            if (this.endpoint.isAlive()) {
                ClientMessage eventMessage = MapAddPartitionLostListenerCodec.encodeMapPartitionLostEvent(event.getPartitionId(), event.getMember().getUuid());
                this.sendClientMessage(null, eventMessage);
            }
        };
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        if (((MapAddPartitionLostListenerCodec.RequestParameters)this.parameters).localOnly) {
            return InternalCompletableFuture.newCompletedFuture(mapServiceContext.addLocalPartitionLostListener(listener, ((MapAddPartitionLostListenerCodec.RequestParameters)this.parameters).name));
        }
        return mapServiceContext.addPartitionLostListenerAsync(listener, ((MapAddPartitionLostListenerCodec.RequestParameters)this.parameters).name);
    }

    @Override
    protected MapAddPartitionLostListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapAddPartitionLostListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapAddPartitionLostListenerCodec.encodeResponse((UUID)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public String getMethodName() {
        return "addPartitionLostListener";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{null};
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapAddPartitionLostListenerCodec.RequestParameters)this.parameters).name, "listen");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapAddPartitionLostListenerCodec.RequestParameters)this.parameters).name;
    }
}

