/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.datasource.classloader.DatasourceClassLoader;
import org.apache.seatunnel.datasource.classloader.DatasourceLoadConfig;
import org.apache.seatunnel.datasource.exception.DataSourceSDKException;
import org.apache.seatunnel.datasource.plugin.api.DataSourceChannel;
import org.apache.seatunnel.datasource.plugin.api.DataSourceFactory;
import org.apache.seatunnel.datasource.plugin.api.DataSourcePluginInfo;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.datasource.service.DataSourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourceClient
implements DataSourceService {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataSourceClient.class);
    private static final String ST_WEB_BASEDIR_PATH = "ST_WEB_BASEDIR_PATH";
    private ThreadLocal<ClassLoader> datasourceClassLoader = new ThreadLocal();
    private Map<String, DataSourcePluginInfo> supportedDataSourceInfo = new HashMap<String, DataSourcePluginInfo>();
    private Map<String, Integer> supportedDataSourceIndex = new HashMap<String, Integer>();
    protected List<DataSourcePluginInfo> supportedDataSources = new ArrayList<DataSourcePluginInfo>();
    private List<DataSourceChannel> dataSourceChannels = new ArrayList<DataSourceChannel>();
    private Map<String, DataSourceChannel> classLoaderChannel = new HashMap<String, DataSourceChannel>();

    protected AbstractDataSourceClient() {
        AtomicInteger dataSourceIndex = new AtomicInteger();
        for (String pluginName : DatasourceLoadConfig.pluginSet) {
            log.info("plugin set : " + pluginName);
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (DatasourceLoadConfig.classLoaderChannel.get(pluginName.toUpperCase()) != null) {
                log.info(pluginName + " is exist");
                continue;
            }
            Thread.currentThread().setContextClassLoader(this.getCustomClassloader(pluginName));
            try {
                Class<?> clazz = Class.forName(DatasourceLoadConfig.classLoaderFactoryName.get(pluginName.toUpperCase()), true, Thread.currentThread().getContextClassLoader());
                DataSourceFactory factory = (DataSourceFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                log.info("factory : " + factory);
                Set<DataSourcePluginInfo> dataSourcePluginInfos = factory.supportedDataSources();
                dataSourcePluginInfos.forEach(dataSourceInfo -> {
                    this.supportedDataSourceInfo.put(dataSourceInfo.getName().toUpperCase(), (DataSourcePluginInfo)dataSourceInfo);
                    this.supportedDataSourceIndex.put(dataSourceInfo.getName().toUpperCase(), dataSourceIndex.get());
                    this.supportedDataSources.add((DataSourcePluginInfo)dataSourceInfo);
                    log.info("factory : " + dataSourceInfo);
                });
                DatasourceLoadConfig.classLoaderChannel.put(pluginName.toUpperCase(), factory.createChannel());
                log.info(DatasourceLoadConfig.classLoaderChannel.get(pluginName.toUpperCase()).toString());
            }
            catch (Exception e) {
                log.warn("datasource " + pluginName + "is error" + ExceptionUtils.getMessage(e));
            }
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        if (this.supportedDataSourceInfo.isEmpty()) {
            throw new DataSourceSDKException("No supported data source found");
        }
    }

    @Override
    public Boolean checkDataSourceConnectivity(String pluginName, Map<String, String> dataSourceParams) {
        this.updateClassLoader(pluginName);
        boolean isConnect = this.getDataSourceChannel(pluginName).checkDataSourceConnectivity(pluginName, dataSourceParams);
        this.classLoaderRestore();
        return isConnect;
    }

    @Override
    public List<DataSourcePluginInfo> listAllDataSources() {
        return this.supportedDataSources;
    }

    protected DataSourceChannel getDataSourceChannel(String pluginName) {
        Preconditions.checkNotNull(pluginName, "pluginName cannot be null");
        return DatasourceLoadConfig.classLoaderChannel.get(pluginName.toUpperCase());
    }

    @Override
    public OptionRule queryDataSourceFieldByName(String pluginName) {
        this.updateClassLoader(pluginName);
        OptionRule dataSourceOptions = this.getDataSourceChannel(pluginName).getDataSourceOptions(pluginName);
        this.classLoaderRestore();
        return dataSourceOptions;
    }

    @Override
    public OptionRule queryMetadataFieldByName(String pluginName) {
        this.updateClassLoader(pluginName);
        OptionRule datasourceMetadataFieldsByDataSourceName = this.getDataSourceChannel(pluginName).getDatasourceMetadataFieldsByDataSourceName(pluginName);
        this.classLoaderRestore();
        return datasourceMetadataFieldsByDataSourceName;
    }

    @Override
    public List<String> getTables(String pluginName, String databaseName, Map<String, String> requestParams, Map<String, String> options) {
        this.updateClassLoader(pluginName);
        List<String> tables = this.getDataSourceChannel(pluginName).getTables(pluginName, requestParams, databaseName, options);
        this.classLoaderRestore();
        return tables;
    }

    @Override
    public List<String> getDatabases(String pluginName, Map<String, String> requestParams) {
        this.updateClassLoader(pluginName);
        List<String> databases = this.getDataSourceChannel(pluginName).getDatabases(pluginName, requestParams);
        this.classLoaderRestore();
        return databases;
    }

    @Override
    public List<TableField> getTableFields(String pluginName, Map<String, String> requestParams, String databaseName, String tableName) {
        this.updateClassLoader(pluginName);
        List<TableField> tableFields = this.getDataSourceChannel(pluginName).getTableFields(pluginName, requestParams, databaseName, tableName);
        this.classLoaderRestore();
        return tableFields;
    }

    @Override
    public Map<String, List<TableField>> getTableFields(String pluginName, Map<String, String> requestParams, String databaseName, List<String> tableNames) {
        this.updateClassLoader(pluginName);
        Map<String, List<TableField>> tableFields = this.getDataSourceChannel(pluginName).getTableFields(pluginName, requestParams, databaseName, tableNames);
        this.classLoaderRestore();
        return tableFields;
    }

    @Override
    public Pair<String, String> getTableSyncMaxValue(String pluginName, Map<String, String> requestParams, String databaseName, String tableName, String updateFieldType) {
        this.updateClassLoader(pluginName);
        Pair<String, String> tableSyncMaxValue = this.getDataSourceChannel(pluginName).getTableSyncMaxValue(pluginName, requestParams, databaseName, tableName, updateFieldType);
        this.classLoaderRestore();
        return tableSyncMaxValue;
    }

    private ClassLoader getCustomClassloader(String pluginName) {
        String getenv = System.getenv(ST_WEB_BASEDIR_PATH);
        log.info("ST_WEB_BASEDIR_PATH is : " + getenv);
        String libPath = StringUtils.isEmpty(getenv) ? "/datasource" : getenv + "/datasource";
        File jarDirectory = new File(libPath);
        File[] jarFiles = jarDirectory.listFiles((dir, name) -> {
            String pluginUpperCase = pluginName.toUpperCase();
            String nameLowerCase = name.toLowerCase();
            if (pluginUpperCase.equals("KAFKA")) {
                return !nameLowerCase.contains("kingbase") && nameLowerCase.startsWith(DatasourceLoadConfig.classLoaderJarName.get(pluginUpperCase));
            }
            return nameLowerCase.startsWith(DatasourceLoadConfig.classLoaderJarName.get(pluginUpperCase));
        });
        log.info("jar file length :" + (jarFiles == null ? 0 : jarFiles.length));
        log.info("jar file name :" + (jarFiles == null ? Integer.valueOf(0) : (jarFiles.length == 0 ? "no jar" : jarFiles[0].getName())));
        DatasourceClassLoader customClassLoader = DatasourceLoadConfig.datasourceClassLoaders.get(pluginName.toUpperCase());
        try {
            if (customClassLoader == null) {
                jarFiles = jarFiles == null ? new File[]{} : jarFiles;
                URL[] urls = new URL[jarFiles.length];
                for (int i = 0; i < jarFiles.length; ++i) {
                    try {
                        urls[i] = jarFiles[i].toURI().toURL();
                        continue;
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
                customClassLoader = new DatasourceClassLoader(urls, Thread.currentThread().getContextClassLoader());
                DatasourceLoadConfig.datasourceClassLoaders.put(pluginName.toUpperCase(), customClassLoader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("custom loader is:" + customClassLoader);
        return customClassLoader;
    }

    private void updateClassLoader(String pluginName) {
        log.info("update class loader");
        this.datasourceClassLoader.set(Thread.currentThread().getContextClassLoader());
        ClassLoader customClassLoader = this.getCustomClassloader(pluginName);
        Thread.currentThread().setContextClassLoader(customClassLoader);
        log.info(customClassLoader.toString());
    }

    private void classLoaderRestore() {
        try {
            log.info("close class loader");
            Thread.currentThread().setContextClassLoader(this.datasourceClassLoader.get());
        }
        catch (Exception e) {
            log.info("loader catch");
        }
    }

    @Override
    public Connection getConnection(String pluginName, Map<String, String> requestParams) {
        this.updateClassLoader(pluginName);
        Connection connection = this.getDataSourceChannel(pluginName).getConnection(pluginName, requestParams);
        this.classLoaderRestore();
        return connection;
    }
}

