/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.datasource;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcher;

public enum DatasourceConfigSwitcherProvider {
    INSTANCE;

    private final Map<String, DataSourceConfigSwitcher> configSwitcherCache;

    private DatasourceConfigSwitcherProvider() {
        ServiceLoader<DataSourceConfigSwitcher> loader = ServiceLoader.load(DataSourceConfigSwitcher.class);
        this.configSwitcherCache = new ConcurrentHashMap<String, DataSourceConfigSwitcher>();
        for (DataSourceConfigSwitcher switcher : loader) {
            this.configSwitcherCache.put(switcher.getDataSourceName().toUpperCase(), switcher);
        }
    }

    public DataSourceConfigSwitcher getConfigSwitcher(String datasourceName) {
        return this.configSwitcherCache.get(datasourceName);
    }
}

