/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.app.common.EngineType;
import org.apache.seatunnel.app.dal.dao.IJobDefinitionDao;
import org.apache.seatunnel.app.dal.dao.IJobVersionDao;
import org.apache.seatunnel.app.dal.entity.JobDefinition;
import org.apache.seatunnel.app.dal.entity.JobVersion;
import org.apache.seatunnel.app.domain.request.job.JobConfig;
import org.apache.seatunnel.app.domain.response.job.JobConfigRes;
import org.apache.seatunnel.app.service.IJobConfigService;
import org.apache.seatunnel.app.service.impl.SeatunnelBaseServiceImpl;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobConfigServiceImpl
extends SeatunnelBaseServiceImpl
implements IJobConfigService {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String JOB_MODE = "job.mode";
    @Resource
    private IJobVersionDao jobVersionDao;
    @Resource
    private IJobDefinitionDao jobDefinitionDao;

    @Override
    public JobConfigRes getJobConfig(long jobVersionId) throws JsonProcessingException {
        this.funcPermissionCheck("project:seatunnel-task:job-config-detail", 0);
        JobVersion jobVersion = this.jobVersionDao.getVersionById(jobVersionId);
        JobDefinition jobDefinition = this.jobDefinitionDao.getJob(jobVersion.getJobId());
        JobConfigRes jobConfigRes = new JobConfigRes();
        jobConfigRes.setName(jobDefinition.getName());
        jobConfigRes.setId(jobVersion.getId());
        jobConfigRes.setDescription(jobDefinition.getDescription());
        try {
            jobConfigRes.setEnv(StringUtils.isEmpty((CharSequence)jobVersion.getEnv()) ? null : (Map)OBJECT_MAPPER.readValue(jobVersion.getEnv(), Map.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        jobConfigRes.setEngine(EngineType.valueOf(jobVersion.getEngineName()));
        return jobConfigRes;
    }

    @Override
    @Transactional
    public void updateJobConfig(int userId, long jobVersionId, JobConfig jobConfig) throws JsonProcessingException {
        this.funcPermissionCheck("project:seatunnel-task:job-config-update", 0);
        JobVersion version = this.jobVersionDao.getVersionById(jobVersionId);
        JobDefinition jobDefinition = new JobDefinition();
        jobDefinition.setId(version.getJobId());
        jobDefinition.setUpdateUserId(userId);
        jobDefinition.setName(jobConfig.getName());
        jobDefinition.setDescription(jobConfig.getDescription());
        this.jobDefinitionDao.updateJob(jobDefinition);
        if (!jobConfig.getEnv().containsKey(JOB_MODE)) {
            throw new SeatunnelException(SeatunnelErrorEnum.ILLEGAL_STATE, new Object[]{"job mode is not set"});
        }
        JobMode jobMode = JobMode.valueOf((String)jobConfig.getEnv().get(JOB_MODE).toString());
        this.jobVersionDao.updateVersion(JobVersion.builder().jobId(version.getJobId()).id(version.getId()).jobMode(jobMode.name()).engineName(jobConfig.getEngine().name()).updateUserId(userId).env(OBJECT_MAPPER.writeValueAsString(jobConfig.getEnv())).build());
    }
}

