/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.permission;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.app.dal.dao.IDatasourceDao;
import org.apache.seatunnel.app.dal.entity.Datasource;
import org.apache.seatunnel.app.permission.AvailableResourceRangeService;
import org.apache.seatunnel.app.permission.enums.SeatunnelResourcePermissionModuleEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class AvailableResourceRangeServiceImpl
implements AvailableResourceRangeService,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvailableResourceRangeServiceImpl.class);
    private final Map<String, ResourcePermissionQuery> resourceQueryMap = new HashMap<String, ResourcePermissionQuery>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beansOfType = applicationContext.getBeansOfType(ResourcePermissionQuery.class);
        beansOfType.forEach((key, value) -> {
            List<String> typeList = value.accessTypes();
            if (typeList == null || typeList.isEmpty()) {
                return;
            }
            typeList.forEach(accessType -> this.resourceQueryMap.put(String.valueOf(accessType), (ResourcePermissionQuery)value));
        });
    }

    public List queryAvailableResourceRangeBySourceType(String resourceType, int userId) {
        ResourcePermissionQuery resourcePermissionQuery = this.resourceQueryMap.get(resourceType);
        if (resourcePermissionQuery == null) {
            LOGGER.warn("resource type {} query handle not init", (Object)resourceType);
            return Collections.emptyList();
        }
        return resourcePermissionQuery.queryByResourceType(userId);
    }

    static interface ResourcePermissionQuery<T> {
        public List<String> accessTypes();

        public List<T> queryByResourceType(int var1);
    }

    @Component
    public static class DataSourceQuery
    implements ResourcePermissionQuery<Long> {
        @Autowired
        @Qualifier(value="datasourceDaoImpl")
        private IDatasourceDao iDatasourceDao;

        @Override
        public List<String> accessTypes() {
            return Collections.singletonList(SeatunnelResourcePermissionModuleEnum.DATASOURCE.name());
        }

        @Override
        public List<Long> queryByResourceType(int userId) {
            List<Datasource> datasourceList = this.iDatasourceDao.selectDatasourceByUserId(userId);
            return datasourceList == null || datasourceList.isEmpty() ? Collections.emptyList() : datasourceList.stream().map(Datasource::getId).collect(Collectors.toList());
        }
    }
}

