/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dal.dao.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.List;
import javax.annotation.Resource;
import org.apache.seatunnel.app.dal.dao.IJobTaskDao;
import org.apache.seatunnel.app.dal.entity.JobTask;
import org.apache.seatunnel.app.dal.mapper.JobTaskMapper;
import org.springframework.stereotype.Repository;

@Repository
public class JobTaskDaoImpl
implements IJobTaskDao {
    @Resource
    private JobTaskMapper jobTaskMapper;

    @Override
    public List<JobTask> getTasksByVersionId(long jobVersionId) {
        return this.jobTaskMapper.selectList((Wrapper)Wrappers.lambdaQuery((Object)new JobTask()).eq(JobTask::getVersionId, (Object)jobVersionId));
    }

    @Override
    public void insertTask(JobTask jobTask) {
        if (jobTask != null) {
            this.jobTaskMapper.insert(jobTask);
        }
    }

    @Override
    public void updateTask(JobTask jobTask) {
        if (jobTask != null) {
            this.jobTaskMapper.updateById(jobTask);
        }
    }

    @Override
    public JobTask getTask(long jobVersionId, String pluginId) {
        return (JobTask)this.jobTaskMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)new JobTask()).eq(JobTask::getVersionId, (Object)jobVersionId)).and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)i.eq(JobTask::getPluginId, (Object)pluginId);
        }));
    }

    @Override
    public List<JobTask> getJobTaskByDataSourceId(long datasourceId) {
        return this.jobTaskMapper.selectList((Wrapper)Wrappers.lambdaQuery((Object)new JobTask()).eq(JobTask::getDataSourceId, (Object)datasourceId));
    }

    @Override
    public void updateTasks(List<JobTask> jobTasks) {
        jobTasks.forEach(arg_0 -> ((JobTaskMapper)this.jobTaskMapper).updateById(arg_0));
    }

    @Override
    public void deleteTasks(List<Long> jobTaskIds) {
        if (!jobTaskIds.isEmpty()) {
            this.jobTaskMapper.deleteBatchIds(jobTaskIds);
        }
    }

    @Override
    public void deleteTask(long jobVersionId, String pluginId) {
        this.jobTaskMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)new JobTask()).eq(JobTask::getVersionId, (Object)jobVersionId)).and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)i.eq(JobTask::getPluginId, (Object)pluginId);
        }));
    }

    @Override
    public void deleteTaskByVersionId(long id) {
        this.jobTaskMapper.delete((Wrapper)Wrappers.lambdaQuery((Object)new JobTask()).eq(JobTask::getVersionId, (Object)id));
    }
}

