/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dal.dao.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.app.dal.dao.IJobDefinitionDao;
import org.apache.seatunnel.app.dal.entity.JobDefinition;
import org.apache.seatunnel.app.dal.mapper.JobMapper;
import org.apache.seatunnel.app.domain.response.PageInfo;
import org.springframework.stereotype.Repository;

@Repository
public class JobDefinitionDaoImpl
implements IJobDefinitionDao {
    @Resource
    private JobMapper jobMapper;

    @Override
    public void add(JobDefinition job) {
        this.jobMapper.insert(job);
    }

    @Override
    public JobDefinition getJob(long id) {
        return (JobDefinition)this.jobMapper.selectById(Long.valueOf(id));
    }

    @Override
    public void updateJob(JobDefinition jobDefinition) {
        this.jobMapper.updateById(jobDefinition);
    }

    @Override
    public PageInfo<JobDefinition> getJob(String searchName, Integer pageNo, Integer pageSize, String jobMode) {
        IPage<JobDefinition> jobDefinitionIPage = StringUtils.isEmpty((CharSequence)jobMode) ? this.jobMapper.queryJobListPaging((IPage<JobDefinition>)new Page((long)pageNo.intValue(), (long)pageSize.intValue()), searchName) : this.jobMapper.queryJobListPagingWithJobMode((IPage<JobDefinition>)new Page((long)pageNo.intValue(), (long)pageSize.intValue()), searchName, jobMode);
        PageInfo<JobDefinition> jobs = new PageInfo<JobDefinition>();
        jobs.setData(jobDefinitionIPage.getRecords());
        jobs.setPageSize(pageSize);
        jobs.setPageNo(pageNo);
        jobs.setTotalCount((int)jobDefinitionIPage.getTotal());
        return jobs;
    }

    @Override
    public List<JobDefinition> getJobList(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.jobMapper.queryJobList(name);
    }

    @Override
    public JobDefinition getJobByName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.jobMapper.queryJob(name);
    }

    @Override
    public void delete(long id) {
        this.jobMapper.delete((Wrapper)Wrappers.lambdaQuery((Object)new JobDefinition()).and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)i.eq(JobDefinition::getId, (Object)id);
        }));
    }
}

