/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.translation.source;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.seatunnel.api.source.SourceEvent;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.translation.source.ParallelSource;

public class ParallelEnumeratorContext<SplitT extends SourceSplit>
implements SourceSplitEnumerator.Context<SplitT> {
    protected final ParallelSource<?, SplitT, ?> parallelSource;
    protected final Integer parallelism;
    protected final Integer subtaskId;
    protected volatile boolean running = false;

    public ParallelEnumeratorContext(ParallelSource<?, SplitT, ?> parallelSource, int parallelism, int subtaskId) {
        this.parallelSource = parallelSource;
        this.parallelism = parallelism;
        this.subtaskId = subtaskId;
    }

    @Override
    public int currentParallelism() {
        return this.running ? this.parallelism : 0;
    }

    @Override
    public Set<Integer> registeredReaders() {
        return this.running ? Collections.singleton(this.subtaskId) : Collections.emptySet();
    }

    public void register() {
        this.running = true;
    }

    @Override
    public void assignSplit(int subtaskId, List<SplitT> splits) {
        if (this.subtaskId == subtaskId) {
            this.parallelSource.addSplits(splits);
        }
    }

    @Override
    public void signalNoMoreSplits(int subtaskId) {
        if (this.subtaskId == subtaskId) {
            this.parallelSource.handleNoMoreSplits();
        }
    }

    @Override
    public void sendEventToSourceReader(int subtaskId, SourceEvent event) {
        throw new RuntimeException("");
    }
}

