/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.plugin.discovery;

import java.util.Objects;

public class PluginIdentifier {
    private final String engineType;
    private final String pluginType;
    private final String pluginName;

    private PluginIdentifier(String engineType, String pluginType, String pluginName) {
        this.engineType = engineType;
        this.pluginType = pluginType;
        this.pluginName = pluginName;
    }

    public static PluginIdentifier of(String engineType, String pluginType, String pluginName) {
        return new PluginIdentifier(engineType, pluginType, pluginName);
    }

    public String getEngineType() {
        return this.engineType;
    }

    public String getPluginType() {
        return this.pluginType;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginIdentifier that = (PluginIdentifier)o;
        if (!Objects.equals(this.engineType, that.engineType)) {
            return false;
        }
        if (!Objects.equals(this.pluginType, that.pluginType)) {
            return false;
        }
        return Objects.equals(this.pluginName, that.pluginName);
    }

    public int hashCode() {
        int result2 = this.engineType != null ? this.engineType.hashCode() : 0;
        result2 = 31 * result2 + (this.pluginType != null ? this.pluginType.hashCode() : 0);
        result2 = 31 * result2 + (this.pluginName != null ? this.pluginName.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "PluginIdentifier{engineType='" + this.engineType + '\'' + ", pluginType='" + this.pluginType + '\'' + ", pluginName='" + this.pluginName + '\'' + '}';
    }
}

