/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.spark.execution;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.core.starter.exception.TaskExecuteException;
import org.apache.seatunnel.core.starter.spark.execution.AbstractPluginExecuteProcessor;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSinkPluginDiscovery;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.spark.SparkEnvironment;
import org.apache.seatunnel.translation.spark.common.utils.TypeConverterUtils;
import org.apache.seatunnel.translation.spark.sink.SparkSinkInjector;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;

public class SinkExecuteProcessor
extends AbstractPluginExecuteProcessor<SeaTunnelSink<?, ?, ?, ?>> {
    private static final String PLUGIN_TYPE = "sink";

    protected SinkExecuteProcessor(SparkEnvironment sparkEnvironment, JobContext jobContext, List<? extends Config> pluginConfigs) {
        super(sparkEnvironment, jobContext, pluginConfigs);
    }

    @Override
    protected List<SeaTunnelSink<?, ?, ?, ?>> initializePlugins(List<? extends Config> pluginConfigs) {
        SeaTunnelSinkPluginDiscovery sinkPluginDiscovery = new SeaTunnelSinkPluginDiscovery();
        ArrayList<URL> pluginJars = new ArrayList<URL>();
        List<SeaTunnelSink<?, ?, ?, ?>> sinks = pluginConfigs.stream().map(sinkConfig -> {
            PluginIdentifier pluginIdentifier = PluginIdentifier.of("seatunnel", PLUGIN_TYPE, sinkConfig.getString("plugin_name"));
            pluginJars.addAll(sinkPluginDiscovery.getPluginJarPaths(Lists.newArrayList(pluginIdentifier)));
            SeaTunnelSink seaTunnelSink = (SeaTunnelSink)sinkPluginDiscovery.createPluginInstance(pluginIdentifier);
            seaTunnelSink.prepare((Config)sinkConfig);
            seaTunnelSink.setJobContext(this.jobContext);
            return seaTunnelSink;
        }).distinct().collect(Collectors.toList());
        this.sparkEnvironment.registerPlugin(pluginJars);
        return sinks;
    }

    @Override
    public List<Dataset<Row>> execute(List<Dataset<Row>> upstreamDataStreams) throws TaskExecuteException {
        Dataset<Row> input2 = upstreamDataStreams.get(0);
        for (int i = 0; i < this.plugins.size(); ++i) {
            Config sinkConfig = (Config)this.pluginConfigs.get(i);
            SeaTunnelSink seaTunnelSink = (SeaTunnelSink)this.plugins.get(i);
            Dataset<Row> dataset = this.fromSourceTable(sinkConfig, this.sparkEnvironment).orElse(input2);
            seaTunnelSink.setTypeInfo((SeaTunnelRowType)TypeConverterUtils.convert((DataType)dataset.schema()));
            SparkSinkInjector.inject((DataFrameWriter<Row>)dataset.write(), seaTunnelSink).option("checkpointLocation", "/tmp").save();
        }
        return null;
    }
}

