/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.configuration.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.Condition;
import org.apache.seatunnel.api.configuration.util.Expression;
import org.apache.seatunnel.api.configuration.util.OptionValidationException;
import org.apache.seatunnel.api.configuration.util.RequiredOption;

public class OptionRule {
    private final Set<Option<?>> optionalOptions;
    private final Set<RequiredOption> requiredOptions;

    OptionRule(Set<Option<?>> optionalOptions, Set<RequiredOption> requiredOptions) {
        this.optionalOptions = optionalOptions;
        this.requiredOptions = requiredOptions;
    }

    public Set<Option<?>> getOptionalOptions() {
        return this.optionalOptions;
    }

    public Set<RequiredOption> getRequiredOptions() {
        return this.requiredOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OptionRule)) {
            return false;
        }
        OptionRule that = (OptionRule)o;
        return Objects.equals(this.optionalOptions, that.optionalOptions) && Objects.equals(this.requiredOptions, that.requiredOptions);
    }

    public int hashCode() {
        return Objects.hash(this.optionalOptions, this.requiredOptions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<Option<?>> optionalOptions = new HashSet();
        private final Set<RequiredOption> requiredOptions = new HashSet<RequiredOption>();

        private Builder() {
        }

        public Builder optional(Option<?> ... options) {
            for (Option<?> option : options) {
                if (option.defaultValue() != null) continue;
                throw new OptionValidationException(String.format("Optional option '%s' should have default value.", option.key()));
            }
            this.optionalOptions.addAll(Arrays.asList(options));
            return this;
        }

        public Builder required(Option<?> ... options) {
            for (Option<?> option : options) {
                this.verifyRequiredOptionDefaultValue(option);
                this.requiredOptions.add(RequiredOption.AbsolutelyRequiredOption.of(option));
            }
            return this;
        }

        public Builder exclusive(Option<?> ... options) {
            if (options.length <= 1) {
                throw new OptionValidationException("The number of exclusive options must be greater than 1.");
            }
            for (Option<?> option : options) {
                this.verifyRequiredOptionDefaultValue(option);
            }
            this.requiredOptions.add(RequiredOption.ExclusiveRequiredOptions.of(options));
            return this;
        }

        public <T> Builder conditional(Option<T> option, T expectValue, Option<?> ... requiredOptions) {
            return this.conditional(Condition.of(option, expectValue), requiredOptions);
        }

        public Builder conditional(Condition<?> condition, Option<?> ... requiredOptions) {
            return this.conditional(Expression.of(condition), requiredOptions);
        }

        public Builder conditional(Expression expression, Option<?> ... requiredOptions) {
            for (Option<?> o : requiredOptions) {
                this.verifyRequiredOptionDefaultValue(o);
            }
            this.requiredOptions.add(RequiredOption.ConditionalRequiredOptions.of(expression, new HashSet(Arrays.asList(requiredOptions))));
            return this;
        }

        public OptionRule build() {
            return new OptionRule(this.optionalOptions, this.requiredOptions);
        }

        private void verifyRequiredOptionDefaultValue(Option<?> option) {
            if (option.defaultValue() != null) {
                throw new OptionValidationException(String.format("Required option '%s' should have no default value.", option.key()));
            }
        }
    }
}

