/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.filestore.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.datastream.SupportedDataStreamType;
import org.apache.ratis.examples.common.SubCommandBase;
import org.apache.ratis.examples.filestore.FileStoreStateMachine;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.metrics.impl.JvmMetrics;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.NetUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;

@Parameters(commandDescription="Start an filestore server")
public class Server
extends SubCommandBase {
    @Parameter(names={"--id", "-i"}, description="Raft id of this server", required=true)
    private String id;
    @Parameter(names={"--storage", "-s"}, description="Storage dir, eg. --storage dir1 --storage dir2", required=true)
    private List<File> storageDir = new ArrayList<File>();
    @Parameter(names={"--writeThreadNum"}, description="Number of write thread")
    private int writeThreadNum = 20;
    @Parameter(names={"--readThreadNum"}, description="Number of read thread")
    private int readThreadNum = 20;
    @Parameter(names={"--commitThreadNum"}, description="Number of commit thread")
    private int commitThreadNum = 3;
    @Parameter(names={"--deleteThreadNum"}, description="Number of delete thread")
    private int deleteThreadNum = 3;

    @Override
    public void run() throws Exception {
        JvmMetrics.initJvmMetrics(TimeDuration.valueOf(10L, TimeUnit.SECONDS));
        RaftPeerId peerId = RaftPeerId.valueOf(this.id);
        RaftProperties properties = new RaftProperties();
        RaftServerConfigKeys.Rpc.setTimeoutMin(properties, TimeDuration.valueOf(2L, TimeUnit.SECONDS));
        RaftServerConfigKeys.Rpc.setTimeoutMax(properties, TimeDuration.valueOf(3L, TimeUnit.SECONDS));
        int port = NetUtils.createSocketAddr(this.getPeer(peerId).getAddress()).getPort();
        GrpcConfigKeys.Server.setPort(properties, port);
        Optional.ofNullable(this.getPeer(peerId).getClientAddress()).ifPresent(address -> GrpcConfigKeys.Client.setPort(properties, NetUtils.createSocketAddr(address).getPort()));
        Optional.ofNullable(this.getPeer(peerId).getAdminAddress()).ifPresent(address -> GrpcConfigKeys.Admin.setPort(properties, NetUtils.createSocketAddr(address).getPort()));
        String dataStreamAddress = this.getPeer(peerId).getDataStreamAddress();
        if (dataStreamAddress != null) {
            int dataStreamport = NetUtils.createSocketAddr(dataStreamAddress).getPort();
            NettyConfigKeys.DataStream.setPort(properties, dataStreamport);
            RaftConfigKeys.DataStream.setType(properties, SupportedDataStreamType.NETTY);
        }
        RaftServerConfigKeys.setStorageDir(properties, this.storageDir);
        RaftServerConfigKeys.Write.setElementLimit(properties, 40960);
        RaftServerConfigKeys.Write.setByteLimit(properties, SizeInBytes.valueOf("1000MB"));
        ConfUtils.setFiles(properties::setFiles, "example.filestore.statemachine.dir", this.storageDir, new BiConsumer[0]);
        RaftServerConfigKeys.DataStream.setAsyncRequestThreadPoolSize(properties, this.writeThreadNum);
        RaftServerConfigKeys.DataStream.setAsyncWriteThreadPoolSize(properties, this.writeThreadNum);
        ConfUtils.setInt(properties::setInt, "example.filestore.statemachine.write.thread.num", this.writeThreadNum, new BiConsumer[0]);
        ConfUtils.setInt(properties::setInt, "example.filestore.statemachine.read.thread.num", this.readThreadNum, new BiConsumer[0]);
        ConfUtils.setInt(properties::setInt, "example.filestore.statemachine.commit.thread.num", this.commitThreadNum, new BiConsumer[0]);
        ConfUtils.setInt(properties::setInt, "example.filestore.statemachine.delete.thread.num", this.deleteThreadNum, new BiConsumer[0]);
        FileStoreStateMachine stateMachine = new FileStoreStateMachine(properties);
        RaftGroup raftGroup = RaftGroup.valueOf(RaftGroupId.valueOf(ByteString.copyFromUtf8(this.getRaftGroupId())), this.getPeers());
        RaftServer raftServer = RaftServer.newBuilder().setServerId(RaftPeerId.valueOf(this.id)).setStateMachine(stateMachine).setProperties(properties).setGroup(raftGroup).build();
        raftServer.start();
        while (raftServer.getLifeCycleState() != LifeCycle.State.CLOSED) {
            TimeUnit.SECONDS.sleep(1L);
        }
    }
}

