/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.util.AwaitForSignal;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwaitToRun
implements AutoCloseable {
    public static final Logger LOG = LoggerFactory.getLogger(AwaitToRun.class);
    private final String name;
    private final AwaitForSignal awaitForSignal;
    private final AtomicReference<Daemon> daemon;

    public AwaitToRun(Object namePrefix, Runnable runMethod) {
        this.name = namePrefix + "-" + JavaUtils.getClassSimpleName(this.getClass());
        this.awaitForSignal = new AwaitForSignal(this.name);
        this.daemon = new AtomicReference<Daemon>(Daemon.newBuilder().setName(this.name).setRunnable(new RunnableImpl(runMethod)).build());
    }

    public AwaitToRun start() {
        Daemon d = this.daemon.get();
        if (d != null) {
            d.start();
            LOG.info("{} started", (Object)d);
        } else {
            LOG.warn("{} is already closed", (Object)this.name);
        }
        return this;
    }

    public void signal() {
        this.awaitForSignal.signal();
    }

    @Override
    public void close() {
        Daemon d = this.daemon.getAndSet(null);
        if (d == null) {
            return;
        }
        d.interrupt();
        try {
            d.join();
        }
        catch (InterruptedException e) {
            LOG.warn(d + ": join is interrupted", e);
            Thread.currentThread().interrupt();
        }
    }

    public String toString() {
        return this.name;
    }

    private final class RunnableImpl
    implements Runnable {
        private final Runnable runMethod;

        private RunnableImpl(Runnable runMethod) {
            this.runMethod = runMethod;
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    AwaitToRun.this.awaitForSignal.await();
                }
                catch (InterruptedException e) {
                    LOG.info("{} is interrupted", (Object)AwaitToRun.this.awaitForSignal);
                    Thread.currentThread().interrupt();
                    return;
                }
                try {
                    this.runMethod.run();
                }
                catch (Throwable t2) {
                    LOG.error(AwaitToRun.this.name + ": runMethod failed", t2);
                }
            }
        }
    }
}

