/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics.impl;

import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.impl.RatisMetricRegistryImpl;
import org.apache.ratis.thirdparty.com.codahale.metrics.MetricSet;
import org.apache.ratis.thirdparty.com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import org.apache.ratis.thirdparty.com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import org.apache.ratis.thirdparty.com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import org.apache.ratis.thirdparty.com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import org.apache.ratis.util.TimeDuration;

public interface JvmMetrics {
    public static void initJvmMetrics(TimeDuration consoleReportRate) {
        MetricRegistries registries = MetricRegistries.global();
        JvmMetrics.addJvmMetrics(registries);
        registries.enableConsoleReporter(consoleReportRate);
        registries.enableJmxReporter();
    }

    public static void addJvmMetrics(MetricRegistries registries) {
        MetricRegistryInfo info = new MetricRegistryInfo("jvm", "ratis_jvm", "jvm", "jvm metrics");
        RatisMetricRegistry registry = registries.create(info);
        RatisMetricRegistryImpl impl = RatisMetricRegistryImpl.cast(registry);
        impl.registerAll("gc", (MetricSet)new GarbageCollectorMetricSet());
        impl.registerAll("memory", (MetricSet)new MemoryUsageGaugeSet());
        impl.registerAll("threads", (MetricSet)new ThreadStatesGaugeSet());
        impl.registerAll("classLoading", (MetricSet)new ClassLoadingGaugeSet());
    }
}

