/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import org.apache.ratis.util.StringUtils;

public enum TraditionalBinaryPrefix {
    KILO(10),
    MEGA(TraditionalBinaryPrefix.KILO.bitShift + 10),
    GIGA(TraditionalBinaryPrefix.MEGA.bitShift + 10),
    TERA(TraditionalBinaryPrefix.GIGA.bitShift + 10),
    PETA(TraditionalBinaryPrefix.TERA.bitShift + 10),
    EXA(TraditionalBinaryPrefix.PETA.bitShift + 10);

    private final long value;
    private final char symbol;
    private final int bitShift;
    private final long bitMask;

    private TraditionalBinaryPrefix(int bitShift) {
        this.bitShift = bitShift;
        this.value = 1L << bitShift;
        this.bitMask = this.value - 1L;
        this.symbol = this.toString().charAt(0);
    }

    public long getValue() {
        return this.value;
    }

    public char getSymbol() {
        return this.symbol;
    }

    public long toLong(long n) {
        long shifted = n << this.bitShift;
        if (n != shifted >>> this.bitShift) {
            throw new ArithmeticException("Long overflow: " + this.toString(n) + " cannot be assigned to a long.");
        }
        return shifted;
    }

    public String toString(long n) {
        return n + String.valueOf(this.symbol);
    }

    public static TraditionalBinaryPrefix valueOf(char symbol) {
        symbol = Character.toUpperCase(symbol);
        for (TraditionalBinaryPrefix prefix : TraditionalBinaryPrefix.values()) {
            if (symbol != prefix.symbol) continue;
            return prefix;
        }
        throw new IllegalArgumentException("Unknown symbol '" + symbol + "'");
    }

    public static long string2long(String s2) {
        long p;
        int lastpos;
        char lastchar = (s2 = s2.trim().replace("_", "")).charAt(lastpos = s2.length() - 1);
        if (Character.isDigit(lastchar)) {
            return Long.parseLong(s2);
        }
        try {
            p = TraditionalBinaryPrefix.valueOf((char)lastchar).value;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid size prefix '" + lastchar + "' in '" + s2 + "'. Allowed prefixes are k, m, g, t, p, e (case insensitive)");
        }
        long num = Long.parseLong(s2.substring(0, lastpos).trim());
        if (num > Long.MAX_VALUE / p || num < Long.MIN_VALUE / p) {
            throw new IllegalArgumentException(s2 + " does not fit in a Long");
        }
        return num * p;
    }

    public static String long2String(long n, String unit, int decimalPlaces) {
        int i;
        if (unit == null) {
            unit = "";
        }
        if (n == Long.MIN_VALUE) {
            return "-8 " + TraditionalBinaryPrefix.EXA.symbol + unit;
        }
        StringBuilder b = new StringBuilder();
        if (n < 0L) {
            b.append('-');
            n = -n;
        }
        if (n < TraditionalBinaryPrefix.KILO.value) {
            b.append(n);
            return (unit.isEmpty() ? b : b.append(" ").append(unit)).toString();
        }
        for (i = 0; i < TraditionalBinaryPrefix.values().length && n >= TraditionalBinaryPrefix.values()[i].value; ++i) {
        }
        TraditionalBinaryPrefix prefix = TraditionalBinaryPrefix.values()[i - 1];
        if ((n & prefix.bitMask) == 0L) {
            b.append(n >> prefix.bitShift);
        } else {
            String format = "%." + decimalPlaces + "f";
            String s2 = StringUtils.format(format, (double)n / (double)prefix.value);
            if (s2.startsWith("1024")) {
                prefix = TraditionalBinaryPrefix.values()[i];
                s2 = StringUtils.format(format, (double)n / (double)prefix.value);
            }
            b.append(s2);
        }
        return b.append(' ').append(prefix.symbol).append(unit).toString();
    }

    public static String long2String(long n) {
        return TraditionalBinaryPrefix.long2String(n, "", 3);
    }
}

