/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.server.DivisionProperties;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;

class DivisionPropertiesImpl
implements DivisionProperties {
    private final TimeDuration rpcTimeoutMin;
    private final TimeDuration rpcTimeoutMax;
    private final TimeDuration rpcSleepTime;
    private final TimeDuration rpcSlownessTimeout;

    DivisionPropertiesImpl(RaftProperties properties) {
        this.rpcTimeoutMin = RaftServerConfigKeys.Rpc.timeoutMin(properties);
        this.rpcTimeoutMax = RaftServerConfigKeys.Rpc.timeoutMax(properties);
        Preconditions.assertTrue(this.rpcTimeoutMax.compareTo(this.rpcTimeoutMin) >= 0, "rpcTimeoutMax = %s < rpcTimeoutMin = %s", this.rpcTimeoutMax, this.rpcTimeoutMin);
        this.rpcSleepTime = RaftServerConfigKeys.Rpc.sleepTime(properties);
        this.rpcSlownessTimeout = RaftServerConfigKeys.Rpc.slownessTimeout(properties);
    }

    @Override
    public TimeDuration minRpcTimeout() {
        return this.rpcTimeoutMin;
    }

    @Override
    public TimeDuration maxRpcTimeout() {
        return this.rpcTimeoutMax;
    }

    @Override
    public TimeDuration rpcSleepTime() {
        return this.rpcSleepTime;
    }

    @Override
    public TimeDuration rpcSlownessTimeout() {
        return this.rpcSlownessTimeout;
    }
}

