/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.types.transport;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transport.DeliveryState;
import org.apache.qpid.protonj2.types.transport.Performative;
import org.apache.qpid.protonj2.types.transport.Role;

public final class Disposition
implements Performative {
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(21L);
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:disposition:list");
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private static final int ROLE = 1;
    private static final int FIRST = 2;
    private static final int LAST = 4;
    private static final int SETTLED = 8;
    private static final int STATE = 16;
    private static final int BATCHABLE = 32;
    private int modified = 0;
    private Role role = Role.SENDER;
    private long first;
    private long last;
    private boolean settled;
    private DeliveryState state;
    private boolean batchable;

    public boolean isEmpty() {
        return this.modified == 0;
    }

    public int getElementCount() {
        return 32 - Integer.numberOfLeadingZeros(this.modified);
    }

    public boolean hasElement(int index) {
        int value = 1 << index;
        return (this.modified & value) == value;
    }

    public boolean hasRole() {
        return (this.modified & 1) == 1;
    }

    public boolean hasFirst() {
        return (this.modified & 2) == 2;
    }

    public boolean hasLast() {
        return (this.modified & 4) == 4;
    }

    public boolean hasSettled() {
        return (this.modified & 8) == 8;
    }

    public boolean hasState() {
        return (this.modified & 0x10) == 16;
    }

    public boolean hasBatchable() {
        return (this.modified & 0x20) == 32;
    }

    public Role getRole() {
        return this.role;
    }

    public Disposition setRole(Role role) {
        if (role == null) {
            throw new NullPointerException("Role cannot be null");
        }
        this.modified |= 1;
        this.role = role;
        return this;
    }

    public Disposition clearRole() {
        this.modified &= 0xFFFFFFFE;
        this.role = Role.SENDER;
        return this;
    }

    public long getFirst() {
        return this.first;
    }

    public Disposition setFirst(int first) {
        this.modified |= 2;
        this.first = Integer.toUnsignedLong(first);
        return this;
    }

    public Disposition setFirst(long first) {
        if (first < 0L || first > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("First value given is out of range: " + first);
        }
        this.modified |= 2;
        this.first = first;
        return this;
    }

    public Disposition clearFirst() {
        this.modified &= 0xFFFFFFFD;
        this.first = 0L;
        return this;
    }

    public long getLast() {
        return this.last;
    }

    public Disposition setLast(int last) {
        this.modified |= 4;
        this.last = Integer.toUnsignedLong(last);
        return this;
    }

    public Disposition setLast(long last) {
        if (last < 0L || last > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Last value given is out of range: " + last);
        }
        this.modified |= 4;
        this.last = last;
        return this;
    }

    public Disposition clearLast() {
        this.modified &= 0xFFFFFFFB;
        this.last = 0L;
        return this;
    }

    public boolean getSettled() {
        return this.settled;
    }

    public Disposition setSettled(boolean settled) {
        this.modified |= 8;
        this.settled = settled;
        return this;
    }

    public Disposition clearSettled() {
        this.modified &= 0xFFFFFFF7;
        this.settled = false;
        return this;
    }

    public DeliveryState getState() {
        return this.state;
    }

    public Disposition setState(DeliveryState state) {
        this.modified = state != null ? (this.modified |= 0x10) : (this.modified &= 0xFFFFFFEF);
        this.state = state;
        return this;
    }

    public Disposition clearState() {
        this.modified &= 0xFFFFFFEF;
        this.state = null;
        return this;
    }

    public boolean getBatchable() {
        return this.batchable;
    }

    public Disposition setBatchable(boolean batchable) {
        this.modified |= 0x20;
        this.batchable = batchable;
        return this;
    }

    public Disposition clearBatchable() {
        this.modified &= 0xFFFFFFDF;
        this.batchable = false;
        return this;
    }

    public Disposition reset() {
        this.modified = 0;
        this.role = Role.SENDER;
        this.first = 0L;
        this.last = 0L;
        this.settled = false;
        this.state = null;
        this.batchable = false;
        return this;
    }

    @Override
    public Disposition copy() {
        Disposition copy = new Disposition();
        copy.role = this.role;
        copy.first = this.first;
        copy.last = this.last;
        copy.settled = this.settled;
        copy.state = this.state;
        copy.batchable = this.batchable;
        copy.modified = this.modified;
        return copy;
    }

    @Override
    public Performative.PerformativeType getPerformativeType() {
        return Performative.PerformativeType.DISPOSITION;
    }

    @Override
    public <E> void invoke(Performative.PerformativeHandler<E> handler, ProtonBuffer payload, int channel, E context) {
        handler.handleDisposition(this, payload, channel, context);
    }

    public String toString() {
        return "Disposition{role=" + this.role + ", first=" + this.first + ", last=" + this.last + ", settled=" + this.settled + ", state=" + this.state + ", batchable=" + this.batchable + "}";
    }
}

