/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.jms.ConnectionURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CloseWhenNoRouteSettingsHelper {
    private static final Logger _log = LoggerFactory.getLogger(CloseWhenNoRouteSettingsHelper.class);

    CloseWhenNoRouteSettingsHelper() {
    }

    public void setClientProperties(FieldTable clientProperties, ConnectionURL url, FieldTable serverProperties) {
        boolean brokerSupportsCloseWhenNoRoute = serverProperties != null && serverProperties.containsKey("qpid.close_when_no_route");
        boolean brokerCloseWhenNoRoute = brokerSupportsCloseWhenNoRoute && Boolean.parseBoolean(serverProperties.getString("qpid.close_when_no_route"));
        String closeWhenNoRouteOption = url.getOption("closeWhenNoRoute");
        if (closeWhenNoRouteOption != null) {
            if (brokerSupportsCloseWhenNoRoute) {
                boolean desiredCloseWhenNoRoute = Boolean.valueOf(closeWhenNoRouteOption);
                if (desiredCloseWhenNoRoute != brokerCloseWhenNoRoute) {
                    clientProperties.setBoolean("qpid.close_when_no_route", (Boolean)desiredCloseWhenNoRoute);
                    _log.debug("Set client property {} to {}", (Object)"qpid.close_when_no_route", (Object)desiredCloseWhenNoRoute);
                } else {
                    _log.debug("Client's desired {} value {} already matches the server's", (Object)"closeWhenNoRoute", (Object)desiredCloseWhenNoRoute);
                }
            } else {
                _log.warn("The broker being connected to does not support the closeWhenNoRoute option");
            }
        }
    }
}

