/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import org.apache.pulsar.common.functions.BatchingConfig;
import org.apache.pulsar.functions.proto.Function;

public final class BatchingUtils {
    public static Function.BatchingSpec convert(BatchingConfig config) {
        if (config == null) {
            return null;
        }
        Function.BatchingSpec.Builder builder = Function.BatchingSpec.newBuilder().setEnabled(config.isEnabled());
        if (config.getBatchingMaxPublishDelayMs() != null && config.getBatchingMaxPublishDelayMs() > 0) {
            builder.setBatchingMaxPublishDelayMs(config.getBatchingMaxPublishDelayMs().intValue());
        }
        if (config.getRoundRobinRouterBatchingPartitionSwitchFrequency() != null && config.getRoundRobinRouterBatchingPartitionSwitchFrequency() > 0) {
            builder.setRoundRobinRouterBatchingPartitionSwitchFrequency(config.getRoundRobinRouterBatchingPartitionSwitchFrequency().intValue());
        }
        if (config.getBatchingMaxMessages() != null && config.getBatchingMaxMessages() > 0) {
            builder.setBatchingMaxMessages(config.getBatchingMaxMessages().intValue());
        }
        if (config.getBatchingMaxBytes() != null && config.getBatchingMaxBytes() > 0) {
            builder.setBatchingMaxBytes(config.getBatchingMaxBytes().intValue());
        }
        if (config.getBatchBuilder() != null && !config.getBatchBuilder().isEmpty()) {
            builder.setBatchBuilder(config.getBatchBuilder());
        }
        return builder.build();
    }

    public static BatchingConfig convertFromSpec(Function.BatchingSpec spec) {
        if (spec == null || spec.toString().equals("")) {
            return BatchingConfig.builder().enabled(true).batchingMaxPublishDelayMs(Integer.valueOf(10)).build();
        }
        BatchingConfig.BatchingConfigBuilder builder = BatchingConfig.builder().enabled(spec.getEnabled());
        if (spec.getBatchingMaxPublishDelayMs() > 0) {
            builder.batchingMaxPublishDelayMs(Integer.valueOf(spec.getBatchingMaxPublishDelayMs()));
        }
        if (spec.getRoundRobinRouterBatchingPartitionSwitchFrequency() > 0) {
            builder.roundRobinRouterBatchingPartitionSwitchFrequency(Integer.valueOf(spec.getRoundRobinRouterBatchingPartitionSwitchFrequency()));
        }
        if (spec.getBatchingMaxMessages() > 0) {
            builder.batchingMaxMessages(Integer.valueOf(spec.getBatchingMaxMessages()));
        }
        if (spec.getBatchingMaxBytes() > 0) {
            builder.batchingMaxBytes(Integer.valueOf(spec.getBatchingMaxBytes()));
        }
        if (spec.getBatchBuilder() != null && !spec.getBatchBuilder().isEmpty()) {
            builder.batchBuilder(spec.getBatchBuilder());
        }
        return builder.build();
    }
}

