/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator;

import com.google.common.annotations.Beta;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorStats;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStoreAttributes;
import org.apache.pulsar.transaction.coordinator.TransactionSubscription;
import org.apache.pulsar.transaction.coordinator.TxnMeta;
import org.apache.pulsar.transaction.coordinator.impl.TransactionMetadataStoreStats;
import org.apache.pulsar.transaction.coordinator.proto.TxnStatus;

@Beta
public interface TransactionMetadataStore {
    default public CompletableFuture<TxnStatus> getTxnStatus(TxnID txnid) {
        return this.getTxnMeta(txnid).thenApply(TxnMeta::status);
    }

    public CompletableFuture<TxnMeta> getTxnMeta(TxnID var1);

    public CompletableFuture<TxnID> newTransaction(long var1, String var3);

    public CompletableFuture<Void> addProducedPartitionToTxn(TxnID var1, List<String> var2);

    public CompletableFuture<Void> addAckedPartitionToTxn(TxnID var1, List<TransactionSubscription> var2);

    public CompletableFuture<Void> updateTxnStatus(TxnID var1, TxnStatus var2, TxnStatus var3, boolean var4);

    default public long getLowWaterMark() {
        return Long.MIN_VALUE;
    }

    public TransactionCoordinatorID getTransactionCoordinatorID();

    public TransactionCoordinatorStats getCoordinatorStats();

    public CompletableFuture<Void> closeAsync();

    public TransactionMetadataStoreStats getMetadataStoreStats();

    default public TransactionMetadataStoreAttributes getAttributes() {
        return new TransactionMetadataStoreAttributes(this);
    }

    public List<TxnMeta> getSlowTransactions(long var1);
}

